/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.VerificationException;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.engine.task.TaskUsersWithSameID;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskUserExistence
extends PeerCompatibleTask {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1059", false);
    private String m_user;

    public TaskUserExistence(String user) {
        this.m_user = user;
    }

    public boolean performTask() {
        String oraDevEnv;
        ErrorDescription errDesc;
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet usrRsltSet = new ResultSet();
        globalExec.checkUser(this.m_nodeList, this.m_user, usrRsltSet);
        this.m_resultSet.uploadResultSet(usrRsltSet);
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_user}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.COMMENT);
        Hashtable<Object, Vector<Object>> usrIdTable = new Hashtable<Object, Vector<Object>>();
        String usrID = new String("");
        Hashtable ht = usrRsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String usrStatus;
            String comment;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                comment = ReportUtil.PASSED;
                usrID = (String)result.getResultInfoSet().elementAt(1);
                usrStatus = ReportUtil.EXIST + "(" + usrID + ")";
                VerificationUtil.updateResultMap(usrIdTable, usrID, node);
            } else if (result.getStatus() == 3) {
                usrStatus = ReportUtil.NOTEXIST;
                comment = ReportUtil.FAILED;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7537", true, (Object[])new String[]{this.m_user, node}), s_msgBundle, "7537");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                if (this.isFixupReqd()) {
                    // empty if block
                }
            } else {
                usrStatus = ReportUtil.UNKNOWN;
                comment = ReportUtil.UNKNOWN;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7538", true, (Object[])new String[]{node}), s_msgBundle, "7538");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
            }
            ReportUtil.writeRecord(node, usrStatus, comment);
        }
        if (usrIdTable.size() > 1) {
            String errorMsg = s_msgBundle.getMessage("4123", true, (Object[])new String[]{this.m_user});
            ReportUtil.printError(errorMsg);
            errDesc = new ErrorDescription(errorMsg, s_msgBundle, "4123");
            this.m_resultSet.addErrorDescription(errDesc);
            e = usrIdTable.keys();
            StringBuffer usrIdsDisplayString = new StringBuffer();
            boolean first = true;
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Vector<Object> nodeVector = usrIdTable.get(key);
                String nodes = VerificationUtil.strVect2List(nodeVector);
                if (first) {
                    first = false;
                    usrIdsDisplayString.append("[");
                } else {
                    usrIdsDisplayString.append("; ");
                }
                usrIdsDisplayString.append(key + ":" + nodes);
                String errorMessage = s_msgBundle.getMessage("4124", false, (Object[])new String[]{key, nodes});
                ReportUtil.sureprintln(errorMessage);
            }
            usrIdsDisplayString.append("]");
            ErrorDescription usrIdsED = new ErrorDescription(errorMsg + " " + usrIdsDisplayString.toString(), s_msgBundle, "4123");
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, usrIdsED);
        } else if (!(usrIdTable.size() != 1 || (oraDevEnv = VerificationUtil.getEnv("CVU_TEST_ENV")) != null && oraDevEnv.equalsIgnoreCase("true"))) {
            TaskUsersWithSameID taskUsers = new TaskUsersWithSameID(this.m_nodeList, usrID);
            taskUsers.performTask();
            this.m_resultSet.uploadResultSet(taskUsers.getResultSet());
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_user}));
            return true;
        }
        this.reportFixupGenErrors();
        ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_user}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4421", false) + ": " + this.m_user;
    }

    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4472", false, (Object[])new String[]{this.m_user});
    }

    public ResultSet performPeer() throws VerificationException {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet usrRsltSet = new ResultSet();
        globalExec.checkUser(this.m_nodeList, this.m_user, usrRsltSet);
        Hashtable ht = usrRsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                String userID = (String)result.getResultInfoSet().elementAt(1);
                result.getResultInfoSet().add(0, this.m_user + "(" + userID + ")");
                continue;
            }
            if (result.getStatus() != 3) continue;
            result.getResultInfoSet().add(0, ReportUtil.NOTEXIST);
            result.setStatus(1);
        }
        return usrRsltSet;
    }

    public String getElementDisplayName() {
        return s_msgBundle.getMessage("9977", false, (Object[])new String[]{this.m_user});
    }
}

