/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;

public class TaskUsersWithSameID
extends Task {
    private String m_uid;

    public TaskUsersWithSameID(String[] nodeList, String userID) {
        super(nodeList, null, 1);
        this.m_uid = userID;
    }

    public boolean performTask() {
        ReportUtil.println(LSEP + s_msgBundle.getMessage("4131", false, (Object[])new String[]{this.m_uid}));
        GlobalExecution globalExec = new GlobalExecution();
        ErrorDescription errDesc = new ErrorDescription();
        ResultSet uidRsltSet = new ResultSet();
        globalExec.checkMultipleUID(this.m_nodeList, this.m_uid, uidRsltSet);
        this.m_resultSet.uploadResultSet(uidRsltSet);
        Hashtable ht = this.m_resultSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() != 3) continue;
            Vector resultInfo = result.getResultInfoSet();
            String users = "";
            if (resultInfo.size() > 0) {
                users = (String)resultInfo.lastElement();
            }
            String errMsg = s_msgBundle.getMessage("4132", true, (Object[])new String[]{users, this.m_uid, node});
            result.addErrorDescription(new ErrorDescription(errMsg, s_msgBundle, "4132"));
            ReportUtil.sureprintln(errMsg);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("4133", false, (Object[])new String[]{this.m_uid}));
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("4134", false, (Object[])new String[]{this.m_uid}));
        return false;
    }

    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4138", false, (Object[])new String[]{this.m_uid});
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4137", false);
    }
}

