/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.NoSuchCRSHomeException;
import oracle.ops.mgmt.cluster.NoSuchExecutableException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.cluster.VoteDiskInfo;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.RunGenericCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskFreeSpace;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.TypeFinder;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskVotingDisk
extends Task {
    private VoteDiskInfo[] m_voteDiskList;

    public TaskVotingDisk() {
        this(null, 1);
    }

    public TaskVotingDisk(MultiTaskHandler multiTaskHandler) {
        this(multiTaskHandler, 1);
    }

    public TaskVotingDisk(MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(multiTaskHandler, actionOnCompletion);
    }

    public boolean performTask() {
        StorageInfo stInfo;
        ErrorDescription errDesc;
        boolean status;
        String cause;
        String m_localName;
        block28: {
            m_localName = null;
            cause = null;
            status = true;
            errDesc = null;
            stInfo = null;
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"ENTRY");
            }
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5429", false));
            try {
                m_localName = VerificationUtil.getLocalHost();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("\nm_localName set to NODE NAME of: " + m_localName));
                }
            }
            catch (UnknownHostException uhe) {
                m_localName = "localnode";
                if (!Trace.isLevelEnabled((int)5)) break block28;
                Trace.out((String)("UNKNOWNHOSTEXCEPTION: \n" + uhe));
            }
        }
        errDesc = new ErrorDescription("5431", s_msgBundle);
        Version verCRSSoft = VerificationUtil.getCRSSoftwareVersionObj();
        if (verCRSSoft == null) {
            cause = s_msgBundle.getMessage("5434", true);
            ReportUtil.printError(cause);
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5431", true));
            this.m_resultSet.addResult(m_localName, 2);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        try {
            ClusterInfo ci = new ClusterInfo(VerificationUtil.getCRSHome(), verCRSSoft);
            this.m_voteDiskList = ci.getVoteDiskLocations();
        }
        catch (NoSuchCRSHomeException nocrsh) {
            this.m_resultSet.addResult(m_localName, 2);
            errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + nocrsh.getMessage());
            this.m_resultSet.addErrorDescription(errDesc);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("NOSUCHCRSHOMEEXCEPTION: \n" + errDesc.getErrorMessage()));
                Trace.stackTrace();
            }
            ReportUtil.printError(errDesc.getErrorMessage());
            return false;
        }
        catch (NoSuchExecutableException nsee) {
            this.m_resultSet.addResult(m_localName, 2);
            errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + nsee.getMessage());
            this.m_resultSet.addErrorDescription(errDesc);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("NOSUCHEXECUTABLEEXCEPTION: \n" + errDesc.getErrorMessage()));
                Trace.stackTrace();
            }
            ReportUtil.printError(errDesc.getErrorMessage());
            return false;
        }
        catch (ClusterInfoException cie) {
            this.m_resultSet.addResult(m_localName, 2);
            errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + cie.getMessage());
            this.m_resultSet.addErrorDescription(errDesc);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("CLUSTERINFOEXCEPTION: \n" + errDesc.getErrorMessage()));
                Trace.stackTrace();
            }
            ReportUtil.printError(errDesc.getErrorMessage());
            return false;
        }
        errDesc = !Version.isPre112((Version)verCRSSoft) ? new ErrorDescription("5430", s_msgBundle) : new ErrorDescription("5435", s_msgBundle);
        Vector<String> uniqueLocs = new Vector<String>();
        String voteLoc = null;
        boolean usingASM = false;
        for (VoteDiskInfo vdiUL : this.m_voteDiskList) {
            voteLoc = vdiUL.getPath();
            if (vdiUL.isASMPath() == 1) {
                usingASM = true;
                break;
            }
            try {
                stInfo = new TypeFinder().getStorageInstance(voteLoc);
            }
            catch (StorageException e) {
                Trace.out((String)("StorageException attempting to get storage type for: " + voteLoc));
                if (uniqueLocs.contains(voteLoc)) continue;
                uniqueLocs.add(voteLoc);
                continue;
            }
            if (stInfo.getType() == 1) {
                if (uniqueLocs.contains(voteLoc)) continue;
                uniqueLocs.add(voteLoc);
                continue;
            }
            sTaskFreeSpace sTask = new sTaskFreeSpace();
            Command[] cmdArray = new Command[1];
            ResultSet rsltSet = new ResultSet();
            String cmd = sTask.getCommand(voteLoc);
            cmdArray[0] = new RunGenericCommand("localnode", cmd);
            boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, rsltSet);
            Hashtable t = rsltSet.getResultTable();
            Enumeration e = t.keys();
            String fileSystem = "UNKNOWN";
            while (e.hasMoreElements()) {
                String node = (String)e.nextElement();
                Result result = (Result)t.get(node);
                if (result.getStatus() == 2) {
                    fileSystem = "UNKNOWN";
                    continue;
                }
                String cmdOut = VerificationUtil.fetchVerificationValue((String)result.getResultInfoSet().firstElement());
                fileSystem = sTask.getData(cmdOut, 0);
            }
            if (!fileSystem.contentEquals("UNKNOWN")) {
                voteLoc = fileSystem;
            }
            if (uniqueLocs.contains(voteLoc)) continue;
            uniqueLocs.add(voteLoc);
        }
        if (!usingASM && (this.m_voteDiskList.length == 2 || uniqueLocs.size() < this.m_voteDiskList.length && uniqueLocs.size() < 3)) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\n ** Voting disk configuration does not meet oracle recommendations. **\n ** Number of voting disk(s) found: " + this.m_voteDiskList.length));
                Trace.out((String)"\n ** Voting disk(s) found: ");
                for (VoteDiskInfo vdi : this.m_voteDiskList) {
                    Trace.out((String)vdi.getPath());
                }
            }
            this.m_resultSet.addResult(m_localName, 4);
            this.m_resultSet.addErrorDescription(errDesc);
            if (!Version.isPre112((Version)verCRSSoft)) {
                ReportUtil.printWarning(s_msgBundle.getMessage("5430", true));
            } else {
                ReportUtil.printWarning(s_msgBundle.getMessage("5435", true));
            }
            return false;
        }
        if (status) {
            // empty if block
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        if (status) {
            this.m_resultSet.addResult(m_localName, 1);
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5432", false));
            return true;
        }
        return false;
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("9502", false);
    }

    public String getDefaultDescription() {
        return s_msgBundle.getMessage("9603", false);
    }
}

