/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.ops.mgmt.trace.Trace;

public class TimeServerNode {
    String m_node;
    String m_remoteServer;
    String m_remoteServerID;
    int m_stratum;
    String m_type;
    int m_when;
    int m_poll;
    int m_reach;
    float m_delay;
    float m_offset;
    float m_jitter;

    public TimeServerNode(String node) {
        this.m_node = node;
    }

    public boolean addDataToNode(String tsLine) {
        if (tsLine.length() < 2) {
            return false;
        }
        String[] vals = tsLine.substring(1).split("\\s+");
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("TimeServerNode:addDataToNode():Parsing line:" + tsLine));
        }
        if (vals.length < 10) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"TimeServerNode:addDataToNode(): Not enough values");
            }
            return false;
        }
        block12: for (int i = 0; i < vals.length; ++i) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Parsed Value[" + i + "]=" + vals[i]));
            }
            switch (i) {
                case 0: {
                    this.m_remoteServer = vals[0];
                    continue block12;
                }
                case 1: {
                    this.m_remoteServerID = vals[1];
                    continue block12;
                }
                case 2: {
                    this.m_stratum = this.parseInt(vals[2]);
                    continue block12;
                }
                case 3: {
                    this.m_type = vals[3];
                    continue block12;
                }
                case 4: {
                    this.m_when = this.parseInt(vals[4]);
                    continue block12;
                }
                case 5: {
                    this.m_poll = this.parseInt(vals[5]);
                    continue block12;
                }
                case 6: {
                    this.m_reach = this.parseInt(vals[6]);
                    continue block12;
                }
                case 7: {
                    this.m_delay = this.parseFloat(vals[7]);
                    continue block12;
                }
                case 8: {
                    this.m_offset = this.parseFloat(vals[8]);
                    continue block12;
                }
                case 9: {
                    this.m_jitter = this.parseFloat(vals[9]);
                }
            }
        }
        return true;
    }

    private int parseInt(String strval) {
        int ret;
        block2: {
            ret = 0;
            try {
                ret = Integer.parseInt(strval);
            }
            catch (NumberFormatException e) {
                if (!Trace.isLevelEnabled((int)5)) break block2;
                Trace.out((String)("Exception during number conversion of string >" + strval + "<"));
            }
        }
        return ret;
    }

    private float parseFloat(String strval) {
        float ret;
        block2: {
            ret = 0.0f;
            try {
                ret = Float.parseFloat(strval);
            }
            catch (NumberFormatException e) {
                if (!Trace.isLevelEnabled((int)5)) break block2;
                Trace.out((String)("Exception during number conversion of string >" + strval + "<"));
            }
        }
        return ret;
    }

    public float getOffset() {
        return this.m_offset;
    }
}

