/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.UnknownHostException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskAdminPrivileges;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

class sAdminPriv
implements VerificationConstants {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private String[] m_nodeList;
    private String m_operation;
    private TaskAdminPrivileges m_taskAdminPriv;
    private String m_oracleHome;
    private ResultSet m_admPrvResultSet;

    protected sAdminPriv(String[] nodeList, String operation, ResultSet admPrvResultSet, TaskAdminPrivileges taskAdminPriv) {
        this.m_nodeList = nodeList;
        this.m_operation = operation;
        this.m_taskAdminPriv = taskAdminPriv;
        this.m_admPrvResultSet = admPrvResultSet;
    }

    protected boolean checkAdminPriv() {
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4012", false));
        this.m_admPrvResultSet.addResult(this.m_nodeList, 1);
        this.performAdminPrivChecks();
        if (this.m_admPrvResultSet.allSuccess()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4300", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4301", false));
        return false;
    }

    private void performAdminPrivChecks() {
        if (this.m_operation.equalsIgnoreCase("db_config")) {
            String localHost;
            boolean ohomeExists = false;
            this.m_oracleHome = this.m_taskAdminPriv.getOracleHome();
            try {
                localHost = VerificationUtil.getLocalHost();
            }
            catch (UnknownHostException e) {
                Trace.out((String)("Could not get the local host name " + e.getMessage()));
                ReportUtil.printError(s_msgBundle.getMessage("0002", false));
                this.m_admPrvResultSet.addResult(this.m_nodeList, 2);
                ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("0002", false));
                this.m_admPrvResultSet.addErrorDescription(errorDesc);
                return;
            }
            try {
                ohomeExists = new ClusterCmd().dirExists(localHost, this.m_oracleHome);
            }
            catch (ClusterException e) {
                Trace.out((String)("Could not check existence of  oracle home " + e.getMessage()));
                ReportUtil.printError(s_msgBundle.getMessage("0006", false, (Object[])new String[]{this.m_oracleHome}));
                this.m_admPrvResultSet.addResult(this.m_nodeList, 2);
                ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("0006", false, (Object[])new String[]{this.m_oracleHome}));
                this.m_admPrvResultSet.addErrorDescription(errorDesc);
                return;
            }
            if (!ohomeExists) {
                ReportUtil.printError(s_msgBundle.getMessage("4900", false, (Object[])new String[]{this.m_oracleHome}));
                this.m_admPrvResultSet.addResult(this.m_nodeList, 2);
                ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("4900", false, (Object[])new String[]{this.m_oracleHome}));
                this.m_admPrvResultSet.addErrorDescription(errorDesc);
                return;
            }
        }
    }
}

