/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskClusterIntegrity;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskClusterIntegrity {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    static final String LSEP = System.getProperty("line.separator");
    static final String FSEP = System.getProperty("file.separator");
    private TaskClusterIntegrity m_genTask;

    public sTaskClusterIntegrity(TaskClusterIntegrity genTask) {
        this.m_genTask = genTask;
    }

    public boolean performCheck() {
        String[] mbrNds;
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4750", false));
        ReportUtil.sureblankln();
        ResultSet resultSet = new ResultSet();
        String[] validNodeArr = VerificationUtil.getNodesWithCRSInstall(this.m_genTask.m_nodeList, this.m_genTask.m_resultSet);
        if (validNodeArr == null) {
            return false;
        }
        GlobalExecution globalExec = new GlobalExecution();
        String crsHome = VerificationUtil.getCRSHome();
        String cmd = crsHome + FSEP + "bin" + FSEP + "olsnodes.exe";
        Trace.out((String)("==== Olsnodes command: " + cmd));
        Hashtable olsnodesOutputHT = globalExec.runExeWithOutput(validNodeArr, cmd, resultSet);
        Vector<String> notRunVec = new Vector<String>();
        Hashtable partHt = new Hashtable();
        Hashtable ht = resultSet.getResultTable();
        Enumeration nodesEnum = ht.keys();
        while (nodesEnum.hasMoreElements()) {
            String curNode = (String)nodesEnum.nextElement();
            Trace.out((String)("==== Analyzing olsnodes output for node " + curNode));
            Result result = (Result)ht.get(curNode);
            if (result == null) {
                Trace.out((String)("==== OLSNODE output not found for node " + curNode));
                this.m_genTask.getResultSet().addResult(curNode, 2);
                this.m_genTask.getResultSet().addErrorDescription(curNode, new ErrorDescription(s_msgBundle.getMessage("4758", false, (Object[])new String[]{curNode})));
                notRunVec.add(curNode);
                continue;
            }
            if (result.getStatus() == 1) {
                String exitStatus = VerificationUtil.fetchVerificationResult((String)olsnodesOutputHT.get(curNode));
                if (!exitStatus.equals("0")) {
                    Trace.out((String)("==== Non-zero exit stauts(" + exitStatus + ") from Olsnodes for " + curNode));
                    notRunVec.add(curNode);
                    this.m_genTask.getResultSet().addResult(curNode, 2);
                    this.m_genTask.getResultSet().addErrorDescription(curNode, new ErrorDescription(s_msgBundle.getMessage("4759", false, (Object[])new String[]{curNode})));
                    continue;
                }
                String[] outList = (String[])result.getResultInfoSet().firstElement();
                String partKey = VerificationUtil.strArr2List(outList);
                Trace.out((String)("==== Node sequence obtained for cluster integrity: " + partKey));
                Vector partMbrVec = (Vector)partHt.get(partKey);
                if (partMbrVec == null) {
                    Vector<String> newPartVec = new Vector<String>();
                    newPartVec.add(new String(curNode));
                    partHt.put(partKey, newPartVec);
                    continue;
                }
                partMbrVec.add(new String(curNode));
                continue;
            }
            if (result.getStatus() == 2) {
                Trace.out((String)("==== OLSNODE failed for node " + curNode));
                this.m_genTask.getResultSet().addResult(curNode, 2);
                this.m_genTask.getResultSet().addErrorDescription(curNode, new ErrorDescription(s_msgBundle.getMessage("4759", false, (Object[])new String[]{curNode})));
                notRunVec.add(curNode);
                continue;
            }
            Trace.out((String)("==== OLSNODE was not successful for node " + curNode));
            this.m_genTask.getResultSet().addResult(curNode, 2);
            this.m_genTask.getResultSet().addErrorDescription(curNode, new ErrorDescription(s_msgBundle.getMessage("4759", false, (Object[])new String[]{curNode})));
            notRunVec.add(curNode);
        }
        int numPart = partHt.size();
        if (numPart == 0) {
            Trace.out((String)("==== Number of partitions found " + numPart));
        } else if (numPart == 1) {
            String stmt1 = "";
            if (notRunVec.isEmpty()) {
                Trace.out((String)"==== Cluster integrity check: normal case");
                stmt1 = s_msgBundle.getMessage("4754", false);
            } else {
                Trace.out((String)("==== Cluster integrity check: 1 partition, but did not run on " + notRunVec.size() + " nodes."));
                stmt1 = s_msgBundle.getMessage("4755", false);
            }
            ReportUtil.writeColHeaders(ReportUtil.NODENAME);
            for (String ndSeq : partHt.keySet()) {
                mbrNds = VerificationUtil.getTokensAsArray(ndSeq, ",");
                for (int i = 0; i < mbrNds.length; ++i) {
                    ReportUtil.writeRecord(mbrNds[i]);
                }
            }
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("4756", false, new Object[]{new Integer(numPart)}));
            Iterator iterator = partHt.keySet().iterator();
            int count = 0;
            while (iterator.hasNext()) {
                String ndSeq;
                ReportUtil.sureprintln(s_msgBundle.getMessage("4757", false, new Object[]{new Integer(++count)}));
                ReportUtil.surewriteColHeaders(ReportUtil.NODENAME);
                ndSeq = (String)iterator.next();
                mbrNds = VerificationUtil.getTokensAsArray(ndSeq, ",");
                for (int i = 0; i < mbrNds.length; ++i) {
                    ReportUtil.writeRecord(mbrNds[i]);
                }
                ReportUtil.sureblankln();
            }
        }
        boolean chkRes = false;
        String summaryStmt = "";
        if (numPart == 1 && notRunVec.isEmpty()) {
            chkRes = true;
            summaryStmt = s_msgBundle.getMessage("4751", false);
            this.m_genTask.getResultSet().setStatus(1);
            ReportUtil.sureblankln();
            ReportUtil.sureprintln(summaryStmt);
        } else {
            summaryStmt = numPart > 1 ? s_msgBundle.getMessage("4753", false, new Object[]{new Integer(numPart)}) : s_msgBundle.getMessage("4752", false) + " ";
            ReportUtil.sureblankln();
            ReportUtil.sureprint(summaryStmt);
            if (!notRunVec.isEmpty()) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("8101", false));
                ReportUtil.sureprintNodelist(notRunVec);
            }
        }
        ReportUtil.sureblankln();
        if (numPart > 1) {
            String[] ndsChecked = VerificationUtil.diffStringArr(validNodeArr, notRunVec.toArray(new String[notRunVec.size()]));
            this.m_genTask.m_resultSet.addResult(ndsChecked, 2);
            for (String node : ndsChecked) {
                this.m_genTask.m_resultSet.addErrorDescription(node, new ErrorDescription(s_msgBundle.getMessage("4761", false)));
            }
            Trace.out((String)("==== Cluster is fragmented. The following nodes will be marked as failed: " + VerificationUtil.strArr2List(ndsChecked)));
        }
        return chkRes;
    }
}

