/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.config.DaemonAliveConstraint;
import oracle.ops.verification.framework.config.InvalidConstraintDataException;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskClusterMgrIntegrity;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskClusterMgrIntegrity {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static String DAEMON_CHECK = s_msgBundle.getMessage("1051", false);
    static final String LSEP = System.getProperty("line.separator");
    private TaskClusterMgrIntegrity m_genTask;
    private boolean isVersionTB = false;

    public sTaskClusterMgrIntegrity(TaskClusterMgrIntegrity genTask) {
        this.m_genTask = genTask;
    }

    public boolean performCheck() {
        String disp_name;
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4800", false));
        ReportUtil.sureblankln();
        ResultSet resultSet = new ResultSet();
        String[] validNodeArr = VerificationUtil.getNodesWithCRSInstall(this.m_genTask.m_nodeList, this.m_genTask.m_resultSet);
        if (validNodeArr == null) {
            return false;
        }
        if (!this.determineCRSVersion(validNodeArr, resultSet)) {
            return false;
        }
        ReportUtil.sureblankln();
        GlobalExecution globalExec = new GlobalExecution();
        boolean cssStatus = false;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("Type", "ALIVE");
        ht.put("Qualifier", "ALIVE");
        ht.put("FallbackAction", "SKIP");
        if (this.isVersionTB) {
            String internalName = VDMUtil.getDaemonInternalName("ohasd");
            if (Utils.isDevelopmentEnv()) {
                internalName = internalName + "_" + System.getenv("ADE_VIEW_NAME");
            }
            ht.put("KeyData", internalName);
            disp_name = VDMUtil.getDaemonDisplayName("ohasd");
            ReportUtil.sureprintln(s_msgBundle.getMessage("4806", false));
        } else {
            ht.put("KeyData", VDMUtil.getDaemonInternalName("ocssd"));
            disp_name = VDMUtil.getDaemonDisplayName("ocssd");
            ReportUtil.sureprintln(s_msgBundle.getMessage("4801", false));
        }
        try {
            DaemonAliveConstraint daCon = new DaemonAliveConstraint(ht);
            cssStatus = daCon.applyConstraint(validNodeArr, resultSet);
            Hashtable rsltHt = resultSet.getResultTable();
            Enumeration nodesEnum = rsltHt.keys();
            ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS);
            ErrorDescription errorDesc = this.isVersionTB ? new ErrorDescription(s_msgBundle.getMessage("4807", false, (Object[])new String[]{disp_name})) : new ErrorDescription(s_msgBundle.getMessage("4804", false, (Object[])new String[]{disp_name}));
            while (nodesEnum.hasMoreElements()) {
                String curNode = (String)nodesEnum.nextElement();
                Result result = (Result)rsltHt.get(curNode);
                String dmnStatus = ReportUtil.ALIVE;
                if (result.getStatus() != 1) {
                    dmnStatus = ReportUtil.NOTALIVE;
                    resultSet.addErrorDescription(curNode, errorDesc);
                }
                ReportUtil.writeRecord(curNode, dmnStatus);
            }
            if (resultSet.getStatus() == 1) {
                ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{DAEMON_CHECK, disp_name}));
            } else {
                ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{DAEMON_CHECK, disp_name}));
                ReportUtil.printErrorNodes(resultSet);
            }
            this.m_genTask.getResultSet().uploadResultSet(resultSet);
        }
        catch (InvalidConstraintDataException e) {
            ReportUtil.sureprintln("ERROR: " + e.getMessage());
            Trace.out((String)"==== InvalidConstraintDataException while checking cluster manager integrity");
        }
        boolean grandStatus = cssStatus;
        ReportUtil.sureblankln();
        if (grandStatus) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("4802", false));
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("4803", false));
        }
        return grandStatus;
    }

    private boolean determineCRSVersion(String[] validNodeArr, ResultSet resultSet) {
        String activeCRSVer = VerificationUtil.getCRSActiveVersion();
        if (activeCRSVer == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Failed to retrieve active version for CRS");
            }
            String errMsg = s_msgBundle.getMessage("5300", false);
            ReportUtil.printError(errMsg);
            resultSet.addErrorDescription(new ErrorDescription(errMsg));
            resultSet.addResult(validNodeArr, 2);
            return false;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nCRSActiveVersion: " + activeCRSVer));
        }
        if (activeCRSVer.startsWith("11.2")) {
            this.isVersionTB = true;
        }
        return true;
    }
}

