/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.task.TaskContainerFreeSpace;
import oracle.ops.verification.framework.engine.task.TaskFreeSpace;

public class sTaskFreeSpace {
    public static final int fileSystem = 0;
    public static final int diskType = 1;
    public static final int diskSpace = 2;
    public static final int usedSpace = 3;
    public static final int freeSpace = 4;
    public static final int percntUse = 5;
    public static final int mountPoint = 6;
    private static String freePrefix = "dir /-C ";
    private static String freeSuffix = " >t &findstr bytes t>t2 &findstr free t2>tmp.txt";
    private static String volPrefix = " &echo select volume=";
    private static String volSuffix = " >d.t &echo detail partition>>d.t &diskpart /s d.t >d.o &findstr * d.o>>tmp.txt";
    private static String clnDskFil = " &del t t2 d.t d.o";
    private static String finalResult = " &type tmp.txt";
    private TaskFreeSpace m_freeTask;
    private TaskContainerFreeSpace m_conTask;
    private String m_location;
    private String m_locdevice;
    private String m_disktype = "UNKNOWN";
    private double m_freespace = 0.0;
    private double m_diskspace = 0.0;
    private double m_usedspace = 0.0;
    private boolean parsedData = false;

    public sTaskFreeSpace(TaskFreeSpace genTask) {
        this.m_freeTask = genTask;
    }

    public sTaskFreeSpace(TaskContainerFreeSpace genTask) {
        this.m_conTask = genTask;
    }

    public sTaskFreeSpace() {
    }

    public String getCommand(String location) {
        String command = null;
        this.m_location = location;
        this.m_locdevice = this.getMntPoint(location);
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if (this.m_locdevice.contentEquals("UNKNOWN")) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"Did not find location device.");
            }
            command = freePrefix + location + freeSuffix;
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("Windows CMD is: " + command));
            }
            return command;
        }
        command = freePrefix + location + freeSuffix + volPrefix + this.m_locdevice + volSuffix + clnDskFil + finalResult;
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("Windows CMD is: " + command));
        }
        return command;
    }

    public String getData(String cmdoutput, int dataRequested) {
        String returnData;
        String unknown = new String("UNKNOWN");
        Object diskspaceunit = null;
        Object outputLine = null;
        String zero = new String("0");
        boolean i = false;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        switch (dataRequested) {
            case 0: 
            case 1: 
            case 5: 
            case 6: {
                returnData = unknown;
                break;
            }
            default: {
                returnData = zero;
            }
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nLine(s): " + cmdoutput + "\ndataReqested: " + dataRequested + "\n"));
        }
        if (dataRequested == 6 || dataRequested == 0) {
            return this.m_locdevice;
        }
        if (!this.parsedData) {
            Trace.out((String)"Parsing freespace data.");
            this.parsedData = true;
            this.m_freespace = Double.parseDouble(cmdoutput);
            StorageSize ssFreeSpace = new StorageSize(this.m_freespace, StorageUnit.BYTE);
            this.m_freespace = ssFreeSpace.sizeIn(StorageUnit.MBYTE);
            if (dataRequested == 4) {
                returnData = Double.toString(this.m_freespace);
            }
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("Storage collected for location: " + this.m_location + "\n  MountPoint: " + this.m_locdevice + "\n  DiskType:   " + this.m_disktype + "\n  DiskSpace:  " + this.m_diskspace + "\n  FreeSpace:  " + this.m_freespace));
            }
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        switch (dataRequested) {
            case 1: {
                return this.m_disktype;
            }
            case 5: {
                return Double.toString(this.m_freespace / this.m_diskspace);
            }
            case 2: {
                return Double.toString(this.m_diskspace);
            }
            case 3: {
                return Double.toString(this.m_diskspace - this.m_freespace);
            }
            case 4: {
                return Double.toString(this.m_freespace);
            }
        }
        return unknown;
    }

    public String getMntPoint(String path) {
        String unknown = new String("UNKNOWN");
        String mountPnt = null;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        try {
            StringTokenizer st = new StringTokenizer(path, ":");
            mountPnt = st.nextToken();
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("\nGetting mount point (" + mountPnt + ") from location device path: " + path));
            }
            return mountPnt;
        }
        catch (NoSuchElementException nse) {
            Trace.out((String)("\nNSE from location device path: " + path));
            return unknown;
        }
    }
}

