/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.global;

import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.RemoteResponseEvent;
import oracle.ops.mgmt.cluster.RemoteResponseListener;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;

public class GlobalHandler
implements RemoteResponseListener {
    RemoteResponseListener m_partialDataHandler;
    RemoteResponseListener m_completeDataHandler;

    public GlobalHandler() {
        this(null, null);
    }

    public GlobalHandler(RemoteResponseListener extlListener) {
        this(extlListener, extlListener);
    }

    public GlobalHandler(RemoteResponseListener partialDataHandler, RemoteResponseListener completeDataHandler) {
        this.m_partialDataHandler = partialDataHandler;
        this.m_completeDataHandler = completeDataHandler;
    }

    public synchronized boolean submit(Command[] cmdArray, int timeLimit, ResultSet resultSet) {
        int cmdCount = cmdArray.length;
        for (int i = 0; i < cmdCount; ++i) {
            VerificationCommand vfyCmd = (VerificationCommand)cmdArray[i];
            String node = vfyCmd.getNodeName();
            Result result = vfyCmd.getResult();
            result.setStatus(5);
            resultSet.addResult(node, result);
        }
        boolean cmdResult = false;
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            cmdResult = clusterCmd.submit(cmdArray);
        }
        catch (ClusterException e) {
            Trace.out((String)("GlobalHandler::EXCEPTION: ClusterException[Thread:" + Thread.currentThread().getName() + "]: " + e.getMessage()));
        }
        resultSet.setStatus();
        return resultSet.allSuccess();
    }

    public synchronized void partialDataReceived(RemoteResponseEvent e) {
        Trace.out((String)("Entered GlobalHandler::partialDataReceived() [Thread:" + Thread.currentThread().getName() + "]"));
        if (this.m_partialDataHandler != null) {
            this.m_partialDataHandler.partialDataReceived(e);
            return;
        }
        VerificationCommand vfyCmd = (VerificationCommand)e.getCommand();
        Result result = vfyCmd.getResult();
        String nodeName = vfyCmd.getNodeName();
        if (result.getStatus() == 1) {
            Trace.out((String)("GlobalHandler::partialDataReceived: Operation was successful on node:" + nodeName + " [Thread:" + Thread.currentThread().getName() + "]"));
        } else {
            Trace.out((String)("GlobalHandler::partialDataReceived: Operation failed on node:" + nodeName + " [Thread:" + Thread.currentThread().getName() + "]"));
        }
    }

    public synchronized void completeDataReceived(RemoteResponseEvent e) {
        Trace.out((String)("Entered GlobalHandler::completeDataReceived() [Thread:" + Thread.currentThread().getName() + "]"));
        if (this.m_completeDataHandler != null) {
            this.m_completeDataHandler.completeDataReceived(e);
            return;
        }
        Trace.out((String)("GlobalHandler::completeDataReceived: Complete data recevied [Thread:" + Thread.currentThread().getName() + "]"));
    }
}

