/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.nativesystem;

import java.util.List;
import oracle.cluster.verification.StorageSize;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.PackageConstraint;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExecutionAnalyzer {
    private int portMin = 49900;
    private int portMax = 50000;

    private void throwUOException(String method) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation '" + method + "' is not supported on this platform");
    }

    public boolean verifyMemory(String etoutput, long memReqd, Result result, boolean forSwapCalc) throws UnsupportedOperationException {
        this.throwUOException("verifyMemory");
        return false;
    }

    public boolean verifyTimeZone(String etoutput, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyTimeZone");
        return false;
    }

    public boolean verifyMemory(String etoutput, StorageSize memReqd, Result result, boolean forSwapCalc) throws UnsupportedOperationException {
        this.throwUOException("verifyMemory");
        return false;
    }

    public boolean verifyAvailMemory(String etoutput, long memReqd, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyAvailMemory");
        return false;
    }

    public boolean verifyAvailMemory(String etoutput, StorageSize memReqd, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyAvailMemory");
        return false;
    }

    public boolean verifyRunlevel(String etoutput, int runLvlReqd, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyRunlevel");
        return false;
    }

    public boolean verifyProcessAlive(String etoutput, String procName, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyProcessAlive");
        return false;
    }

    public boolean verifyArchitecture(String etoutput, List<String> archExList, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyArchitecture");
        return false;
    }

    public boolean verifyOSVersion(String etoutput, String osver, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyOSVersion");
        return false;
    }

    public boolean verifyFileVersion(String etoutput, String pathName, String desiredVersion, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyFileVersion");
        return false;
    }

    public boolean verifyFileExists(String etoutput, String pathName, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyFileExists");
        return false;
    }

    public boolean verifyFileInSysPath(String etoutput, String pathName, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyFileInSysPath");
        return false;
    }

    public boolean verifyPackage(String etoutput, String pkgname, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyPackage");
        return false;
    }

    public boolean verifyPackage(String etoutput, PackageConstraint pkgCon, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyPackage");
        return false;
    }

    public boolean verifyUserExistence(String etoutput, String username, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyUserExistence");
        return false;
    }

    public boolean verifyGroupExistence(String etoutput, String groupname, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyGroupExistence");
        return false;
    }

    public boolean verifyHostsFile(String etoutput, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyHostsFile");
        return false;
    }

    public boolean verifyUsrInGroup(String etoutput, String username, String groupname, int chkprim, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyUsrInGroup");
        return false;
    }

    public boolean verifyMultUser(String etoutput, String userid, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyMultUser");
        return false;
    }

    public boolean verifyKernelVersion(String etoutput, String krnver, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyKernelVersion");
        return false;
    }

    public boolean verifyKerParam(String etoutput, String param, long reqval, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyKerParam");
        return false;
    }

    public boolean verifySwapSpace(String etoutput, long swReqd, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifySwapSpace");
        return false;
    }

    public boolean verifySwapSpace(String etoutput, StorageSize swReqd, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifySwapSpace");
        return false;
    }

    public boolean verifySysParam(String etoutput, String param, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifySysParam");
        return false;
    }

    public boolean verifyOSPatch(String etoutput, String patch, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyOSPatch");
        return false;
    }

    public boolean verifyDaemonLiveliness(String etoutput, String dmnname, Result result) throws UnsupportedOperationException {
        this.throwUOException("verifyDaemonLiveliness");
        return false;
    }

    public boolean pickRunExeOutput(String etoutput, Result result) throws UnsupportedOperationException {
        this.throwUOException("pickRunExeOutput");
        return false;
    }

    public boolean verifyTCPServer(String etoutput, Result result) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyTCPServer...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result fetch failed");
            result.addErrorInfo("startTCPServer failed");
            result.setStatus(2);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("Could not parse:" + etoutput));
            }
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"ERROR-EXIT");
            }
            return false;
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"Parsed output tags.");
        }
        if (!VerificationUtil.fetchVerificationResult(etoutput).equals("0")) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("startTCPServer failed");
            result.addErrorInfo("startTCPServer failed");
            result.setStatus(2);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("Could not parse:" + etoutput));
            }
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"ERROR-EXIT");
            }
            return false;
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"Obtained result value");
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        result.addResultInfo(txtVal);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"Obtained port value");
        }
        txtVal = txtVal.trim();
        int portNum = Integer.parseInt(txtVal);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((Object)"Port used by server: ", (String)txtVal);
        }
        if (txtVal.contentEquals("-1") || portNum < this.portMin || portNum > this.portMax) {
            result.addTraceInfo("TCP server initialization failed");
            result.addErrorInfo("Start TCP Server failed");
            result.setStatus(2);
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"ERROR-EXIT");
            }
            return false;
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((Object)"Listening on port: ", (String)txtVal);
        }
        result.addTraceInfo("Server listening on port: " + txtVal);
        result.addTraceInfo("Sart TCP Server passed");
        result.setHasResultValues(true);
        result.setActualValue(txtVal);
        result.setStatus(1);
        if (Trace.isLevelEnabled((int)1)) {
            result.dumpTraceInfo();
            result.dumpResultInfo();
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return true;
    }

    public boolean verifyTCPComm(String etoutput, Result result) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("Parsing:" + etoutput));
        }
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyTCPComm...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result fetch failed");
            result.addErrorInfo("CheckTCPComm failed");
            result.setStatus(2);
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"ERROR-EXIT");
            }
            return false;
        }
        if (!VerificationUtil.fetchVerificationResult(etoutput).equals("0")) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckTCPComm failed");
            result.setStatus(2);
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"ERROR-EXIT");
            }
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        txtVal = txtVal.trim();
        int portNum = Integer.parseInt(txtVal);
        if (txtVal.contentEquals("-1") || txtVal.contentEquals("1")) {
            result.addErrorInfo("TCP communication verification failed");
            result.setStatus(2);
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"EXIT");
            }
            return false;
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"Success: communication between client and server verified.");
        }
        result.addTraceInfo("TCP communication verification passed.");
        result.setStatus(1);
        result.setHasResultValues(true);
        result.setActualValue(txtVal);
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return true;
    }
}

