/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.nativesystem;

import java.util.List;
import java.util.regex.Pattern;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.util.VerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class sExecutionAnalyzer
extends ExecutionAnalyzer {
    @Override
    public boolean verifyMemory(String etoutput, long memReqd, Result result, boolean forSwapCalc) {
        return this.verifyMemory(etoutput, new StorageSize(memReqd, StorageUnit.BYTE), result, forSwapCalc);
    }

    @Override
    public boolean verifyMemory(String etoutput, StorageSize memReqd, Result result, boolean forSwapCalc) throws UnsupportedOperationException {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyMemory...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckMemory failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        txtVal = txtVal.trim();
        long avlMem = 0L;
        StorageSize avlMemSS = new StorageSize(0.0, StorageUnit.BYTE);
        try {
            avlMem = Long.parseLong(txtVal);
            avlMemSS = new StorageSize(avlMem, StorageUnit.BYTE);
        }
        catch (NumberFormatException e) {
            result.addTraceInfo("Invalid number format for memory available.");
            result.addErrorInfo("checkMemory failed");
            result.setStatus(2);
            return false;
        }
        result.addResultInfo(avlMemSS);
        result.addResultInfo(memReqd);
        if (avlMemSS.compareTo(memReqd) >= 0) {
            result.setStatus(1);
            return true;
        }
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean verifyOSVersion(String etoutput, String osver, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyOSVersion...");
        String osverEx = osver + ".*";
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckOSVersion failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        boolean bMatched = Pattern.matches(osverEx, txtVal = txtVal.trim());
        if (bMatched) {
            result.addResultInfo(txtVal);
            result.setStatus(1);
            return true;
        }
        result.addResultInfo(txtVal);
        result.addTraceInfo("*** OS version check failed. Unexpected pattern");
        result.addErrorInfo("CheckOSVersion failed");
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean verifyFileInSysPath(String etoutput, String pathName, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyFileInSysPath...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("verifyFileInSysPath failed");
            result.setStatus(2);
            return false;
        }
        if (VerificationUtil.fetchVerificationResult(etoutput).equals("0")) {
            result.addTraceInfo("*** File existence check in system path was successful. ");
            result.setStatus(1);
            return true;
        }
        result.addTraceInfo("*** File existence check in system path failed. ");
        result.addErrorInfo("verifyFileInSysPath failed");
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean verifyFileExists(String etoutput, String pathName, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyFileExists...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("verifyFileExists failed");
            result.setStatus(2);
            return false;
        }
        if (VerificationUtil.fetchVerificationResult(etoutput).equals("0")) {
            String fileSize = VerificationUtil.fetchVerificationValue(etoutput);
            result.addResultInfo(fileSize);
            result.addTraceInfo("*** File existence check was successful. ");
            result.setStatus(1);
            return true;
        }
        result.addTraceInfo("*** File existence check failed. ");
        result.addErrorInfo("verifyFileExists failed");
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean verifyFileVersion(String etoutput, String pathName, String desiredVersion, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyFileVersion...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("verifyFileVersion failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        boolean bMatched = desiredVersion.equals(txtVal = txtVal.trim());
        if (bMatched) {
            result.addTraceInfo("*** File version check was successful. ");
            result.addResultInfo(txtVal);
            result.setStatus(1);
            return true;
        }
        result.addResultInfo(txtVal);
        result.addTraceInfo("*** File version check failed. ");
        result.addErrorInfo("verifyFileVersion failed");
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean verifySwapSpace(String etoutput, long swReqd, Result result) {
        return this.verifySwapSpace(etoutput, new StorageSize(swReqd, StorageUnit.BYTE), result);
    }

    @Override
    public boolean verifySwapSpace(String etoutput, StorageSize swReqd, Result result) throws UnsupportedOperationException {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifySwapSpace...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("checkSwapSpace failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        txtVal = txtVal.trim();
        long avlSwap = 0L;
        StorageSize avlSwapSS = new StorageSize(0.0, StorageUnit.BYTE);
        try {
            avlSwap = Long.parseLong(txtVal);
            avlSwapSS = new StorageSize(avlSwap, StorageUnit.BYTE);
        }
        catch (NumberFormatException e) {
            result.addTraceInfo("Invalid number format for swap space.");
            result.addErrorInfo("checkSwapSpace failed");
            result.setStatus(2);
            return false;
        }
        result.addResultInfo(avlSwapSS);
        result.addResultInfo(swReqd);
        if (avlSwapSS.compareTo(swReqd) >= 0) {
            result.setStatus(1);
            return true;
        }
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean verifySysParam(String etoutput, String param, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifySysParam...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("Error while checking system parameter");
            result.setStatus(2);
            return false;
        }
        if (VerificationUtil.fetchVerificationResult(etoutput).equals("1")) {
            result.addTraceInfo("*** param not defined.");
            result.addErrorInfo("Param '" + param + "' does not exist");
            result.setStatus(3);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        txtVal = txtVal.trim();
        result.addResultInfo(txtVal);
        result.setStatus(1);
        return true;
    }

    @Override
    public boolean verifyOSPatch(String etoutput, String reqdPack, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyOSPatch...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("Error while checking OS pack");
            result.setStatus(2);
            return false;
        }
        if (VerificationUtil.fetchVerificationResult(etoutput).equals("1")) {
            result.addTraceInfo("*** No Pack is available.");
            result.addErrorInfo("OS pack '" + reqdPack + "' is not available.");
            result.setStatus(3);
            return false;
        }
        String avlPack = VerificationUtil.fetchVerificationValue(etoutput);
        avlPack = avlPack.trim();
        result.addResultInfo(avlPack);
        int compResult = avlPack.compareTo(reqdPack);
        if (compResult >= 0) {
            result.setStatus(1);
            return true;
        }
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean verifyArchitecture(String etoutput, List<String> archValList, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyArchitecture...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckArchitecture failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        txtVal = txtVal.trim();
        boolean bMatched = false;
        if (archValList == null || archValList.size() == 0) {
            bMatched = true;
        }
        for (String archVal : archValList) {
            if (bMatched) break;
            String archEx = archVal + ".*";
            bMatched = Pattern.matches(archEx, txtVal);
        }
        if (bMatched) {
            result.addTraceInfo("System architecture check passed");
            result.addResultInfo(txtVal);
            result.setStatus(1);
            return true;
        }
        if (txtVal != null && txtVal.length() != 0) {
            result.addTraceInfo("Pattern did not match: " + txtVal);
            result.addTraceInfo("*** Architecture check failed. Unexpected pattern");
            result.addErrorInfo("Architecture check failed");
            result.addResultInfo(txtVal);
            result.setStatus(3);
            return false;
        }
        result.addTraceInfo("System architecture check failed");
        result.addErrorInfo("Architecture check failed");
        result.setStatus(2);
        return false;
    }

    @Override
    public boolean verifyDaemonLiveliness(String etoutput, String dmnname, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyDaemonLiveliness...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckDaemonLiveliness failed");
            result.setStatus(2);
            return false;
        }
        if (VerificationUtil.fetchVerificationResult(etoutput).equals("0")) {
            Trace.out((String)("Daemon liveliness check passed for " + dmnname));
            result.addResultInfo(dmnname);
            result.setStatus(1);
            return true;
        }
        Trace.out((String)("Daemon liveliness check failed for " + dmnname));
        result.addTraceInfo("*** Daemon liveliness check failed.");
        result.addErrorInfo("CheckDaemonLiveliness failed for " + dmnname);
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean pickRunExeOutput(String etoutput, Result result) {
        Trace.out((String)("==== Exectask output: " + etoutput));
        result.addTraceInfo("*** Inside sExecutionAnalyzer.pickRunExeOutput...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("RunExeCommand failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        txtVal = txtVal.trim();
        String[] outlist = VerificationUtil.getTokensAsArray(txtVal, System.getProperty("line.separator"));
        result.addResultInfo(outlist);
        result.setStatus(1);
        return true;
    }

    @Override
    public boolean verifyAvailMemory(String etoutput, long memReqd, Result result) {
        return this.verifyAvailMemory(etoutput, new StorageSize(memReqd, StorageUnit.BYTE), result);
    }

    @Override
    public boolean verifyAvailMemory(String etoutput, StorageSize memReqd, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyAvailMemory...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckAvailMemory failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        txtVal = txtVal.trim();
        long avlMem = 0L;
        StorageSize avlMemSS = new StorageSize(0.0, StorageUnit.BYTE);
        try {
            avlMem = Long.parseLong(txtVal);
            avlMemSS = new StorageSize(avlMem, StorageUnit.BYTE);
        }
        catch (NumberFormatException e) {
            result.addTraceInfo("Invalid number format for available memory.");
            result.addErrorInfo("checkAvailMemory failed");
            result.setStatus(2);
            return false;
        }
        result.addResultInfo(avlMemSS);
        result.addResultInfo(memReqd);
        if (avlMemSS.compareTo(memReqd) >= 0) {
            result.setStatus(1);
            return true;
        }
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean verifyProcessAlive(String etoutput, String procName, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyProcessAlive...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckProcessAlive failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        if ((txtVal = txtVal.trim()).length() == 0 || txtVal.equals(" ")) {
            result.addTraceInfo("*** Process alive check failed. Unexpected pattern");
            result.addErrorInfo("CheckProcessAlive failed");
            result.setStatus(3);
            return false;
        }
        result.addResultInfo(txtVal);
        result.setStatus(1);
        return true;
    }

    @Override
    public boolean verifyRunlevel(String etoutput, int runLvlReqd, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyRunlevel...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckRunlevel failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        boolean bMatched = Pattern.matches(".*run-level .*", txtVal = txtVal.trim());
        if (bMatched) {
            int start = txtVal.indexOf("run-level ") + 9;
            int end = txtVal.indexOf("run-level ") + 12;
            String val = txtVal.substring(start, end);
            val = val.trim();
            int runLvl = 0;
            try {
                runLvl = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                runLvl = -1;
            }
            if (runLvl == runLvlReqd) {
                result.addResultInfo(val);
                result.setStatus(1);
                return true;
            }
            result.addTraceInfo("*** Run level check failed. Reqd: " + Integer.toString(runLvlReqd) + ", found: " + val);
            result.addErrorInfo("CheckRunlevel failed");
            result.addResultInfo(val);
            result.setStatus(3);
            return false;
        }
        result.addTraceInfo("*** Run level check failed. Unexpected pattern");
        result.addErrorInfo("CheckRunlevel failed");
        result.setStatus(2);
        return false;
    }

    @Override
    public boolean verifyUsrInGroup(String etoutput, String username, String groupname, int chkprim, Result result) {
        boolean bMatched;
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyUsrInGroup...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("Check for user in group failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        int inxOfColon = txtVal.indexOf(":");
        if (inxOfColon != -1) {
            txtVal = txtVal.substring(inxOfColon + 1);
        }
        if (bMatched = Pattern.matches(".*No such user.*", txtVal = txtVal.trim())) {
            result.addResultInfo("");
            result.addResultInfo(groupname);
            result.addResultInfo("");
            result.addTraceInfo("*** check for user in group failed. Invalid user");
            result.setStatus(3);
            return false;
        }
        result.addResultInfo(username);
        String[] groups = VerificationUtil.getTokensAsArray(txtVal, " ");
        int index = -1;
        if (groups != null && groups.length >= 1) {
            for (int i = 0; i < groups.length; ++i) {
                if (!groups[i].equals(groupname)) continue;
                index = i;
                break;
            }
        }
        if (index != -1) {
            result.addResultInfo(groupname);
            result.addResultInfo(index == 0 ? "true" : "");
            boolean retval = true;
            if (chkprim == 2) {
                retval = index != 0;
            }
            result.setStatus(retval ? 1 : 3);
            return retval;
        }
        result.addResultInfo("");
        result.addResultInfo("");
        result.addTraceInfo("Check for user in group failed.  User does not belong to this group.");
        result.setStatus(3);
        return false;
    }

    @Override
    public boolean verifyTimeZone(String etoutput, Result result) {
        result.addTraceInfo("*** Inside sExecutionAnalyzer.verifyTimeZone...");
        if (!VerificationUtil.fetchExecResult(etoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("CheckTimeZone failed");
            result.setStatus(2);
            return false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(etoutput);
        if (txtVal != null && txtVal.length() != 0) {
            String[] tzone = (txtVal = txtVal.trim()).split("\n");
            if (tzone.length > 0) {
                result.addResultInfo(tzone[0]);
            } else {
                result.addResultInfo(txtVal);
            }
        } else {
            result.addResultInfo("");
        }
        result.addTraceInfo("Check TimeZone Consistency successful");
        result.setStatus(1);
        return true;
    }
}

