/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import java.util.Vector;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.network.InterfaceInfo;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.NodeInfo;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

abstract class CommandHandler
implements NetworkConstants {
    private static final String IP_KEY = "IP";
    private static final String MASK_KEY = "MASK";
    private static final String NAME_KEY = "NAME";
    private static final String SUBNET_KEY = "SUBNET";
    private static final String TYPE_KEY = "TYPE";
    private static final String NETTYPE_KEY = "NETTYPE";
    private static final String UPSTATUS_KEY = "UPSATUS";
    private static final String TYPE_IPV4 = "IPV4";
    private static final String DEF_GATEWAY = "DEFAULT GATEWAY";
    private static final String SUB_GATEWAY = "SUBNET GATEWAY";
    private static final String HW_ADDRESS = "HARDWARE ADDR";
    private static final String MTU_KEY = "MTU";
    private static final String TAG_ADOPTER = "ADOPTER";
    private static final String STATUS_STR_UP = "UP";
    private static final String STATUS_STR_DOWN = "DOWN";
    private static final String STATUS_STR_UNKNOWN = "UNKNOWN";
    private static final String NETTYPE_STR_PRIVATE = "PRIVATE";
    private static final String NETTYPE_STR_PUBLIC = "PUBLIC";
    private static final String NETTYPE_STR_LOCAL = "LOCAL";
    private static final String NETTYPE_STR_UNKNOWN = "UNKNOWN";

    CommandHandler() {
    }

    protected abstract VerificationCommand genReachCmd(String var1, String var2);

    protected abstract VerificationCommand genIPConCmd(String var1, String var2, String var3);

    protected boolean parseConCmd(VerificationCommand vfyCmd) {
        boolean expectedExitCode = false;
        boolean succ = true;
        if (0 != vfyCmd.getVfyCode()) {
            succ = false;
            Trace.out((String)("vfyCmd returned: " + vfyCmd.getVfyCode()));
            Trace.out((String)("vfyCmd output: " + vfyCmd.getOutput()));
        }
        return succ;
    }

    protected VerificationCommand genGetIfInfoCmd(String destNode) {
        String[] arg = new String[]{"-getIfInfo"};
        String[] env = null;
        return new VerificationCommand(destNode, arg, env);
    }

    protected VerificationCommand genGetIfInfoByNameCmd(String destNode, String inf) {
        String[] arg = new String[]{"-getIfInfo", inf};
        String[] env = null;
        return new VerificationCommand(destNode, arg, env);
    }

    private InterfaceInfo decodeIfInfo(String fmtdStr, String node) throws NetworkException {
        int netType;
        int status;
        String ip = null;
        String subnet = null;
        String name = null;
        String netmask = null;
        String type = null;
        String def_gateway = null;
        String sub_gateway = null;
        String hw_addr = null;
        String upStatusStr = null;
        String netTypeStr = null;
        String mtu = null;
        try {
            ip = GenericUtil.getValueByKey(fmtdStr, IP_KEY);
            subnet = GenericUtil.getValueByKey(fmtdStr, SUBNET_KEY);
            netmask = GenericUtil.getValueByKey(fmtdStr, MASK_KEY);
            name = GenericUtil.getValueByKey(fmtdStr, NAME_KEY);
            type = GenericUtil.getValueByKey(fmtdStr, TYPE_KEY);
            upStatusStr = GenericUtil.getValueByKey(fmtdStr, UPSTATUS_KEY);
            netTypeStr = GenericUtil.getValueByKey(fmtdStr, NETTYPE_KEY);
            def_gateway = GenericUtil.getValueByKey(fmtdStr, DEF_GATEWAY);
            sub_gateway = GenericUtil.getValueByKey(fmtdStr, SUB_GATEWAY);
            hw_addr = GenericUtil.getValueByKey(fmtdStr, HW_ADDRESS);
            mtu = GenericUtil.getValueByKey(fmtdStr, MTU_KEY);
        }
        catch (Exception e) {
            Trace.out((String)("Exception decodingIfInfo " + fmtdStr));
            throw new NetworkException(NetworkException.DEFAULT_MSG, e);
        }
        if (null == ip || null == subnet || null == name || null == netmask || null == type || null == upStatusStr || null == netTypeStr || null == sub_gateway || null == hw_addr || null == mtu) {
            Trace.out((String)("Null Info in  decodingIfInfo " + fmtdStr));
            throw new NetworkException(NetworkException.DEFAULT_MSG);
        }
        if (STATUS_STR_UP.equalsIgnoreCase(upStatusStr)) {
            status = 22;
        } else if (STATUS_STR_DOWN.equalsIgnoreCase(upStatusStr)) {
            status = 8;
        } else if ("UNKNOWN".equalsIgnoreCase(upStatusStr)) {
            status = 50;
        } else {
            Trace.out((String)("Status not recognized " + fmtdStr));
            throw new NetworkException(NetworkException.DEFAULT_MSG);
        }
        if (NETTYPE_STR_PUBLIC.equalsIgnoreCase(netTypeStr)) {
            netType = 2;
        } else if (NETTYPE_STR_PRIVATE.equalsIgnoreCase(netTypeStr)) {
            netType = 1;
        } else if ("UNKNOWN".equalsIgnoreCase(netTypeStr)) {
            netType = 4;
        } else {
            Trace.out((String)("NetType not recognized " + fmtdStr));
            throw new NetworkException(NetworkException.DEFAULT_MSG);
        }
        InterfaceInfo inf = new InterfaceInfo(name, ip, subnet, netmask, type, netType, status, node, def_gateway, sub_gateway, hw_addr, mtu);
        return inf;
    }

    NodeInfo decodeIfInfo(VerificationCommand cmd) throws NetworkException {
        boolean index = false;
        String node = cmd.getNode();
        String output = cmd.getOutput();
        NodeInfo nodeInfo = new NodeInfo(node);
        Vector infStrs = null;
        try {
            infStrs = GenericUtil.getAllStrByTags(output, TAG_ADOPTER);
        }
        catch (ParsingException p) {
            Trace.out((String)("Parsing Exception, while parsing: " + output));
            throw new NetworkException(NetworkException.DEFAULT_MSG);
        }
        for (String str : infStrs) {
            InterfaceInfo inf = this.decodeIfInfo(str, cmd.getNode());
            if (inf.getSubnet().equals("127.0.0.0") || inf.getSubnet().equals("0.0.0.0")) continue;
            nodeInfo.addInterface(inf);
        }
        return nodeInfo;
    }
}

