/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TCPMatrix {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    public static final int SUCCESSFUL = 0;
    public static final int PARTIAL = 1;
    public static final int FAILED = -1;
    private String m_serverName;
    private String m_serverIP;
    private String[] m_IPList = null;
    private String[] m_clientList = null;
    private int[] m_TCPConmatrix;
    private int m_status;

    public TCPMatrix(String serverName, String serverIP, String[] clientList, String[] IPList, int[] TCPConmatrix) {
        this.m_serverName = serverName;
        this.m_serverIP = serverIP;
        this.m_clientList = clientList;
        this.m_IPList = IPList;
        this.m_TCPConmatrix = TCPConmatrix;
        this.initStatus();
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("\nCreated - " + this.toString()));
        }
    }

    public TCPMatrix(String serverName, String serverIP, String[] clientList, String[] IPList) {
        this(serverName, serverIP, clientList, IPList, new int[clientList.length]);
    }

    public TCPMatrix(String[] clientList, String[] IPList, int[] TCPmatrix) {
        this(null, null, clientList, IPList, TCPmatrix);
        String localIP;
        String localNode;
        try {
            localNode = VerificationUtil.getLocalHost();
            int srvinClientLst = -1;
            for (int i = 0; i < clientList.length; ++i) {
                if (!localNode.contentEquals(clientList[i])) continue;
                srvinClientLst = i;
                break;
            }
            localIP = srvinClientLst != -1 ? IPList[srvinClientLst] : InetAddress.getByName(localNode).getHostAddress();
        }
        catch (UnknownHostException e) {
            localNode = clientList[0];
            localIP = IPList[0];
        }
        this.setServerName(localNode);
        this.setServerIP(localIP);
        this.initStatus();
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("\nUpdated - " + this.toString()));
        }
    }

    public TCPMatrix(String[] clientList, String[] IPList) {
        this(clientList, IPList, new int[clientList.length]);
    }

    public int getStatus() {
        return this.m_status;
    }

    public int getTCPStatus(int index) {
        return this.m_TCPConmatrix[index];
    }

    private void initStatus() {
        for (int i = 0; i < this.m_TCPConmatrix.length; ++i) {
            this.m_TCPConmatrix[i] = this.m_serverName != null && this.m_serverIP != null && this.m_serverName.contentEquals(this.m_clientList[i]) && this.m_serverIP.contentEquals(this.m_IPList[i]) ? 0 : -1;
        }
    }

    public void setStatus(int index, int value) {
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("index: " + index + " value: " + value));
        }
        if (Trace.isLevelEnabled((int)1)) {
            this.toString();
        }
        this.m_TCPConmatrix[index] = value;
        if (Trace.isLevelEnabled((int)1)) {
            this.toString();
        }
    }

    public void setStatus() {
        boolean somePass = false;
        boolean somePartial = false;
        boolean someFail = false;
        for (int i = 0; i < this.m_TCPConmatrix.length; ++i) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("\n" + this.m_IPList[i] + " - TCPConmatrix[" + i + "]: " + this.m_TCPConmatrix[i]));
            }
            if (this.m_TCPConmatrix[i] == 0) {
                somePass = true;
                continue;
            }
            if (this.m_TCPConmatrix[i] == 1) {
                somePartial = true;
                continue;
            }
            if (this.m_TCPConmatrix[i] != -1) continue;
            someFail = true;
        }
        this.m_status = somePass && !somePartial && !someFail ? 0 : -1;
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("Setting final status to: " + this.m_status));
        }
    }

    public String printStatus() {
        String str = null;
        str = this.m_status == 0 ? ReportUtil.SUCCESSFUL : (this.m_status == 1 ? ReportUtil.PARTIALLY_SUCCESSFUL : (this.m_status == -1 ? ReportUtil.FAILED : "BAD TCPMATRIX STATUS"));
        return str;
    }

    public int[] getTCPConmatrix() {
        return this.m_TCPConmatrix;
    }

    public String getServerName() {
        return this.m_serverName;
    }

    public void setServerName(String serverName) {
        this.m_serverName = serverName;
    }

    public String getServerIP() {
        return this.m_serverIP;
    }

    public void setServerIP(String serverIP) {
        this.m_serverIP = serverIP;
    }

    public String[] getClientList() {
        return this.m_clientList;
    }

    public String[] getClientIPList() {
        return this.m_IPList;
    }

    public String getClientName(int index) {
        if (this.m_clientList != null) {
            return this.m_clientList[index];
        }
        return null;
    }

    public String getClientIP(int index) {
        if (this.m_IPList != null) {
            return this.m_IPList[index];
        }
        return null;
    }

    public String toString() {
        StringBuffer sBuf = new StringBuffer("\nTCP Connectivity Matrix for: " + this.m_serverName + "(" + this.m_serverIP + "): \n");
        if (this.m_IPList == null || this.m_clientList == null) {
            sBuf.append("\tError\n");
            return sBuf.toString();
        }
        for (int i = 0; i < this.m_clientList.length; ++i) {
            sBuf.append("\t" + this.m_clientList[i] + " (" + this.m_IPList[i] + "): ");
            if (this.m_TCPConmatrix[i] == 0) {
                sBuf.append("Success");
            } else if (this.m_TCPConmatrix[i] == 1) {
                sBuf.append("Partial Success");
            } else if (this.m_TCPConmatrix[i] == -1) {
                sBuf.append("Failure");
            } else {
                sBuf.append("UNKOWN");
            }
            sBuf.append("\n");
        }
        return sBuf.toString();
    }
}

