/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.ResultValuesUnavailableException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.CheckTCPCommCommand;
import oracle.ops.verification.framework.command.RunTCPServerCommand;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.network.CommandHandler;
import oracle.ops.verification.framework.network.CommandHandlerFactory;
import oracle.ops.verification.framework.network.ConMatrix;
import oracle.ops.verification.framework.network.InterfaceInfo;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.NodeInfo;
import oracle.ops.verification.framework.network.Subnet;
import oracle.ops.verification.framework.network.TCPMatrix;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.MultiNodeException;

public class VerifyNetwork
implements NetworkConstants {
    private static CommandHandler s_commandHandler = CommandHandlerFactory.createCommandHandler();
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private Socket serverSocket;

    public boolean checkReachFromLocalNode(String[] nodeList, boolean[] nodeConArray) throws NetworkException {
        boolean ret = false;
        ClusterCmd clusterCmd = new ClusterCmd();
        if (nodeConArray.length != nodeList.length) {
            Trace.out((String)"arrays' lengths don't match");
            throw new NetworkException(NetworkException.DEFAULT_MSG);
        }
        for (int i = 0; i < nodeList.length; ++i) {
            nodeConArray[i] = true;
        }
        try {
            int timeOut = 3;
            if (!new SystemFactory().CreateSystem().isUnixSystem()) {
                timeOut = 40;
            }
            Trace.out((String)("timeout = " + timeOut));
            ret = clusterCmd.areNodesAlive(nodeList, timeOut, null);
        }
        catch (ClusterException ce) {
            for (int i = 0; i < nodeList.length; ++i) {
                nodeConArray[i] = false;
            }
            Trace.out((Exception)((Object)ce));
            throw new NetworkException(NetworkException.FAILED_NODE_REACH_ALL, ce);
        }
        catch (RemoteFileOperationException re) {
            for (int i = 0; i < nodeList.length; ++i) {
                try {
                    NativeResult nativeResult = re.getNativeResult(nodeList[i]);
                    nodeConArray[i] = nativeResult.getBooleanResult();
                    if (nodeConArray[i]) {
                        Trace.out((String)(nodeList[i] + " is reachable"));
                        continue;
                    }
                    Trace.out((String)(nodeList[i] + "is not reachable"));
                    continue;
                }
                catch (NoSuchNodeException ne) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    public boolean checkReachFromSrcNode(String[] nodeList, boolean[] nodeConArray, String srcNode) {
        int nodeCount;
        int numCmds = nodeCount = nodeList.length;
        for (int i = 0; i < nodeCount; ++i) {
            nodeConArray[i] = false;
        }
        VerificationCommand[] cmdArray = new VerificationCommand[numCmds];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = s_commandHandler.genReachCmd(srcNode, nodeList[i]);
        }
        ResultSet resultSet = new ResultSet();
        boolean cmdSucc = new GlobalHandler().submit((Command[])cmdArray, 0, resultSet);
        Trace.out((String)("cmdSucc=" + cmdSucc));
        if (!cmdSucc) {
            return false;
        }
        for (int i = 0; i < nodeCount; ++i) {
            VerificationCommand vfyCmd = cmdArray[i];
            Result result = vfyCmd.getResult();
            if (result.getStatus() != 1) continue;
            nodeConArray[i] = s_commandHandler.parseConCmd(vfyCmd);
        }
        int numConnected = 0;
        for (int i = 0; i < nodeCount; ++i) {
            if (!nodeConArray[i]) continue;
            ++numConnected;
        }
        return numConnected == nodeCount;
    }

    public boolean checkSubnetCon(List subnetList, List matrixList) throws NetworkException {
        ConMatrix matrix;
        boolean retVal = true;
        Vector<SubnetConThread> threadList = new Vector<SubnetConThread>();
        int numSubnets = subnetList.size();
        String subnetId = null;
        InterfaceInfo inf = null;
        for (Subnet subnet : subnetList) {
            int numInterfaces = subnet.getNumInterfaces();
            String[] tempIPList = new String[numInterfaces];
            String[] tempNodeList = new String[numInterfaces];
            String[] tempInterfaceList = new String[numInterfaces];
            subnetId = subnet.getSubnet();
            Trace.out((String)("\n Interfaces of subnet " + subnetId + ":"));
            Iterator ifIter = subnet.getInterfaces().iterator();
            int i = 0;
            while (ifIter.hasNext()) {
                Trace.out(inf);
                inf = (InterfaceInfo)ifIter.next();
                tempIPList[i] = inf.getIP();
                tempNodeList[i] = inf.getNode();
                tempInterfaceList[i] = inf.getName();
                ++i;
            }
            Trace.out((String)"\n");
            matrix = new ConMatrix(subnetId, tempNodeList, tempIPList, tempInterfaceList);
            matrixList.add(matrixList.size(), matrix);
            threadList.add(new SubnetConThread(tempIPList, tempNodeList, subnetId, matrix));
        }
        Enumeration threadEnum = threadList.elements();
        while (threadEnum.hasMoreElements()) {
            Thread t = (Thread)threadEnum.nextElement();
            Trace.out((String)("==> Running " + t.getName()));
            t.start();
        }
        try {
            threadEnum = threadList.elements();
            while (threadEnum.hasMoreElements()) {
                ((Thread)threadEnum.nextElement()).join();
            }
        }
        catch (InterruptedException e) {
            throw new NetworkException(e.getMessage(), e, true);
        }
        threadEnum = threadList.elements();
        while (threadEnum.hasMoreElements()) {
            matrix = ((SubnetConThread)threadEnum.nextElement()).getMatrix();
            boolean subnetCon = 1 == matrix.getStatus();
            if (subnetCon) continue;
            retVal = false;
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("checkSubnetCon returns " + retVal));
        }
        return retVal;
    }

    public boolean checkSubnetTCPCon(List subnetList, List matrixList) throws NetworkException {
        TCPMatrix matrix;
        Vector<SubnetTCPThread> threadList = new Vector<SubnetTCPThread>();
        String subnetId = null;
        InterfaceInfo inf = null;
        boolean subnetTCPCon = false;
        boolean retVal = false;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        for (Subnet subnet : subnetList) {
            int numInterfaces = subnet.getNumInterfaces();
            String[] tempIPList = new String[numInterfaces];
            String[] tempNodeList = new String[numInterfaces];
            subnetId = subnet.getSubnet();
            Iterator ifIter = subnet.getInterfaces().iterator();
            int i = 0;
            while (ifIter.hasNext()) {
                inf = (InterfaceInfo)ifIter.next();
                tempIPList[i] = inf.getIP();
                tempNodeList[i] = inf.getNode();
                ++i;
            }
            matrix = new TCPMatrix(tempNodeList, tempIPList);
            matrixList.add(matrixList.size(), matrix);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)matrix.toString());
            }
            threadList.add(new SubnetTCPThread(matrix));
        }
        Enumeration threadEnum = threadList.elements();
        while (threadEnum.hasMoreElements()) {
            Thread t = (Thread)threadEnum.nextElement();
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("==> Running " + t.getName()));
            }
            t.start();
        }
        try {
            threadEnum = threadList.elements();
            while (threadEnum.hasMoreElements()) {
                ((Thread)threadEnum.nextElement()).join();
            }
        }
        catch (InterruptedException e) {
            throw new NetworkException(e.getMessage(), true);
        }
        threadEnum = threadList.elements();
        while (threadEnum.hasMoreElements()) {
            matrix = ((SubnetTCPThread)threadEnum.nextElement()).getMatrix();
            subnetTCPCon = 0 == matrix.getStatus();
            if (subnetTCPCon) continue;
            retVal = false;
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("checkSubnetTCPCon returning: " + retVal));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return retVal;
    }

    public boolean checkNodeConByIP(String[] IPList, String[] nodeList, ConMatrix matrix) {
        boolean allConnected = false;
        boolean[][] nodeConMatrix = matrix.getMatrixForChange();
        for (int i = 0; i < IPList.length; ++i) {
            for (int j = 0; j < IPList.length; ++j) {
                nodeConMatrix[i][j] = false;
            }
        }
        int numConnected = VerifyNetwork.getRowConByIP(0, IPList, nodeList, nodeConMatrix[0]);
        if (numConnected == nodeList.length) {
            matrix.setStatus(1, true);
            allConnected = true;
            Trace.out((String)("Node " + nodeList[0] + "Connected to all."));
        } else {
            matrix.setStatus(3, true);
            int numDisconnected = nodeList.length - numConnected;
            if (!nodeConMatrix[0][0]) {
                --numDisconnected;
            }
            Trace.out((String)("NumDisConnected: " + numDisconnected + " to Node " + nodeList[0]));
            if (numDisconnected > 1) {
                int i;
                IPConThread[] threadList = new IPConThread[numDisconnected];
                int[] disconToOriginalMap = new int[numDisconnected];
                String[] disconNodeList = new String[numDisconnected];
                String[] disconIPList = new String[numDisconnected];
                int disconIndex = 0;
                for (i = 1; i < nodeList.length; ++i) {
                    if (nodeConMatrix[0][i]) continue;
                    disconToOriginalMap[disconIndex] = i;
                    disconNodeList[disconIndex] = nodeList[i];
                    disconIPList[disconIndex] = IPList[i];
                    ++disconIndex;
                }
                for (int srcIndex = 0; srcIndex < numDisconnected; ++srcIndex) {
                    IPConThread t = new IPConThread(srcIndex, disconIPList, disconNodeList, new boolean[numDisconnected]);
                    t.setName("IPConThread_" + IPList[srcIndex]);
                    threadList[srcIndex] = t;
                }
                for (i = 0; i < numDisconnected; ++i) {
                    Trace.out((String)("Starting thread:" + threadList[i].getName()));
                    threadList[i].start();
                }
                for (i = 0; i < numDisconnected; ++i) {
                    try {
                        threadList[i].join();
                        continue;
                    }
                    catch (InterruptedException e) {
                        Trace.out((Object)e.getStackTrace());
                    }
                }
                for (i = 0; i < numDisconnected; ++i) {
                    boolean[] rowCon = threadList[i].getRowCon();
                    int srcInOriginal = disconToOriginalMap[i];
                    for (int j = 0; j < numDisconnected; ++j) {
                        int indexInOriginal = disconToOriginalMap[j];
                        nodeConMatrix[srcInOriginal][indexInOriginal] = rowCon[j];
                        Trace.out((String)(j + ">>Setting nodeConMatrix[" + srcInOriginal + "][" + indexInOriginal + "] =" + rowCon[j]));
                    }
                }
            }
        }
        return allConnected;
    }

    public int getInterfaceInfo(String[] nodeList, List nodeInfoList) throws NetworkException, MultiNodeException {
        int nodeCount = nodeList.length;
        int succNodeCount = 0;
        VerificationCommand[] cmdArray = new VerificationCommand[nodeCount];
        MultiNodeException mne = null;
        for (int j = 0; j < nodeCount; ++j) {
            cmdArray[j] = s_commandHandler.genGetIfInfoCmd(nodeList[j]);
        }
        ResultSet resultSet = new ResultSet();
        boolean cmdSucc = new GlobalHandler().submit((Command[])cmdArray, 0, resultSet);
        if (!resultSet.anySuccess()) {
            Trace.out((String)"GlobalHandler failed");
            throw new NetworkException(s_msgBundle.getMessage("4080", false));
        }
        for (int nodeIndex = 0; nodeIndex < nodeCount; ++nodeIndex) {
            VerificationCommand vfyCmd = cmdArray[nodeIndex];
            Result result = vfyCmd.getResult();
            if (result.getStatus() == 1) {
                NodeInfo nodeInfo = s_commandHandler.decodeIfInfo(vfyCmd);
                nodeInfoList.add(nodeInfo);
                ++succNodeCount;
                continue;
            }
            NetworkException ne = new NetworkException(s_msgBundle.getMessage("6003", true, (Object[])new String[]{nodeList[nodeIndex]}));
            if (null == mne) {
                mne = new MultiNodeException();
            }
            mne.addThrowable(nodeList[nodeIndex], ne);
        }
        if (null != mne) {
            throw mne;
        }
        return succNodeCount;
    }

    public boolean checkTCPComm(TCPMatrix matrix) {
        String portNumStr;
        Command[] clicmdArray;
        int nodeCount;
        ResultSet resultSet;
        String[] IPList;
        String[] clientList;
        String serverIP;
        String serverNode;
        boolean srvcmdResult;
        boolean clicmdResult;
        block28: {
            clicmdResult = false;
            srvcmdResult = false;
            serverNode = matrix.getServerName();
            serverIP = matrix.getServerIP();
            clientList = matrix.getClientList();
            IPList = matrix.getClientIPList();
            resultSet = new ResultSet();
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"ENTRY");
            }
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("Check TCP communication for matrix: \n" + matrix.toString() + "\n"));
            }
            nodeCount = clientList.length;
            int clicmdArraySize = 0;
            clicmdArraySize = nodeCount;
            for (String clientIP : IPList) {
                if (!serverIP.contentEquals(clientIP)) continue;
                --clicmdArraySize;
                break;
            }
            if (clicmdArraySize <= 0) {
                clicmdArraySize = 1;
            }
            clicmdArray = new Command[clicmdArraySize];
            Command[] startsrvcmdArray = new Command[1];
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("nodeCount: " + nodeCount + "\nClient command array size: " + clicmdArray.length));
            }
            startsrvcmdArray[0] = new RunTCPServerCommand(serverNode, serverIP);
            srvcmdResult = new GlobalHandler().submit(startsrvcmdArray, 0, resultSet);
            if (!srvcmdResult) {
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"Exectask command to startup the server failed.");
                }
                return srvcmdResult;
            }
            VerificationCommand srvCommand = (VerificationCommand)startsrvcmdArray[0];
            RunTCPServerCommand runTCPsrv = (RunTCPServerCommand)startsrvcmdArray[0];
            Result srvResult = srvCommand.getResult();
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"Dumping result trace info.");
                srvResult.dumpTraceInfo();
                Trace.out((String)"End of dumping result trace info.");
            }
            try {
                portNumStr = srvResult.getActualValue();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("Port Number:" + portNumStr));
                }
            }
            catch (ResultValuesUnavailableException rvue) {
                portNumStr = new String("-1");
                if (!Trace.isLevelEnabled((int)1)) break block28;
                Trace.out((String)"ResultValuesUnavailable");
            }
        }
        int portNum = Integer.parseInt(portNumStr);
        if (portNum == -1) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"Server startup failed.");
            }
            this.terminateServer(serverIP, portNum);
            return false;
        }
        int i = 0;
        int j = 0;
        while (i < nodeCount) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("\nTCP client command processing i:" + i + " j:" + j + "\n"));
            }
            if (serverIP.contentEquals(IPList[i])) {
                --j;
            } else {
                clicmdArray[j] = new CheckTCPCommCommand(serverNode, serverIP, portNumStr, clientList[i], IPList[i]);
            }
            ++i;
            ++j;
        }
        if (j < 1) {
            this.terminateServer(serverIP, portNum);
            return true;
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("TCP communication submitting " + j + " commands.\n" + "Client command array size: " + clicmdArray.length));
        }
        clicmdResult = new GlobalHandler().submit(clicmdArray, 0, resultSet);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"TCP communication commands submitted.");
        }
        for (i = 0; i < clicmdArray.length; ++i) {
            VerificationCommand vfyCmd = (VerificationCommand)clicmdArray[i];
            CheckTCPCommCommand TCPcmd = (CheckTCPCommCommand)clicmdArray[i];
            Result result = vfyCmd.getResult();
            String clientVerified = TCPcmd.getClientIP();
            if (result.getStatus() != 1) continue;
            for (j = 0; j < clientList.length; ++j) {
                String retVal;
                block29: {
                    if (!IPList[j].contentEquals(clientVerified)) continue;
                    try {
                        if (Trace.isLevelEnabled((int)1)) {
                            Trace.out((String)("\nGetting status for: " + TCPcmd.getClientName() + ":" + TCPcmd.getClientIP()));
                        }
                        retVal = result.getActualValue();
                    }
                    catch (ResultValuesUnavailableException rvue) {
                        retVal = new String("-1");
                        if (!Trace.isLevelEnabled((int)5)) break block29;
                        Trace.out((String)("\nStatus unavailable for: " + TCPcmd.getClientName() + ":" + TCPcmd.getClientIP()));
                    }
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\nTCP status for " + TCPcmd.getClientName() + ":" + TCPcmd.getClientIP() + ":" + retVal));
                }
                if (retVal.contentEquals("0")) {
                    matrix.setStatus(j, 0);
                    continue;
                }
                if (!retVal.contentEquals("1")) continue;
                matrix.setStatus(j, 1);
            }
        }
        matrix.setStatus();
        this.terminateServer(serverIP, portNum);
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return clicmdResult && srvcmdResult && 1 == resultSet.getStatus();
    }

    private void terminateServer(String serverIP, int portNum) {
        InetAddress[] addrList = null;
        PrintStream serverChannel = null;
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nAttempting to terminate TCP server: '" + serverIP + "' on port: '" + portNum + "'"));
        }
        try {
            for (InetAddress serverInterface : addrList = InetAddress.getAllByName(serverIP)) {
                if (serverInterface.toString().contentEquals("/" + serverIP)) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\nSending terminate message to: " + serverInterface.toString() + " Port: " + portNum));
                    }
                    this.serverSocket = new Socket(serverInterface, portNum);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\nSocket connected to remote port: " + this.serverSocket.getPort()));
                    }
                    serverChannel = new PrintStream(this.serverSocket.getOutputStream(), true);
                    serverChannel.println("TerminateCVUTCPServer");
                    this.serverSocket.close();
                    continue;
                }
                if (!Trace.isLevelEnabled((int)5)) continue;
                Trace.out((String)("\nIP address: " + serverInterface.toString() + " does not match server IP of: " + serverIP));
            }
        }
        catch (UnknownHostException uhe) {
            Trace.out((String)"UNKNOWNHOSTEXCEPTION: Cannot send terminate TCP server msg.");
        }
        catch (IOException e) {
            Trace.out((String)"IOEXCEPTION: Cannot create socket for connection to server.");
        }
    }

    private static int getRowConByIP(int srcIndex, String[] IPList, String[] nodeList, boolean[] nodeConArray) {
        int nodeCount = IPList.length;
        if (nodeCount > 0) {
            Trace.out((String)("Entered getRowConByIP src = " + nodeList[srcIndex] + ":" + IPList[srcIndex]));
        }
        for (int i = 0; i < nodeCount; ++i) {
            nodeConArray[i] = false;
        }
        VerificationCommand[] cmdArray = new VerificationCommand[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = s_commandHandler.genIPConCmd(nodeList[srcIndex], IPList[srcIndex], IPList[i]);
        }
        ResultSet resultSet = new ResultSet();
        boolean cmdSucc = new GlobalHandler().submit((Command[])cmdArray, 0, resultSet);
        if (!cmdSucc) {
            Trace.out((String)"GlobalHandler.submit failed");
            return 0;
        }
        for (int nodeIndex = 0; nodeIndex < nodeCount; ++nodeIndex) {
            VerificationCommand vfyCmd = cmdArray[nodeIndex];
            Result result = vfyCmd.getResult();
            if (result.getStatus() != 1) continue;
            nodeConArray[nodeIndex] = s_commandHandler.parseConCmd(vfyCmd);
            Trace.out((String)(IPList[srcIndex] + "->" + IPList[nodeIndex] + ":" + nodeConArray[nodeIndex]));
        }
        int numConnected = 0;
        for (int i = 0; i < nodeCount; ++i) {
            if (!nodeConArray[i]) continue;
            ++numConnected;
        }
        Trace.out((String)("RowConByIP:: return = " + (numConnected == nodeCount)));
        return numConnected;
    }

    class SubnetTCPThread
    extends Thread {
        TCPMatrix m_matrix = null;

        SubnetTCPThread(TCPMatrix matrix) {
            this.m_matrix = matrix;
        }

        public void run() {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("==> In run method of TCP comm. thread" + Thread.currentThread().getName()));
            }
            VerifyNetwork.this.checkTCPComm(this.m_matrix);
        }

        protected TCPMatrix getMatrix() {
            return this.m_matrix;
        }
    }

    class SubnetConThread
    extends Thread {
        String m_subnet;
        String[] m_IPList;
        String[] m_nodeList;
        ConMatrix m_matrix = null;

        SubnetConThread(String[] IPList, String[] nodeList, String subnet, ConMatrix matrix) {
            this.m_IPList = IPList;
            this.m_nodeList = nodeList;
            this.m_subnet = subnet;
            this.m_matrix = matrix;
            this.m_matrix.setIPList(IPList);
        }

        public void run() {
            Trace.out((String)("==> In run method of thread" + Thread.currentThread().getName()));
            VerifyNetwork.this.checkNodeConByIP(this.m_IPList, this.m_nodeList, this.m_matrix);
        }

        protected ConMatrix getMatrix() {
            return this.m_matrix;
        }

        String getSubnet() {
            return this.m_subnet;
        }
    }

    class IPConThread
    extends Thread {
        int m_srcIndex = -1;
        String[] m_IPList = null;
        String[] m_nodeList = null;
        boolean[] m_nodeConArray = null;
        String m_errMsg;
        private boolean m_succ = false;

        protected IPConThread(int srcIndex, String[] IPList, String[] nodeList, boolean[] nodeConArray) {
            this.m_srcIndex = srcIndex;
            this.m_IPList = IPList;
            this.m_nodeList = nodeList;
            this.m_nodeConArray = nodeConArray;
            this.m_succ = false;
        }

        protected boolean getResult() {
            return this.m_succ;
        }

        protected boolean[] getRowCon() {
            return this.m_nodeConArray;
        }

        protected int getSrcIndex() {
            return this.m_srcIndex;
        }

        public void run() {
            int numConnected = VerifyNetwork.getRowConByIP(this.m_srcIndex, this.m_IPList, this.m_nodeList, this.m_nodeConArray);
            this.m_succ = numConnected == this.m_nodeList.length;
            Trace.out((String)("==> Result of getRowConByIP " + this.m_succ));
        }
    }
}

