/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report;

import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ReportUtil {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    public static String ERROR = s_msgBundle.getMessage("8504", false);
    public static String WARNING = s_msgBundle.getMessage("8503", false);
    public static String UNKNOWN = s_msgBundle.getMessage("8200", false);
    public static String PASSED = s_msgBundle.getMessage("8201", false);
    public static String PINNED = s_msgBundle.getMessage("8509", false);
    public static String NOT_PINNED = s_msgBundle.getMessage("8510", false);
    public static String FAILED = s_msgBundle.getMessage("8202", false);
    public static String FAILED_IGNORABLE = s_msgBundle.getMessage("8222", false);
    public static String IGNORED = s_msgBundle.getMessage("8216", false);
    public static String SUCCESSFUL = s_msgBundle.getMessage("8203", false);
    public static String PARTIALLY_SUCCESSFUL = s_msgBundle.getMessage("8204", false);
    public static String MATCHED = s_msgBundle.getMessage("8217", false);
    public static String MISMATCHED = s_msgBundle.getMessage("8218", false);
    public static String INSTALLED = s_msgBundle.getMessage("8205", false);
    public static String MISSING = s_msgBundle.getMessage("8206", false);
    public static String ALIVE = s_msgBundle.getMessage("8207", false);
    public static String NOTALIVE = s_msgBundle.getMessage("8208", false);
    public static String ONLINE = s_msgBundle.getMessage("8221", false);
    public static String EXIST = s_msgBundle.getMessage("8209", false);
    public static String NOTEXIST = s_msgBundle.getMessage("8210", false);
    public static String YES = s_msgBundle.getMessage("8212", false);
    public static String NO = s_msgBundle.getMessage("8213", false);
    public static String ON = s_msgBundle.getMessage("8214", false);
    public static String OFF = s_msgBundle.getMessage("8215", false);
    public static String NOT_APPLICABLE = s_msgBundle.getMessage("8211", false);
    public static String STATUS = s_msgBundle.getMessage("8018", false);
    public static String REF_STATUS = s_msgBundle.getMessage("8021", false);
    public static String COMMENT = s_msgBundle.getMessage("8001", false);
    public static String AVAILABLE = s_msgBundle.getMessage("8012", false);
    public static String APPLIED = s_msgBundle.getMessage("8028", false);
    public static String CONFIGURED = s_msgBundle.getMessage("8023", false);
    public static String REQUIRED = s_msgBundle.getMessage("8019", false);
    public static String NODENAME = s_msgBundle.getMessage("8000", false);
    public static String CRS_OK = s_msgBundle.getMessage("8002", false);
    public static String RUNNING = s_msgBundle.getMessage("8003", false);
    public static String PROCESS = s_msgBundle.getMessage("8033", false);
    public static String DESTINATION_NODE = s_msgBundle.getMessage("8004", false);
    public static String REACHABLE = s_msgBundle.getMessage("8005", false);
    public static String SOURCE = s_msgBundle.getMessage("8006", false);
    public static String DESTINATION = s_msgBundle.getMessage("8007", false);
    public static String CONNECTED = s_msgBundle.getMessage("8008", false);
    public static String INTERFACE_NAME = s_msgBundle.getMessage("8009", false);
    public static String IPADDR = s_msgBundle.getMessage("8010", false);
    public static String SUBNET = s_msgBundle.getMessage("8011", false);
    public static String USER_EXISTS = s_msgBundle.getMessage("8013", false);
    public static String GROUP_ID = s_msgBundle.getMessage("8017", false);
    public static String GROUP_AND_GID = s_msgBundle.getMessage("8022", false);
    public static String GROUP_EXISTS = s_msgBundle.getMessage("8014", false);
    public static String USER_IN_GROUP = s_msgBundle.getMessage("8015", false);
    public static String PRIMARY = s_msgBundle.getMessage("8016", false);
    public static String DAEMON = s_msgBundle.getMessage("8020", false);
    public static String OS_PATCH = s_msgBundle.getMessage("8024", false);
    public static String PACKAGE = s_msgBundle.getMessage("8025", false);
    public static String OSVER = s_msgBundle.getMessage("8027", false);
    public static String KRNVER = s_msgBundle.getMessage("8032", false);
    public static String VERSION = s_msgBundle.getMessage("8029", false);
    public static String FILESIZE = s_msgBundle.getMessage("8030", false);
    public static String RUNLEVEL = s_msgBundle.getMessage("8031", false);
    public static String SHELL_LIMIT_TYPE = s_msgBundle.getMessage("8048", false);
    public static String PATH = s_msgBundle.getMessage("8040", false);
    public static String MNTPNT = s_msgBundle.getMessage("8034", false);
    public static String COMPONENT = s_msgBundle.getMessage("8053", false);
    public static String FILE = s_msgBundle.getMessage("8041", false);
    public static String SCANNAME = s_msgBundle.getMessage("4658", false);
    public static final int FORMAT_NO_KB = 1;
    public static final int FORMAT_ADD_KB = 2;
    private static long KILO_BYTE = 1024L;
    private static long MEGA_BYTE = 0x100000L;
    private static long GIGA_BYTE = 0x40000000L;
    private static String SPACES = "                                                                           ";
    private static String SEPARATOR = "---------------------------------------------------------------------------";
    private static int SPACE_1 = 1;
    private static int SPACE_2 = 2;
    private static int SPACE_4 = 4;
    private static int SPACE_8 = 8;
    private static int WOFCOL1 = 12;
    private static int WOFCOL2 = 24;
    private static int WOFCOL3 = 24;
    private static int WOFCOL4 = 10;
    private static int COLW_6 = 6;
    private static int COLW_8 = 8;
    private static int COLW_12 = 12;
    private static int COLW_15 = 15;
    private static int COLW_16 = 16;
    private static int COLW_17 = 17;
    private static int COLW_20 = 20;
    private static int COLW_24 = 24;
    private static int COLW_30 = 30;
    private static int COLW_36 = 36;
    private static int COLW_40 = 40;
    private static int COLW_1OF2_EQUAL = 32;
    private static int COLW_2OF2_EQUAL = 32;
    private static ParamManager pm = null;
    private static boolean isCLImode;

    public static boolean isVerbose() {
        return pm.checkArgVerbose();
    }

    public static boolean isFormat() {
        return pm.checkArgFormat();
    }

    public static boolean getMode() {
        return isCLImode;
    }

    public static void setMode(boolean newMode) {
        isCLImode = newMode;
    }

    public static void writeColHeaders(String hdr1) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteColHeaders(hdr1);
        }
    }

    public static void surewriteColHeaders(String hdr1) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        int col1 = COLW_36;
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(hdr1, col1));
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprintln(ReportUtil.getHdrSep(col1));
    }

    public static void writeRecord(String col1) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteRecord(col1);
        }
    }

    public static void surewriteRecord(String col1) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(col1, COLW_36));
    }

    public static void writeColHeaders(String hdr1, String hdr2) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteColHeaders(hdr1, hdr2);
        }
    }

    public static void surewriteColHeaders(String hdr1, String hdr2) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        int col1 = COLW_36;
        int col2 = COLW_24;
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr1, col1) + spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(hdr2, col2));
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(col1) + spacer);
        ReportUtil.sureprintln(ReportUtil.getHdrSep(col2));
    }

    public static void writeRecord(String col1, String col2) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteRecord(col1, col2);
        }
    }

    public static void surewriteRecord(String col1, String col2) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col1, COLW_36) + spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(col2, COLW_24));
    }

    public static void writeEqualColHeaders(String hdr1, String hdr2) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteEqualColHeaders(hdr1, hdr2);
        }
    }

    public static void surewriteEqualColHeaders(String hdr1, String hdr2) {
        String spacer_2 = ReportUtil.getPaddedStr("", SPACE_2);
        String spacer_8 = ReportUtil.getPaddedStr("", SPACE_8);
        int col1 = COLW_1OF2_EQUAL;
        int col2 = COLW_2OF2_EQUAL;
        ReportUtil.sureprint(spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr1, col1) + spacer_8);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(hdr2, col2));
        ReportUtil.sureprint(spacer_2);
        ReportUtil.sureprint(ReportUtil.getHdrSep(col1) + spacer_8);
        ReportUtil.sureprintln(ReportUtil.getHdrSep(col2));
    }

    public static void writeEqualRecord(String col1, String col2) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteEqualRecord(col1, col2);
        }
    }

    public static void surewriteEqualRecord(String col1, String col2) {
        String spacer_2 = ReportUtil.getPaddedStr("", SPACE_2);
        String spacer_8 = ReportUtil.getPaddedStr("", SPACE_8);
        ReportUtil.sureprint(spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col1, COLW_1OF2_EQUAL) + spacer_8);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(col2, COLW_2OF2_EQUAL));
    }

    public static void writeColHeaders(String hdr1, String hdr2, String hdr3, String hdr4) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteColHeaders(hdr1, hdr2, hdr3, hdr4);
        }
    }

    public static void surewriteColHeaders(String hdr1, String hdr2, String hdr3, String hdr4) {
        String spacer_2 = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr1, WOFCOL1) + spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr2, WOFCOL2) + spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr3, WOFCOL3) + spacer_2);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(hdr4, WOFCOL4));
        ReportUtil.sureprint(spacer_2);
        ReportUtil.sureprint(ReportUtil.getHdrSep(WOFCOL1) + spacer_2);
        ReportUtil.sureprint(ReportUtil.getHdrSep(WOFCOL2) + spacer_2);
        ReportUtil.sureprint(ReportUtil.getHdrSep(WOFCOL3) + spacer_2);
        ReportUtil.sureprintln(ReportUtil.getHdrSep(WOFCOL4));
    }

    public static void writeRecord(String col1, String col2, String col3, String col4) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteRecord(col1, col2, col3, col4);
        }
    }

    public static void surewriteRecord(String col1, String col2, String col3, String col4) {
        String spacer_2 = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col1, WOFCOL1) + spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col2, WOFCOL2) + spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col3, WOFCOL3) + spacer_2);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(col4, WOFCOL4));
    }

    public static void writeColHeaders(String hdr1, String hdr2, String hdr3) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteColHeaders(hdr1, hdr2, hdr3);
        }
    }

    public static void surewriteColHeaders(String hdr1, String hdr2, String hdr3) {
        String spacer_2 = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr1, WOFCOL1) + spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr2, WOFCOL2) + spacer_2);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(hdr3, WOFCOL3));
        ReportUtil.sureprint(spacer_2);
        ReportUtil.sureprint(ReportUtil.getHdrSep(WOFCOL1) + spacer_2);
        ReportUtil.sureprint(ReportUtil.getHdrSep(WOFCOL2) + spacer_2);
        ReportUtil.sureprintln(ReportUtil.getHdrSep(WOFCOL3));
    }

    public static void writeRecord(String col1, String col2, String col3) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteRecord(col1, col2, col3);
        }
    }

    public static void surewriteRecord(String col1, String col2, String col3) {
        String spacer_2 = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col1, WOFCOL1) + spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col2, WOFCOL2) + spacer_2);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(col3, WOFCOL3));
    }

    public static void writeColHeaders_2eq(String hdr1, String hdr2, String hdr3) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteColHeaders_2eq(hdr1, hdr2, hdr3);
        }
    }

    public static void surewriteColHeaders_2eq(String hdr1, String hdr2, String hdr3) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr1, COLW_30) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr2, COLW_30) + spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(hdr3, COLW_16));
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_30) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_30) + spacer);
        ReportUtil.sureprintln(ReportUtil.getHdrSep(COLW_16));
    }

    public static void writeRecord_2eq(String col1, String col2, String col3) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteRecord_2eq(col1, col2, col3);
        }
    }

    public static void surewriteRecord_2eq(String col1, String col2, String col3) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col1, COLW_30) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col2, COLW_30) + spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(col3, COLW_16));
    }

    public static void writeColHeaders(String hdr1, String hdr2, String hdr3, String hdr4, String hdr5) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteColHeaders(hdr1, hdr2, hdr3, hdr4, hdr5);
        }
    }

    public static void surewriteColHeaders(String hdr1, String hdr2, String hdr3, String hdr4, String hdr5) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr1, COLW_16) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr2, COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr3, COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr4, COLW_12) + spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(hdr5, COLW_16));
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_16) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_12) + spacer);
        ReportUtil.sureprintln(ReportUtil.getHdrSep(COLW_16));
    }

    public static void writeRecord(String col1, String col2, String col3, String col4, String col5) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteRecord(col1, col2, col3, col4, col5);
        }
    }

    public static void surewriteRecord(String col1, String col2, String col3, String col4, String col5) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col1, COLW_16) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col2, COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col3, COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col4, COLW_12) + spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(col5, COLW_16));
    }

    public static void writeColHeaders(String hdr1, String hdr2, String hdr3, String hdr4, String hdr5, String hdr6) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteColHeaders(hdr1, hdr2, hdr3, hdr4, hdr5, hdr6);
        }
    }

    public static void surewriteColHeaders(String hdr1, String hdr2, String hdr3, String hdr4, String hdr5, String hdr6) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr1, COLW_16) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr2, COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr3, COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr4, COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr5, COLW_12) + spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(hdr6, COLW_12));
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_16) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_12) + spacer);
        ReportUtil.sureprintln(ReportUtil.getHdrSep(COLW_12));
    }

    public static void writeRecord(String col1, String col2, String col3, String col4, String col5, String col6) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteRecord(col1, col2, col3, col4, col5, col6);
        }
    }

    public static void surewriteRecord(String col1, String col2, String col3, String col4, String col5, String col6) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col1, COLW_16) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col2, COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col3, COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col4, COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col5, COLW_12) + spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(col6, COLW_12));
    }

    public static void writeColHeaders(String hdr1, String hdr2, String hdr3, String hdr4, String hdr5, String hdr6, String hdr7) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteColHeaders(hdr1, hdr2, hdr3, hdr4, hdr5, hdr6, hdr7);
        }
    }

    public static void surewriteColHeaders(String hdr1, String hdr2, String hdr3, String hdr4, String hdr5, String hdr6, String hdr7) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_1);
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr1, COLW_6) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr2, COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr3, COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr4, COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr5, COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr6, COLW_17) + spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(hdr7, COLW_6));
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_6) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_17) + spacer);
        ReportUtil.sureprintln(ReportUtil.getHdrSep(COLW_6));
    }

    public static void writeRecord(String col1, String col2, String col3, String col4, String col5, String col6, String col7) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteRecord(col1, col2, col3, col4, col5, col6, col7);
        }
    }

    public static void surewriteRecord(String col1, String col2, String col3, String col4, String col5, String col6, String col7) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_1);
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col1, COLW_6) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col2, COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col3, COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col4, COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col5, COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col6, COLW_17) + spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(col7, COLW_6));
    }

    private static String getPaddedStr(String str, int width) {
        if (str == null) {
            return new String(SPACES.substring(0, width));
        }
        if (str.length() >= width) {
            return str;
        }
        return new String(str + SPACES.substring(0, width - str.length()));
    }

    private static String getHdrSep(int hwidth) {
        return SEPARATOR.substring(0, hwidth);
    }

    public static void print(String str) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.sureprint(str);
        }
    }

    public static void sureprint(String str) {
        if (isCLImode && !ReportUtil.isFormat()) {
            ReportUtil.quietprint(str);
        }
    }

    public static void quietprint(String str) {
        System.out.print(str);
    }

    public static void println(String str) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.sureprintln(str);
        }
    }

    public static void sureprintln(String str) {
        if (isCLImode && !ReportUtil.isFormat()) {
            ReportUtil.quietprintln(str);
        }
    }

    public static void quietprintln(String str) {
        System.out.println(str);
    }

    public static void blankln() {
        if (ReportUtil.isVerbose()) {
            ReportUtil.sureblankln();
        }
    }

    public static void sureblankln() {
        if (isCLImode && !ReportUtil.isFormat()) {
            ReportUtil.quietblankln();
        }
    }

    public static void quietblankln() {
        System.out.println("");
    }

    public static void blankln(int count) {
        if (ReportUtil.isVerbose()) {
            for (int i = 0; i < count; ++i) {
                ReportUtil.blankln();
            }
        }
    }

    public static void sureblankln(int count) {
        if (isCLImode && !ReportUtil.isFormat()) {
            ReportUtil.quietblankln(count);
        }
    }

    public static void quietblankln(int count) {
        for (int i = 0; i < count; ++i) {
            ReportUtil.quietblankln();
        }
    }

    public static String unitize(String value, int format) {
        return ReportUtil.unitizeSize(value, StorageUnit.BYTE, format);
    }

    public static String unitizeByte(String value) {
        return ReportUtil.unitize(value, 2);
    }

    public static String unitizeSize(String value, StorageUnit sizeInUnits, int format) {
        StorageSize val;
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("====Attempting to unitize '" + value + (Object)((Object)sizeInUnits) + "'"));
        }
        try {
            val = new StorageSize(Double.parseDouble(value), sizeInUnits);
        }
        catch (NumberFormatException e) {
            Trace.out((String)("Invalid value '" + value + "'. Did not attempt to unitize"));
            return value;
        }
        return ReportUtil.unitizeSize(val, format);
    }

    public static String unitizeSize(StorageSize val, int format) {
        double d;
        if (val == null) {
            Trace.out((String)"Null memory size value ''. Did not attempt to unitize");
            return null;
        }
        String fmttxt = null;
        String kbText = "";
        DecimalFormat numFormat = new DecimalFormat("###.####");
        numFormat.setMaximumFractionDigits(4);
        numFormat.setDecimalSeparatorAlwaysShown(false);
        if (format == 2) {
            double kbVal = val.sizeIn(StorageUnit.KBYTE);
            kbText = "(" + kbVal + "KB)";
        } else if (format != 1) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"==== Invalid unitizing format. Proceeding with default");
            }
            format = 1;
        }
        double dFinalval = val.sizeIn(StorageUnit.TBYTE);
        if (d >= 1.0) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("==== " + val + " in TB: " + dFinalval));
            }
            fmttxt = numFormat.format(dFinalval) + "TB " + kbText;
        } else {
            double d2;
            dFinalval = val.sizeIn(StorageUnit.GBYTE);
            if (d2 >= 1.0) {
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("==== " + val + " in GB: " + dFinalval));
                }
                fmttxt = numFormat.format(dFinalval) + "GB " + kbText;
            } else {
                double d3;
                dFinalval = val.sizeIn(StorageUnit.MBYTE);
                if (d3 >= 1.0) {
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)("==== " + val + " in MB: " + dFinalval));
                    }
                    fmttxt = numFormat.format(dFinalval) + "MB " + kbText;
                } else {
                    double d4;
                    dFinalval = val.sizeIn(StorageUnit.KBYTE);
                    if (d4 >= 1.0) {
                        if (Trace.isLevelEnabled((int)1)) {
                            Trace.out((String)("==== " + val + " in KB: " + dFinalval));
                        }
                        fmttxt = numFormat.format(dFinalval) + "KB ";
                    } else {
                        fmttxt = val.sizeIn(StorageUnit.BYTE) + " bytes";
                    }
                }
            }
        }
        return fmttxt;
    }

    public static String unitizeSize(String value, StorageUnit sizeInUnits) {
        return ReportUtil.unitizeSize(value, sizeInUnits, 2);
    }

    public static String unitizeSize(StorageSize size) {
        return ReportUtil.unitizeSize(size, 2);
    }

    public static void printCopyright() {
        ReportUtil.sureprintln(s_msgBundle.getMessage("0004", false));
    }

    public static void printReportHeader() {
        if (pm.checkArgComp()) {
            String compName = pm.getCompID();
            Trace.out((String)("Component name in ReportUtil is:" + compName));
            String compMsgID = ReportUtil.getCompMsgID(compName);
            Trace.out((String)("Component ID in ReportUtil is:" + compMsgID));
            ReportUtil.sureblankln();
            ReportUtil.sureprintln(s_msgBundle.getMessage("8110", false, (Object[])new String[]{s_msgBundle.getMessage(compMsgID, false)}));
        } else if (pm.checkArgStage()) {
            boolean isPre = pm.checkArgPre();
            String stageHdrID = isPre ? "8111" : "8112";
            String stageName = pm.getStageID();
            String stageMsgID = ReportUtil.getStageMsgID(stageName);
            ReportUtil.sureblankln();
            ReportUtil.sureprintln(s_msgBundle.getMessage(stageHdrID, false, (Object[])new String[]{s_msgBundle.getMessage(stageMsgID, false)}));
        } else {
            Trace.out((String)"ERROR: Stage or comp was not defined");
            ReportUtil.sureprintln("ERROR: Stage or comp can not be handled.");
        }
    }

    public static String getCompMsgID(String compName) {
        String compMsgID = null;
        if (compName.equals("nodecon")) {
            compMsgID = "8311";
        } else if (compName.equals("nodereach")) {
            compMsgID = "8309";
        } else if (compName.equals("space")) {
            compMsgID = "8314";
        } else if (compName.equals("ssa")) {
            compMsgID = "8313";
        } else if (compName.equals("sys")) {
            compMsgID = "8315";
        } else if (compName.equals("admprv")) {
            compMsgID = "8320";
        } else if (compName.equals("cfs")) {
            compMsgID = "8312";
        } else if (compName.equals("clumgr")) {
            compMsgID = "8317";
        } else if (compName.equals("clu")) {
            compMsgID = "8316";
        } else if (compName.equals("ocr")) {
            compMsgID = "8318";
        } else if (compName.equals("olr")) {
            compMsgID = "8323";
        } else if (compName.equals("ha")) {
            compMsgID = "8324";
        } else if (compName.equals("crs")) {
            compMsgID = "8319";
        } else if (compName.equals("peer")) {
            compMsgID = "8321";
        } else if (compName.equals("nodeapp")) {
            compMsgID = "8322";
        } else if (compName.equals("scan")) {
            compMsgID = "8335";
        } else if (compName.equals("software")) {
            compMsgID = "8328";
        } else if (compName.equals("asm")) {
            compMsgID = "8336";
        } else if (compName.equals("acfs")) {
            compMsgID = "8330";
        } else if (compName.equals("gns")) {
            compMsgID = "8333";
        } else if (compName.equals("gpnp")) {
            compMsgID = "8334";
        } else if (compName.equals("ohasd")) {
            compMsgID = "8337";
        } else if (compName.equals("clocksync")) {
            compMsgID = "8338";
        } else if (compName.equals("vdisk")) {
            compMsgID = "8339";
        } else if (compName.equals("health")) {
            compMsgID = "8340";
        }
        return compMsgID;
    }

    public static String getStageMsgID(String stageName) {
        String stageMsgID = null;
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("getStageMsgID(): stageName = " + stageName));
            Trace.out((String)"getStageMsgID(): VerificationConstants.COMP_CTSS_INTEGRITY = clocksync");
        }
        if (stageName.equals("hwos")) {
            stageMsgID = "8300";
        } else if (stageName.equals("cfs")) {
            stageMsgID = "8301";
        } else if (stageName.equals("crsinst")) {
            stageMsgID = "8302";
        } else if (stageName.equals("hacfg")) {
            stageMsgID = "8325";
        } else if (stageName.equals("dbinst")) {
            stageMsgID = "8303";
        } else if (stageName.equals("dbcfg")) {
            stageMsgID = "8305";
        } else if (stageName.equals("nodeadd")) {
            stageMsgID = "8306";
        } else if (stageName.equals("storadd")) {
            stageMsgID = "8307";
        } else if (stageName.equals("netmod")) {
            stageMsgID = "8308";
        } else if (stageName.equals("nodeadd")) {
            stageMsgID = "8306";
        } else if (stageName.equals("nodedel")) {
            stageMsgID = "8327";
        } else if (stageName.equals("acfscfg")) {
            stageMsgID = "8329";
        }
        return stageMsgID;
    }

    public static void printReportFooter(ResultSet resultSet) {
        String statusMsgID = null;
        String compMsgID = null;
        String stageMsgID = null;
        boolean partFailure = false;
        if (pm.checkArgComp()) {
            String compName = pm.getCompID();
            compMsgID = ReportUtil.getCompMsgID(compName);
            if (resultSet.anyFailure() && resultSet.anySuccess()) {
                statusMsgID = "8122";
                partFailure = true;
            } else if (resultSet.anySuccess()) {
                statusMsgID = "8121";
            } else {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("compMsgID: " + compMsgID));
                }
                statusMsgID = compMsgID == "8323" || compMsgID == "8324" || compMsgID == "8325" ? "8130" : "8123";
            }
            ReportUtil.sureblankln();
            ReportUtil.sureprintln(s_msgBundle.getMessage(statusMsgID, false, (Object[])new String[]{s_msgBundle.getMessage(compMsgID, false)}));
            if (partFailure) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("8102", false));
                ReportUtil.sureprintNodelist(resultSet.getFailureNodes());
            }
            if (pm.checkArgDisplayStatus()) {
                ReportUtil.printDetailedStatus(resultSet);
            }
        } else if (pm.checkArgStage()) {
            boolean isPre = pm.checkArgPre();
            String stageName = pm.getStageID();
            stageMsgID = ReportUtil.getStageMsgID(stageName);
            if (resultSet.anyFailure() && resultSet.anySuccess()) {
                statusMsgID = isPre ? "8125" : "8128";
                partFailure = true;
            } else if (resultSet.anySuccess()) {
                statusMsgID = isPre ? "8124" : "8127";
            } else if (isPre) {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("stageMsgID: " + stageMsgID));
                }
                statusMsgID = stageMsgID == "8325" ? "8132" : "8126";
            } else {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("stageMsgID: " + stageMsgID));
                }
                statusMsgID = stageMsgID == "8325" ? "8131" : "8129";
            }
            ReportUtil.sureblankln();
            ReportUtil.sureprintln(s_msgBundle.getMessage(statusMsgID, false, (Object[])new String[]{s_msgBundle.getMessage(stageMsgID, false)}));
            if (partFailure) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("8102", false));
                ReportUtil.sureprintNodelist(resultSet.getFailureNodes());
            }
            if (pm.checkArgDisplayStatus()) {
                ReportUtil.printDetailedStatus(resultSet);
            }
        } else {
            Trace.out((String)"ERROR: Stage or comp was not defined");
            ReportUtil.sureprintln("ERROR: Stage or comp can not be handled.");
        }
    }

    public static void printErrorHeader(String subject) {
        ReportUtil.sureprintln(VerificationConstants.LSEP + ERROR + " " + subject);
    }

    public static void printError(String msg) {
        ReportUtil.sureprintln(VerificationConstants.LSEP + ERROR + VerificationConstants.LSEP + msg);
    }

    public static void printWarning(String msg) {
        ReportUtil.sureprintln(VerificationConstants.LSEP + WARNING + VerificationConstants.LSEP + msg);
    }

    public static void printWarning(String msg, Vector nodeVect) {
        ReportUtil.sureprintln(VerificationConstants.LSEP + WARNING + VerificationUtil.strVect2List(nodeVect) + VerificationConstants.LSEP + msg);
    }

    public static void printResult(String msg) {
        String prefix = "";
        if (ReportUtil.isVerbose()) {
            prefix = s_msgBundle.getMessage("8506", false);
        }
        ReportUtil.sureprintln(prefix + msg);
    }

    public static void printComment(String msg) {
        String prefix = "";
        if (ReportUtil.isVerbose()) {
            prefix = "Comment: ";
        }
        ReportUtil.sureprintln(prefix + msg);
    }

    public static void printNodelist(String[] nodelist) {
        String text = VerificationUtil.strArr2List(nodelist);
        ReportUtil.println("\t" + text);
    }

    public static void printNodelist(Vector nodelistVec) {
        ReportUtil.printNodelist(nodelistVec.toArray(new String[nodelistVec.size()]));
    }

    public static void sureprintNodelist(String[] nodelist) {
        String text = VerificationUtil.strArr2List(nodelist);
        ReportUtil.sureprintln("\t" + text);
    }

    public static void sureprintNodelist(Vector nodelistVec) {
        ReportUtil.sureprintNodelist(nodelistVec.toArray(new String[nodelistVec.size()]));
    }

    public static void printErrorNodes(String[] nodelist) {
        if (nodelist == null || nodelist.length <= 0) {
            Trace.out((String)"==== Nodelist is empty or null. Cannot print");
            return;
        }
        if (!ReportUtil.isVerbose()) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("8505", false));
            String text = VerificationUtil.strArr2List(nodelist);
            ReportUtil.sureprintln("\t" + text);
        }
    }

    public static void printErrorNodes(Vector nodelistVec) {
        ReportUtil.printErrorNodes(nodelistVec.toArray(new String[nodelistVec.size()]));
    }

    public static void printErrorNodes(ResultSet resultSet) {
        ReportUtil.printErrorNodes(resultSet.getFailureNodes());
    }

    public static void printErrorWithNodes(String msg, String[] nodelist) {
        if (!ReportUtil.isVerbose()) {
            ReportUtil.sureprintln(VerificationConstants.LSEP + ERROR + VerificationConstants.LSEP + msg);
        }
        ReportUtil.printErrorNodes(nodelist);
    }

    public static void printErrorWithNodes(String msg, Vector nodelistVec) {
        ReportUtil.printErrorWithNodes(msg, nodelistVec.toArray(new String[nodelistVec.size()]));
    }

    public static void reportNotRunList(String[] nodelist) {
        if (nodelist == null || nodelist.length <= 0) {
            Trace.out((String)"==== reportNotRunList: empty or null nodelist. Cannot print");
            return;
        }
        if (!ReportUtil.isVerbose()) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("8101", false));
            ReportUtil.sureprintNodelist(nodelist);
        }
    }

    public static void reportNotRunList(Vector vec) {
        ReportUtil.reportNotRunList(vec.toArray(new String[vec.size()]));
    }

    private static void printDetailedStatus(ResultSet rset) {
        Hashtable t = rset.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            ReportUtil.sureprintln("NODE_STATUS::" + node + ":" + ReportUtil.statusOfResult(result));
        }
        ReportUtil.sureprintln("OVERALL_STATUS::" + ReportUtil.statusOfResultSet(rset));
    }

    public static String statusOfResultSet(ResultSet rset) {
        switch (rset.getStatus()) {
            case 1: {
                return "SUCC";
            }
            case 2: {
                return "EFAIL";
            }
            case 3: {
                return "VFAIL";
            }
            case 4: {
                return "WARNING";
            }
        }
        return "UNKNOWN";
    }

    public static String statusOfResult(Result result) {
        switch (result.getStatus()) {
            case 1: {
                return "SUCC";
            }
            case 2: {
                return "EFAIL";
            }
            case 3: {
                return "VFAIL";
            }
            case 4: {
                return "WARNING";
            }
        }
        return "UNKNOWN";
    }

    static {
        try {
            pm = ParamManager.getInstance();
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((Exception)e);
        }
        isCLImode = pm.getMode() == ParamManager.OperationMode.MODE_CLI;
    }
}

