/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.trace.Trace;

public class ASMDiskGroup {
    private StorageSize m_size = new StorageSize(0.0, StorageUnit.BYTE);
    private StorageSize m_free = new StorageSize(0.0, StorageUnit.BYTE);
    String m_redundancy = null;
    String m_name = null;
    String m_asmsid = null;

    public boolean parseInput(String input) {
        int i;
        String[] values = input.trim().split("[ ]+");
        if (values.length < 4) {
            return false;
        }
        for (i = 0; i < values.length; ++i) {
            Trace.out((String)("Reading kfod output-values[" + i + "] =" + values[i]));
        }
        block12: for (i = 0; i < values.length; ++i) {
            switch (i) {
                case 0: {
                    try {
                        this.m_size = new StorageSize(Double.parseDouble(values[i].trim()), StorageUnit.MBYTE);
                    }
                    catch (NumberFormatException e) {
                        this.m_size = new StorageSize(-1.0, StorageUnit.BYTE);
                    }
                    continue block12;
                }
                case 1: {
                    try {
                        this.m_free = new StorageSize(Double.parseDouble(values[i].trim()), StorageUnit.MBYTE);
                    }
                    catch (NumberFormatException e) {
                        this.m_free = new StorageSize(-1.0, StorageUnit.BYTE);
                    }
                    continue block12;
                }
                case 2: {
                    this.m_redundancy = values[i].trim();
                    continue block12;
                }
                case 3: {
                    this.m_name = values[i].trim();
                    continue block12;
                }
                case 4: {
                    this.m_asmsid = values[i].trim();
                    continue block12;
                }
            }
        }
        return true;
    }

    public StorageSize getSize() {
        return this.m_size;
    }

    public StorageSize getFree() {
        return this.m_free;
    }

    public String getRedundancyType() {
        return this.m_redundancy;
    }

    public String getName() {
        return this.m_name;
    }

    public String getASMSID() {
        return this.m_asmsid;
    }

    public String toString() {
        return "Name:" + this.m_name + " Size:" + this.m_size + " Free:" + this.m_free + " ASMSID:" + this.m_asmsid + " RedundancyType:" + this.m_redundancy;
    }
}

