/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.Vector;
import oracle.ops.mgmt.command.util.RemoteExecCommand;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.storage.NotFileSystemException;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

public abstract class CommandHandler
implements StorageConstants {
    VerificationCommand genFSTypeCmd(String node, String path) {
        String[] arg = new String[]{"-getfstype", path};
        String[] env = null;
        return new VerificationCommand(node, arg, env);
    }

    int parseFSTypeResult(VerificationCommand vfyCmd, String path) throws StorageException {
        int[] fsType;
        String[] tags = new String[]{"FSTYPE"};
        int vfyCode = vfyCmd.getVfyCode();
        String output = vfyCmd.getOutput();
        if (19 == vfyCode) {
            NotFileSystemException se = new NotFileSystemException("7019", vfyCmd.getNode(), new String[]{path});
            throw se;
        }
        if (0 != vfyCode) {
            Trace.out((String)("vfyCode for getfstype = " + String.valueOf(vfyCode)));
            throw new StorageException();
        }
        try {
            if (null == output) {
                Trace.out((String)"output of getfstype was null!");
                throw new StorageException();
            }
            fsType = GenericUtil.getIntFieldsByTags(output, tags);
        }
        catch (ParsingException pe) {
            Trace.out((String)("Problem parsing the string " + output));
            Trace.out((Exception)pe);
            throw new StorageException();
        }
        return fsType[0];
    }

    VerificationCommand genTypeCmd(String node, String path) {
        String[] arg = new String[]{"-getsttype", path};
        String[] env = null;
        return new VerificationCommand(node, arg, env);
    }

    abstract StorageInfo parseTypeResult(VerificationCommand var1, String var2) throws StorageException;

    public abstract RemoteExecCommand genInfoCmd(String var1, int var2) throws StorageException;

    public abstract RemoteExecCommand genInfoCmd(String var1, int var2, String var3) throws StorageException;

    public abstract RemoteExecCommand genInfoCmd(String var1, int var2, String var3, String var4, Result var5) throws StorageException;

    public abstract Vector parseInfoResult(RemoteExecCommand var1, int var2) throws StorageException;

    public abstract StorageInfo parseInfoResult(RemoteExecCommand var1, int var2, String var3) throws StorageException;
}

