/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageInfo;

public class FSInfo
extends StorageInfo
implements StorageConstants {
    private String m_fsname;
    private int m_fstype;
    private long m_fsbsize;
    private long m_fsblocks;
    private long m_fsbfree;
    private long m_fsbavail;
    private long m_fsfiles;
    private long m_fsfree;
    private int m_fsaccess;

    public FSInfo(String node, String path) {
        super(path, node, 5);
        this.m_fsname = path;
    }

    public FSInfo(String node, String path, int fstype, long fsbsize, long fsblocks, long fsbfree, long fsbavail, long fsfiles, long fsfree, int fsaccess) {
        super(path, node, 5);
        this.m_fsname = path;
        this.m_fstype = fstype;
        this.m_fsbsize = fsbsize;
        this.m_fsblocks = fsblocks;
        this.m_fsbfree = fsbfree;
        this.m_fsbavail = fsbavail;
        this.m_fsfiles = fsfiles;
        this.m_fsfree = fsfree;
        this.m_fsaccess = fsaccess;
        this.setFree(new StorageSize((double)this.m_fsbavail / 1024.0 * (double)this.m_fsbsize, StorageUnit.KBYTE));
        this.setAccess(fsaccess);
    }

    public String getFSname() {
        return this.m_fsname;
    }

    public int getFStype() {
        return this.m_fstype;
    }

    public long getFSbsize() {
        return this.m_fsbsize;
    }

    public long getFSblocks() {
        return this.m_fsblocks;
    }

    public long getFSbfree() {
        return this.m_fsbfree;
    }

    public long getFSbavail() {
        return this.m_fsbavail;
    }

    public long getFSfiles() {
        return this.m_fsfiles;
    }

    public long getFSfree() {
        return this.m_fsfree;
    }

    public int getFSaccess() {
        return this.m_fsaccess;
    }

    public StorageSize getSize() {
        return new StorageSize(this.m_fsblocks / 1024L * this.m_fsbsize, StorageUnit.KBYTE);
    }
}

