/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.Vector;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.SharedVerifyStrategy;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.sStorageUtil;

public class FSSharedVerifyStrategy
extends SharedVerifyStrategy
implements StorageConstants {
    int m_type = 5;

    public boolean isShared(StorageInfo stInfo, String[] nodeList) throws StorageException {
        Vector stList = new Vector();
        return this.isShared(stInfo, nodeList, stList);
    }

    public boolean isShared(StorageInfo stInfo, String[] nodeList, Vector stList) throws StorageException {
        boolean retVal = false;
        String path = stInfo.getName();
        String localNode = sStorageUtil.getLocalHost();
        Trace.out((String)("Check isShared LocalNode: " + localNode + " | path:" + path));
        try {
            for (int l = 0; l < nodeList.length; ++l) {
                StorageInfo st = new StorageInfo(path, nodeList[l], 5);
                stList.add(st);
            }
            if (nodeList.length == 1) {
                Trace.out((String)("Cluster.isSharedPath has one 1 node in nodelist: " + nodeList[0]));
                retVal = true;
            } else {
                retVal = Cluster.isSharedPath((String)path, (String[])nodeList, (String)localNode);
            }
            Trace.out((String)("Cluster isSharedPath returned " + retVal));
        }
        catch (SharedDeviceException sde) {
            Trace.out((String)("SharedDeviceException: " + sde.getMessage()));
            retVal = false;
        }
        catch (InvalidNodeListException ine) {
            Trace.out((String)("InvalidNodeListException: " + ine.getMessage()));
            throw new StorageException(ine);
        }
        return retVal;
    }
}

