/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.StorageType;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.sStorageUtil;

public class SharedStorageSet {
    private int m_type;
    private int m_numNodes = 0;
    private Hashtable m_nodeTable;
    private Vector m_sharedSet;

    public SharedStorageSet(int type) {
        this.m_type = type;
        this.m_sharedSet = new Vector();
        this.m_nodeTable = new Hashtable();
    }

    public SharedStorageSet(Vector sharedSet, int type) {
        this.m_type = type;
        this.m_sharedSet = sharedSet;
        this.m_nodeTable = new Hashtable();
        Enumeration stEnum = sharedSet.elements();
        while (stEnum.hasMoreElements()) {
            String node = ((StorageInfo)stEnum.nextElement()).getNode();
            if (null != this.m_nodeTable.get(node)) continue;
            ++this.m_numNodes;
            this.m_nodeTable.put(node, node);
        }
    }

    public void add(StorageInfo st) {
        this.m_sharedSet.add(st);
        String node = st.getNode();
        Integer numStPerNode = (Integer)this.m_nodeTable.get(node);
        if (null == numStPerNode) {
            ++this.m_numNodes;
            this.m_nodeTable.put(node, new Integer(1));
        } else {
            this.m_nodeTable.put(node, new Integer(numStPerNode + 1));
        }
    }

    public boolean remove(StorageInfo st) {
        boolean ret;
        if (this.m_sharedSet.remove(st)) {
            String node = st.getNode();
            int numStPerNode = (Integer)this.m_nodeTable.get(node);
            if (1 == numStPerNode) {
                --this.m_numNodes;
                this.m_nodeTable.remove(node);
            } else {
                this.m_nodeTable.put(node, new Integer(numStPerNode - 1));
            }
            ret = true;
        } else {
            ret = false;
        }
        return ret;
    }

    public Collection getNodeCollection() {
        return this.m_nodeTable.values();
    }

    public int getNumNodes() {
        return this.m_numNodes;
    }

    public Vector getSharedSet() {
        return (Vector)this.m_sharedSet.clone();
    }

    public String getTypeStr() {
        return sStorageUtil.getTypeStr(this.m_type);
    }

    public StorageType getTypeEnum() {
        return sStorageUtil.getTypeEnum(this.m_type);
    }

    protected int getType() {
        return this.m_type;
    }

    protected int size() {
        return this.m_sharedSet.size();
    }

    public String toString() {
        StringBuffer stBuf = new StringBuffer();
        stBuf.append(this.getTypeStr() + "\n");
        Enumeration stEnum = this.m_sharedSet.elements();
        while (stEnum.hasMoreElements()) {
            stBuf.append("\t" + stEnum.nextElement().toString() + "\n");
        }
        return stBuf.toString();
    }
}

