/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.OracleFileType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.SharedStorageSet;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.sStorageUtil;
import oracle.ops.verification.util.MultiNodeException;

public class SharedStrategy {
    protected OracleFileType m_oracleFileType = OracleFileType.RAC_DATA_FILES;
    protected boolean m_checkPath = false;

    public void setOracleFileType(OracleFileType fileType) {
        this.m_oracleFileType = fileType;
    }

    public void setCheckPath(boolean checkPath) {
        this.m_checkPath = checkPath;
    }

    public void findShared(Vector stList, Vector superSet) throws StorageException, MultiNodeException {
        int numSharedSets = 0;
        Hashtable<String, SharedStorageSet> storageTable = new Hashtable<String, SharedStorageSet>();
        StorageInfo stInfo = null;
        Enumeration e = stList.elements();
        while (e.hasMoreElements()) {
            stInfo = (StorageInfo)e.nextElement();
            String key = stInfo.getSignature();
            SharedStorageSet sharedSet = (SharedStorageSet)storageTable.get(key);
            if (null == sharedSet) {
                ++numSharedSets;
                sharedSet = new SharedStorageSet(stInfo.getType());
                storageTable.put(key, sharedSet);
                superSet.add(sharedSet);
            }
            sharedSet.add(stInfo);
        }
        if (null != stInfo) {
            Trace.out((String)("NumShared " + sStorageUtil.getTypeStr(stInfo.getType()) + " " + numSharedSets));
        }
    }
}

