/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import oracle.cluster.verification.OracleFileType;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.util.RemoteExecCommand;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.CommandHandler;
import oracle.ops.verification.framework.storage.CommandHandlerFactory;
import oracle.ops.verification.framework.storage.SharedStorageSet;
import oracle.ops.verification.framework.storage.SharedStrategy;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.sStrategyProvider;
import oracle.ops.verification.util.MultiNodeException;

class SharedVerifyStrategy {
    private static CommandHandler s_commandHandler = CommandHandlerFactory.createCommandHandler();
    private static final String s_UnreliableSignatureException = "oracle.ops.verification.util.UnreliableSignatureException";
    protected OracleFileType m_oracleFileType = OracleFileType.RAC_DATA_FILES;

    SharedVerifyStrategy() {
    }

    public void setOracleFileType(OracleFileType fileType) {
        this.m_oracleFileType = fileType;
    }

    protected boolean isShared(StorageInfo stInfo, String[] nodeList) throws StorageException, MultiNodeException {
        Vector stList = new Vector();
        return this.isShared(stInfo, nodeList, stList);
    }

    protected boolean isShared(StorageInfo stInfo, String[] nodeList, Vector stList) throws StorageException, MultiNodeException {
        boolean retVal = false;
        int type = stInfo.getType();
        String prefPath = null;
        String[] pathList = new String[nodeList.length];
        MultiNodeException mne = null;
        Trace.out((String)("This storage type = " + stInfo.getType()));
        prefPath = stInfo.getType() == 1 ? (stInfo.getName().equals(stInfo.getOrigPath()) ? stInfo.getName() : stInfo.getName() + "%" + stInfo.getOrigPath()) : stInfo.getName();
        for (int i = 0; i < nodeList.length; ++i) {
            pathList[i] = prefPath;
        }
        Trace.out((String)"about to call getStorageInfo(4 args)");
        this.getStorageInfoByPath(pathList, type, nodeList, stList);
        if (stList.size() > 0) {
            SharedStrategy strategy = sStrategyProvider.getSharedStrategy(type);
            strategy.setCheckPath(true);
            strategy.setOracleFileType(this.m_oracleFileType);
            Vector superSet = new Vector();
            Enumeration ev = stList.elements();
            while (ev.hasMoreElements()) {
                ((StorageInfo)ev.nextElement()).setOrigPath(stInfo.getOrigPath());
            }
            try {
                strategy.findShared(stList, superSet);
            }
            catch (MultiNodeException e) {
                Trace.out((String)"MultiNodeException occured");
                mne = e;
            }
            int numStorages = 0;
            Enumeration e = superSet.elements();
            if (e.hasMoreElements()) {
                numStorages = ((SharedStorageSet)e.nextElement()).getSharedSet().size();
            }
            Trace.out((String)("superSet size = " + superSet.size()));
            Trace.out((String)("numStorages = " + numStorages));
            if (1 == superSet.size() && nodeList.length == numStorages) {
                retVal = true;
            } else {
                retVal = false;
                if (null != mne) {
                    if (superSet.size() == 0) {
                        throw mne;
                    }
                    if (superSet.size() == 1) {
                        boolean badSig = false;
                        Iterator expIter = mne.getThrowables().iterator();
                        while (expIter.hasNext() && !badSig) {
                            String className = expIter.next().getClass().getName();
                            if (!s_UnreliableSignatureException.equals(className)) continue;
                            badSig = true;
                        }
                        if (!badSig) {
                            throw mne;
                        }
                    }
                }
            }
            if (!retVal) {
                Trace.out((String)("number of shared groups: " + superSet.size()));
            }
        } else {
            Trace.out((String)("No instances found, storage: " + stInfo.getName()));
            throw new StorageException("7008");
        }
        return retVal;
    }

    Vector getStorageInfoByPath(String[] pathList, int type, String[] nodeList, Vector stList) throws StorageException {
        String node = null;
        String path = null;
        int numNodes = nodeList.length;
        boolean cmdSucc = false;
        Command[] cmdArray = new Command[numNodes];
        for (int i = 0; i < nodeList.length; ++i) {
            node = nodeList[i];
            path = pathList[i];
            Trace.out((String)("getStorageInfoByPath: Calling genInfoCmd with path = " + pathList[i] + ", and type =" + type));
            cmdArray[i] = s_commandHandler.genInfoCmd(node, type, path);
        }
        try {
            Trace.out((String)"_st_:about to gather stinfo");
            cmdSucc = new ClusterCmd().submit(cmdArray);
        }
        catch (ClusterException e) {
            Trace.out((String)("_st_:>>ClusterException[Thread:" + Thread.currentThread().getName() + "]: " + (Object)((Object)e)));
        }
        if (!cmdSucc) {
            Trace.out((String)"_st_:ClusterCmd.submit failed ");
        }
        for (int i = 0; i < nodeList.length; ++i) {
            node = nodeList[i];
            path = pathList[i];
            Command remCmd = cmdArray[i];
            if (!remCmd.getStatus()) {
                Trace.out((String)("_st_:Failed getting info from:" + node + ":" + path));
                String[] errLines = remCmd.getCommandResult().getResultString();
                if (null == errLines) continue;
                for (int line = 0; line < errLines.length; ++line) {
                    Trace.out((String)("_st_:>>" + errLines[line]));
                }
                continue;
            }
            StorageInfo st = s_commandHandler.parseInfoResult((RemoteExecCommand)remCmd, type, path);
            if (null != st) {
                stList.add(st);
                continue;
            }
            Trace.out((String)("_st_:Failed to get info from:" + node + ":" + path));
        }
        return stList;
    }
}

