/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.verification.framework.util.VerificationUtil;

public class StorageException
extends Exception
implements Comparable {
    private String m_node = "";
    private String m_msgId = "7000";
    private static String s_facility = "Prvf";
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle(s_facility);
    public static final String MSGID_DEFAULT_MESG = "7000";
    public static final String MSGID_ERROR_DISKGROUP_INFO = "7001";
    public static final String MSGID_ERROR_DISK_INFO = "7002";
    public static final String MSGID_MUST_RUN_IN_CLUSTER = "7003";
    public static final String MSGID_NOT_FOUND = "7004";
    public static final String MSGID_NOT_UNIQUE_NAME = "7005";
    public static final String MSGID_NODE_NOT_IN_CLUSTER = "7006";
    public static final String MSGID_LOCAL_NODE_NOT_FOUND = "7007";
    public static final String MSGID_STORAGE_NOT_FOUND = "7008";
    public static final String MSGID_TYPE_NOT_FOUND = "7009";
    public static final String MSGID_TYPE_FAILED = "7010";
    public static final String MSGID_VENDOR_NODELIST_NOT_FOUND = "7011";
    public static final String MSGID_UNEXPECTED_FORMAT = "7012";
    public static final String MSGID_TRY_DIFFERENT_PATH_LIKE = "7013";
    public static final String MSGID_OCFS_NEEDS_UPGRADE = "7016";
    public static final String MSGID_TYPE_NOT_SUPPORTED = "7014";
    public static final String MSGID_NOT_SHARED_FS = "7015";
    public static final String MSGID_NOT_FS = "7019";
    public static final String MSGID_DISK_EXE_REQUIRED = "7017";
    public static final String MSGID_IMPROPER_PACKAGE_VERSION = "7533";
    public static final String MSGID_DISK_EXE_ACCESS_DENIED = "7021";
    public static final String MSGID_SHAREDNESS_UNDETERMINED = "7020";
    public static final String MSGID_NFS_MNT_OPTS_NOT_AS_EXPECTED = "7036";

    public StorageException(String msgId) {
        this(msgId, null, null);
    }

    public StorageException(String msgId, Throwable e) {
        this(msgId, null, null, e);
    }

    public StorageException(Throwable e) {
        this(MSGID_DEFAULT_MESG, null, null, e);
    }

    public StorageException() {
        this(MSGID_DEFAULT_MESG, null, null);
    }

    public StorageException(String msgId, String node, Object[] args) {
        super(s_msgBundle.getMessage(msgId, false, args));
        this.m_msgId = msgId;
        if (null != node) {
            this.m_node = node;
        }
    }

    public StorageException(String msgId, Object[] args) {
        super(s_msgBundle.getMessage(msgId, false, args));
        this.m_msgId = msgId;
    }

    public StorageException(String msgId, String node, Object[] args, Throwable e) {
        this(msgId, node, args, e, false);
    }

    public StorageException(String msgId, String node, Object[] args, Throwable e, boolean displayFacility) {
        super(s_msgBundle.getMessage(msgId, displayFacility, args), e);
        this.m_msgId = msgId;
        if (null != node) {
            this.m_node = node;
        }
    }

    public String getNode() {
        return this.m_node;
    }

    public String getMessageKey() {
        return s_facility + this.m_msgId;
    }

    public int compareTo(Object obj) {
        int result = 0;
        StorageException st = (StorageException)obj;
        result = this.getNode().compareTo(st.getNode());
        if (0 == result) {
            result = this.getMessageKey().compareTo(st.getMessageKey());
        }
        return result;
    }
}

