/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.storage.CommandHandler;
import oracle.ops.verification.framework.storage.CommandHandlerFactory;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.sStorageUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeFinder
implements StorageConstants {
    private static CommandHandler s_commandHandler = CommandHandlerFactory.createCommandHandler();

    public StorageInfo getStorageInstance(String path) throws StorageException {
        String localNode = sStorageUtil.getLocalHost();
        return this.getStorageInstance(path, localNode);
    }

    public StorageInfo getStorageInstance(String path, String node) throws StorageException {
        String[] nodeArray = new String[]{node};
        List<StorageInfo> stList = this.getStorageInstance(path, nodeArray);
        return stList.get(0);
    }

    public List<StorageInfo> getStorageInstance(String path, String[] nodeArray) throws StorageException {
        Vector<StorageInfo> stList = new Vector<StorageInfo>();
        ClusterwareInfo cwInfo = new ClusterwareInfo();
        if (nodeArray.length == 0) {
            Trace.out((String)"storage type for localnode");
            stList.add(this.getStorageInstance(path));
            return stList;
        }
        ArrayList<Command> cmdList = new ArrayList<Command>(Arrays.asList(new Command[0]));
        boolean i = false;
        for (String node : nodeArray) {
            Trace.out((String)("exe_path: " + VerificationUtil.getCRSHome() + File.separator + "bin" + "\n path to check: " + path));
            try {
                if (cwInfo.isOFSDriversConfigured(VerificationUtil.getCRSHome() + File.separator + "bin", node) && cwInfo.isPathOnACFS(VerificationUtil.getCRSHome(), path, node)) {
                    Trace.out((String)("On ACFS: '" + path + "'"));
                    int access = -1;
                    StorageInfo storageInfo = new StorageInfo(path, node, null, 14);
                    stList.add(storageInfo);
                    continue;
                }
                Trace.out((String)("NOT on ACFS: '" + path + "'"));
                VerificationCommand typeCmd = s_commandHandler.genTypeCmd(node, path);
                cmdList.add((Command)typeCmd);
            }
            catch (InstallException ie) {
                Trace.out((String)("INSTALLEXCEPTION: for path: '" + path + "'"));
                VerificationCommand verificationCommand = s_commandHandler.genTypeCmd(node, path);
                cmdList.add((Command)verificationCommand);
            }
        }
        Command[] cmdArray = cmdList.toArray(new Command[cmdList.size()]);
        Trace.out((String)("stList.size(): " + stList.size() + " cmdList.size(): " + cmdList.size() + " nodeArray.length: " + nodeArray.length));
        if (cmdList.size() > 0) {
            boolean cmdSucc = false;
            try {
                Trace.out((String)"about to get storage type");
                cmdSucc = new ClusterCmd().submit(cmdArray);
            }
            catch (ClusterException e) {
                Trace.out((String)(">>ClusterException[Thread:" + Thread.currentThread().getName() + "]: " + (Object)((Object)e)));
                Trace.stackTrace((Throwable)e);
            }
            if (!cmdSucc) {
                Trace.out((String)"ClusterCmd.submit failed ");
                throw new StorageException("7009");
            }
            for (Command command : cmdArray) {
                Trace.out((String)("getting storage type for node" + command.getNode()));
                stList.add(s_commandHandler.parseTypeResult((VerificationCommand)command, path));
            }
        }
        Trace.out((String)("There are " + stList.size() + " storage instances in list"));
        return stList;
    }
}

