/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.USMDevInfoException;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

public class USMDevInfo {
    private String m_name;
    private String m_owner;
    private String m_group;
    private String m_perms;
    private String TAG_USMDEVICE = "USMDEVICE";
    private String TAG_USMNAME = "USMDEV_NAME";
    private String TAG_USMOWNER = "USMDEV_OWNER";
    private String TAG_USMGROUP = "USMDEV_GROUP";
    private String TAG_USMPERMS = "USMDEV_PERMS";
    static final String LSEP = System.getProperty("line.separator");

    public boolean parse(String usmdevOutput) throws USMDevInfoException {
        String[] usmdevFields;
        String[] usmTags = new String[]{this.TAG_USMNAME, this.TAG_USMOWNER, this.TAG_USMGROUP, this.TAG_USMPERMS};
        Trace.out((int)2, (String)"Entry");
        try {
            usmdevFields = GenericUtil.getFieldsByTags(usmdevOutput, usmTags);
        }
        catch (ParsingException e) {
            Trace.out((int)5, (String)("ParsingException " + e));
            throw new USMDevInfoException(e);
        }
        if (usmdevFields.length <= 3) {
            Trace.out((int)5, (String)("Error parsing device output :" + usmdevOutput));
            return false;
        }
        Trace.out((int)5, (String)("Parsing successful for dev output string:" + usmdevOutput + LSEP + "Name=" + usmdevFields[0] + "Owner=" + usmdevFields[1] + ";Group=" + usmdevFields[2] + ";Permissions=" + usmdevFields[3]));
        this.m_name = usmdevFields[0];
        this.m_owner = usmdevFields[1];
        this.m_group = usmdevFields[2];
        this.m_perms = usmdevFields[3];
        return true;
    }

    public boolean match(String inpath) {
        String matchstr;
        if (inpath.equals(this.m_name)) {
            return true;
        }
        String pattn = this.m_name.replaceAll("\\*", "\\\\w");
        Pattern pattern = Pattern.compile(pattn);
        Matcher matcher = pattern.matcher(matchstr = inpath.replaceFirst("/dev/", ""));
        if (matcher.find()) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("\nMATCH FOUND inpath: '" + inpath + "' Match path: '" + matchstr + "' Pattern: '" + pattn + "'"));
            }
            return true;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nChecked inpath: '" + inpath + "' Match path: '" + matchstr + "' Pattern: '" + pattn + "'"));
        }
        return false;
    }

    public String getName() {
        return this.m_name;
    }

    public String getOwner() {
        return this.m_owner;
    }

    public String getGroup() {
        return this.m_group;
    }

    public String getPerms() {
        return this.m_perms;
    }
}

