/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.OracleFileType;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.util.RemoteExecCommand;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.storage.ACFSInfo;
import oracle.ops.verification.framework.storage.CommandHandler;
import oracle.ops.verification.framework.storage.CommandHandlerFactory;
import oracle.ops.verification.framework.storage.FSInfo;
import oracle.ops.verification.framework.storage.LowCFSVersionException;
import oracle.ops.verification.framework.storage.NodeStorageInfo;
import oracle.ops.verification.framework.storage.NonSharedFileSystemException;
import oracle.ops.verification.framework.storage.NotFileSystemException;
import oracle.ops.verification.framework.storage.SharedStrategy;
import oracle.ops.verification.framework.storage.SharedVerifyStrategy;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.TypeFinder;
import oracle.ops.verification.framework.storage.sStorageUtil;
import oracle.ops.verification.framework.storage.sStrategyProvider;
import oracle.ops.verification.util.MultiNodeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifyStorage
implements StorageConstants {
    private static CommandHandler s_commandHandler = CommandHandlerFactory.createCommandHandler();
    private static final String s_ExecutableNotFoundException = "oracle.ops.verification.util.ExecutableNotFoundException";
    private static final String s_AccessDeniedException = "oracle.ops.verification.util.AccessDeniedException";
    Vector m_exceptionList = new Vector();

    public boolean isShared(String path, String[] nodeList, OracleFileType fileType) throws StorageException, MultiNodeException {
        Vector<StorageInfo> stList = new Vector<StorageInfo>();
        return this.isShared(path, nodeList, stList, fileType);
    }

    public boolean isShared(String path, String[] nodeList, Vector<StorageInfo> stList, OracleFileType fileType) throws StorageException, MultiNodeException {
        boolean isShared = false;
        Object localNode = null;
        List<StorageInfo> stInfoList = null;
        StorageInfo stInfo = null;
        SharedVerifyStrategy strategy = null;
        try {
            stInfoList = new TypeFinder().getStorageInstance(path, nodeList);
            stInfo = stInfoList.get(0);
            stInfoList.remove(0);
            if (stInfoList.size() > 0 && !stInfo.isSharable(stInfoList)) {
                Trace.out((String)"storage path on nodes not shared");
                return false;
            }
            Trace.out((String)("_st_:after calling TypeFindergetStorageInstance" + stInfo));
            strategy = sStrategyProvider.getSharedVerifyStrategy(stInfo.getType());
            strategy.setOracleFileType(fileType);
            Trace.out((String)"_st_:about to call strategy.isShared");
            isShared = strategy.isShared(stInfo, nodeList, stList);
        }
        catch (MultiNodeException mne) {
            throw mne;
        }
        catch (NonSharedFileSystemException nsfs) {
            Trace.out((Exception)nsfs);
            isShared = false;
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e2) {
            throw new StorageException(e2);
        }
        return isShared;
    }

    public void findSharedStorage(NodeStorageInfo[] nodeInfoList, Vector allSets) throws StorageException {
        this.findSharedStorage(nodeInfoList, allSets, OracleFileType.RAC_DATA_FILES);
    }

    public void findSharedStorage(NodeStorageInfo[] nodeInfoList, Vector allSets, OracleFileType fileType) throws StorageException {
        if (null == allSets) {
            Trace.out((String)"_st_:allsets is null!!");
            throw new StorageException();
        }
        if (null == nodeInfoList) {
            Trace.out((String)"_st_:nodeInfoList is null!!");
            throw new StorageException();
        }
        try {
            int numNodes = nodeInfoList.length;
            Trace.out((String)"_st_:>>About to call getStorageInfo");
            this.getStorageInfo(nodeInfoList, fileType);
            Trace.out((String)"_st_:>>findSharedSets.");
            this.findSharedSets(nodeInfoList, allSets, fileType);
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e2) {
            throw new StorageException(e2);
        }
    }

    void getStorageInfo(NodeStorageInfo[] nodeInfoList, OracleFileType fileType) throws StorageException {
        boolean getACFSStorage = false;
        int[] typeList = sStorageUtil.getDiscoveryTypes(fileType);
        int numValidTypes = typeList.length;
        int numNodes = nodeInfoList.length;
        Trace.out((int)5, (String)("Number of valid types: " + numValidTypes));
        for (int typeVal : typeList) {
            if (typeVal != 14) continue;
            Trace.out((int)5, (String)"Removeing TYPE_ACFS from numValidTypes");
            --numValidTypes;
            break;
        }
        RemoteExecCommand[] cmdArray = new RemoteExecCommand[numValidTypes * numNodes];
        int cmdNum = 0;
        for (int type : typeList) {
            if (type == 14) {
                getACFSStorage = true;
                continue;
            }
            for (int j = 0; j < nodeInfoList.length; ++j) {
                cmdArray[cmdNum] = s_commandHandler.genInfoCmd(nodeInfoList[j].getName(), type);
                ++cmdNum;
            }
        }
        boolean cmdSucc = false;
        try {
            cmdSucc = new ClusterCmd().submit((Command[])cmdArray);
        }
        catch (ClusterException e) {
            Trace.out((String)("_st_:>>ClusterException[Thread:" + Thread.currentThread().getName() + "]: " + (Object)((Object)e)));
        }
        if (!cmdSucc) {
            Trace.out((String)"_st_:ClusterCmd.submit failed ");
        }
        Vector stVector = null;
        Vector<String> failedNodeList = null;
        cmdNum = 0;
        for (int type : typeList) {
            if (type == 14) continue;
            for (int j = 0; j < nodeInfoList.length; ++j) {
                try {
                    RemoteExecCommand remCmd = cmdArray[cmdNum];
                    ++cmdNum;
                    if (!remCmd.getStatus()) {
                        Trace.out((String)("_st_:Failed getting Information from " + sStorageUtil.getTypeStr(type) + " on node: " + remCmd.getNode()));
                        String[] resLines = remCmd.getCommandResult().getResultString();
                        if (null != resLines) {
                            for (int line = 0; line < resLines.length; ++line) {
                                Trace.out((String)("_st_: result: " + resLines[line]));
                            }
                        }
                        String errStr = remCmd.getCommandResult().getErrorString();
                        Trace.out((String)("_st_: error: " + errStr));
                        if (null == failedNodeList) {
                            failedNodeList = new Vector<String>();
                        }
                        failedNodeList.add(remCmd.getNode());
                        continue;
                    }
                    Trace.out((int)5, (String)("Parsing command: " + cmdNum));
                    stVector = s_commandHandler.parseInfoResult(remCmd, type);
                    if (null != stVector) {
                        nodeInfoList[j].addStorage(stVector, type);
                        continue;
                    }
                    Trace.out((String)(nodeInfoList[j].getName() + " has no " + sStorageUtil.getTypeStr(type)));
                    continue;
                }
                catch (LowCFSVersionException e) {
                    Trace.out((String)e.getMessage());
                    nodeInfoList[j].getResult().addErrorInfo(e);
                    nodeInfoList[j].getResult().addTraceInfo(e);
                    continue;
                }
                catch (StorageException e) {
                    String className;
                    Trace.out((String)e.getMessage());
                    Throwable cause = e.getCause();
                    if (null != cause && (s_ExecutableNotFoundException.equals(className = cause.getClass().getName()) || s_AccessDeniedException.equals(className))) {
                        nodeInfoList[j].getResult().addErrorInfo(e);
                    }
                    nodeInfoList[j].getResult().addTraceInfo(e);
                }
            }
        }
        if (getACFSStorage) {
            Trace.out((int)5, (String)"Collecting ACFS information...");
            for (int k = 0; k < nodeInfoList.length; ++k) {
                stVector = this.getACFSStorage(nodeInfoList[k].getName());
                if (null != stVector) {
                    nodeInfoList[k].addStorage(stVector, 14);
                    continue;
                }
                Trace.out((String)(nodeInfoList[k].getName() + " has no " + sStorageUtil.getTypeStr(14)));
            }
        }
    }

    void findSharedSets(NodeStorageInfo[] nodeInfoList, Vector allSets, OracleFileType fileType) {
        boolean numSharedSets = false;
        int[] typeList = sStorageUtil.getDiscoveryTypes();
        SharedStrategy sharedStrategy = null;
        for (int i = 0; i < typeList.length; ++i) {
            int type = typeList[i];
            Vector stList = new Vector();
            for (int j = 0; j < nodeInfoList.length; ++j) {
                Vector tempList = nodeInfoList[j].getStorageByType(type);
                if (null == tempList) continue;
                stList.addAll(tempList);
            }
            if (stList.size() <= 0) continue;
            try {
                sharedStrategy = sStrategyProvider.getSharedStrategy(type);
            }
            catch (StorageException e) {
                Trace.stackTrace((Throwable)e);
                continue;
            }
            Vector superSet = new Vector();
            try {
                sharedStrategy.setOracleFileType(fileType);
                sharedStrategy.findShared(stList, superSet);
            }
            catch (StorageException e2) {
                Trace.stackTrace((Throwable)e2);
                continue;
            }
            catch (MultiNodeException mne) {
                for (i = 0; i < nodeInfoList.length; ++i) {
                    Collection ts = mne.getThrowables(nodeInfoList[i].getName());
                    if (null == ts) continue;
                    nodeInfoList[i].getResult().addErrorInfo(ts);
                }
            }
            allSets.addAll(superSet);
        }
    }

    public boolean isOCFS(String node, String path) throws StorageException {
        boolean isOCFS;
        try {
            int fsType = this.getFileSystem(node, path);
            isOCFS = fsType == 3;
        }
        catch (NotFileSystemException nfse) {
            isOCFS = false;
        }
        return isOCFS;
    }

    public boolean isACFS(String node, String path) throws StorageException {
        boolean isACFS = false;
        try {
            int fsType = this.getFileSystem(node, path);
            isACFS = fsType == 14;
        }
        catch (NotFileSystemException nfse) {
            isACFS = false;
        }
        return isACFS;
    }

    public Vector getACFSStorage(String node) {
        Vector<ACFSInfo> acfsInfoLst = new Vector<ACFSInfo>();
        String diskGrpName = null;
        long size = 0L;
        long free = 0L;
        ACFSInfo acfsInfo = null;
        FSInfo fsInfo = null;
        ClusterwareInfo cwInfo = new ClusterwareInfo();
        try {
            if (!cwInfo.isOFSDriversInstalled()) {
                Trace.out((int)5, (String)"ACFS not installed");
                return null;
            }
            List acfsMntPnts = cwInfo.getOFSMountPointsforNode(node);
            for (String location : acfsMntPnts) {
                Trace.out((int)5, (String)("ACFS mount point: '" + location + "'"));
                String actVer = cwInfo.getOFSActiveVersionforNode(node);
                diskGrpName = cwInfo.getOFSDiskGroupNameforNode(location, node);
                size = cwInfo.getOFSTotalSizeforNode(location, node);
                free = cwInfo.getOFSFreeSpaceforNode(location, node);
                fsInfo = new FSInfo(node, location);
                acfsInfo = new ACFSInfo(node, location, actVer, free, size, diskGrpName, fsInfo);
                acfsInfoLst.add(acfsInfo);
            }
        }
        catch (InstallException ie) {
            Trace.out((String)("INSTALLEXCEPTION:\n" + (Object)((Object)ie)));
            return null;
        }
        Trace.out((int)5, (String)"EXIT");
        return acfsInfoLst;
    }

    int getFileSystem(String node, String path) throws StorageException {
        VerificationCommand[] cmdArray = new VerificationCommand[1];
        boolean cmdSucc = false;
        int fsType = 5;
        cmdArray[0] = s_commandHandler.genFSTypeCmd(node, path);
        try {
            cmdSucc = new ClusterCmd().submit((Command[])cmdArray);
        }
        catch (ClusterException e) {
            cmdSucc = false;
            Trace.out((String)"ClusterException in getFileSystem.");
            Trace.out((Exception)((Object)e));
        }
        if (!cmdSucc) {
            Trace.out((String)"_st_:ClusterCmd.submit failed for getFSType");
            throw new StorageException();
        }
        if (!cmdArray[0].getStatus()) {
            Trace.out((String)"getFsTypeCommand wasn't successfull.");
            throw new StorageException();
        }
        fsType = s_commandHandler.parseFSTypeResult(cmdArray[0], path);
        Trace.out((String)("FileSystem type of " + node + ":" + path + " is: " + fsType));
        return fsType;
    }
}

