/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.Iterator;
import java.util.Vector;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.command.util.RemoteExecCommand;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.storage.CommandHandler;
import oracle.ops.verification.framework.storage.FSInfo;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.sDisk;
import oracle.ops.verification.framework.storage.sFSPartition;
import oracle.ops.verification.framework.storage.sPartition;
import oracle.ops.verification.framework.storage.sRawPartition;
import oracle.ops.verification.framework.storage.sStorageUtil;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

class sCommandHandler
extends CommandHandler {
    sCommandHandler() {
    }

    StorageInfo parseTypeResult(VerificationCommand cmd, String path) throws StorageException {
        StorageInfo stInfo = null;
        if (0 != cmd.getVfyCode()) {
            throw new StorageException("7009");
        }
        String storageStr = cmd.getOutput();
        if (storageStr == null) {
            Trace.out((String)"output is null");
            throw new StorageException("7009");
        }
        try {
            String typeStr = GenericUtil.getValueByKey(storageStr, "STTYPE");
            int type = sStorageUtil.getTypeByStr(typeStr);
            switch (type) {
                case 1: {
                    stInfo = this.parseTypeResultDisk(cmd, path);
                    break;
                }
                case 13: {
                    stInfo = new StorageInfo(path, cmd.getNode(), path, type, path, 0);
                    break;
                }
                default: {
                    Trace.out((String)("Unsupported storage type " + sStorageUtil.getTypeStr(type)));
                    throw new StorageException();
                }
            }
            Trace.out((String)("_st_:type is --> " + stInfo));
            return stInfo;
        }
        catch (Exception e) {
            Trace.out((String)"_st_:parsing gettype failed.");
            throw new StorageException("7009", e);
        }
    }

    StorageInfo parseTypeResultDisk(VerificationCommand cmd, String path) throws StorageException {
        sDisk disk = null;
        String output = cmd.getOutput().toUpperCase();
        if (null == output) {
            throw new StorageException("7009");
        }
        try {
            int diskNum = -1;
            String signature = null;
            diskNum = GenericUtil.getIntValueByKey(output, "DISKNUMBER");
            signature = GenericUtil.getValueByKey(output, "DRIVESIGNATURE");
            disk = new sDisk(String.valueOf(diskNum), cmd.getNode(), signature);
            Trace.out((String)("_storage_ typeResult disk" + disk));
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
        return disk;
    }

    public RemoteExecCommand genInfoCmd(String node, int type) throws StorageException {
        switch (type) {
            case 1: {
                return this.genDiskDiscoveryCmd(node);
            }
        }
        Trace.out((String)("_st_:genInfoCmd: Can't handle " + sStorageUtil.getTypeStr(type)));
        throw new StorageException();
    }

    public Vector parseInfoResult(RemoteExecCommand remCmd, int type) throws StorageException {
        Vector retVector = new Vector();
        switch (type) {
            case 1: {
                this.parseDiskDiscoveryCmd(remCmd, retVector);
                break;
            }
            default: {
                Trace.out((String)("_st_:parseInfoResult: Can't handle " + sStorageUtil.getTypeStr(type)));
                throw new StorageException();
            }
        }
        return retVector;
    }

    RemoteExecCommand genDiskDiscoveryCmd(String node) {
        String[] args = new String[]{"-getstinfo", "DISK"};
        return new VerificationCommand(node, args, null);
    }

    void parseDiskDiscoveryCmd(RemoteExecCommand cmd, Vector diskList) throws StorageException {
        int numDisks = 0;
        int realNumDisks = 0;
        String output = null;
        String node = cmd.getNode();
        boolean diskIndex = false;
        sDisk disk = null;
        Vector diskStrList = null;
        String diskStr2 = null;
        Iterator diskStrIter = null;
        output = ((VerificationCommand)cmd).getOutput().toUpperCase();
        try {
            numDisks = GenericUtil.getIntValueByKey(output, "NUMDISKS");
            diskStrList = GenericUtil.getAllStrByTags(output, "DISKBEGIN", "DISKEND");
            for (String diskStr2 : diskStrList) {
                disk = this.parseDisk(diskStr2, node);
                diskList.add(disk);
                ++realNumDisks;
                Trace.out((String)("_storage_ added disk" + disk));
            }
        }
        catch (ParsingException pe) {
            throw new StorageException("7002", pe);
        }
        catch (Exception e) {
            throw new StorageException("7002", e);
        }
        if (realNumDisks != numDisks) {
            Trace.out((String)("_storage_: <<<Problem getting diskInfo>>> \nnumDisks: " + numDisks + " | numRealDisks:" + realNumDisks + "\n output: \n" + output));
            throw new StorageException("7002");
        }
    }

    protected sDisk parseDisk(String fmtdStr, String node) throws StorageException {
        sDisk disk = null;
        int diskNum = -1;
        String signature = null;
        int numParts = -1;
        long diskSize = -1L;
        Vector partStrList = null;
        Iterator partStrIter = null;
        sPartition part = null;
        try {
            diskNum = GenericUtil.getIntValueByKey(fmtdStr, "DISKNUMBER");
            signature = GenericUtil.getValueByKey(fmtdStr, "DRIVESIGNATURE");
            numParts = GenericUtil.getIntValueByKey(fmtdStr, "NUMPARTS");
            diskSize = GenericUtil.getIntValueByKey(fmtdStr, "DISKSIZE");
            partStrList = GenericUtil.getAllStrByTags(fmtdStr, "VOLUMEBEGIN", "VOLUMEEND");
        }
        catch (ParsingException pe) {
            throw new StorageException("7002", pe);
        }
        catch (Exception e) {
            throw new StorageException("7002", e);
        }
        disk = new sDisk(String.valueOf(diskNum), node, signature);
        disk.setSize(new StorageSize(diskSize, StorageUnit.MBYTE));
        disk.setFree(new StorageSize(diskSize, StorageUnit.MBYTE));
        partStrIter = partStrList.iterator();
        while (partStrIter.hasNext()) {
            part = this.parsePart((String)partStrIter.next(), disk);
            disk.addPartition(part);
            Trace.out((String)("added part " + part));
        }
        return disk;
    }

    protected sPartition parsePart(String fmtdStr, sDisk disk) throws StorageException {
        String partNum = null;
        String vlr = null;
        String fileSystem = null;
        sPartition part = null;
        try {
            partNum = GenericUtil.getValueByKey(fmtdStr, "PARTITIONNUMBER");
            fileSystem = GenericUtil.getValueByKey(fmtdStr, "FILESYSTEM");
            vlr = GenericUtil.getValueByKey(fmtdStr, "VLR");
            if (null == vlr) {
                Trace.out((String)("WARNING: vlr is null. PartNum: " + partNum + "|FS: " + fileSystem));
                vlr = "\\Device\\Harddisk" + disk.getDevName() + "\\Partition" + partNum;
            }
            part = "RAW".equalsIgnoreCase(fileSystem) ? new sRawPartition(disk, partNum, vlr) : new sFSPartition(disk, partNum, fileSystem, vlr);
        }
        catch (ParsingException pe) {
            throw new StorageException("7002", pe);
        }
        catch (Exception e) {
            throw new StorageException("7002", e);
        }
        return part;
    }

    public RemoteExecCommand genInfoCmd(String node, int type, String path) throws StorageException {
        switch (type) {
            case 1: {
                return this.getDiskBySignatureCmd(node, path);
            }
        }
        Trace.out((String)("_st_:Don't know how to handle storage type " + sStorageUtil.getTypeStr(type)));
        throw new StorageException();
    }

    public RemoteExecCommand genInfoCmd(String node, int type, String path, String realpath, Result result) throws StorageException {
        switch (type) {
            case 1: 
            case 14: {
                return this.getFSInfoCmd(node, path, result);
            }
        }
        Trace.out((String)("_st_:Don't know how to handle storage type " + sStorageUtil.getTypeStr(type)));
        throw new StorageException();
    }

    public StorageInfo parseInfoResult(RemoteExecCommand remCmd, int type, String path) throws StorageException {
        VerificationCommand vfyCmd = (VerificationCommand)remCmd;
        String output = vfyCmd.getOutput();
        switch (type) {
            case 1: 
            case 14: {
                if (output == null) break;
                if (output.indexOf("fsname") != -1) {
                    Trace.out((String)"Parsing fs output");
                    return this.parseFSInfo(remCmd, remCmd.getNode(), path);
                }
                Trace.out((String)"parsing disk signature");
                return this.parseDiskBySignatureCmd(remCmd.getNode(), remCmd);
            }
        }
        Trace.out((String)("_st_:parseInfoResult: Can't handle " + sStorageUtil.getTypeStr(type)));
        throw new StorageException();
    }

    VerificationCommand getDiskBySignatureCmd(String node, String signature) {
        String[] args = new String[]{"-getStInfo", "GET_DISK_BY_SIGNATURE", signature};
        return new VerificationCommand(node, args, null);
    }

    VerificationCommand getDiskBySignatureCmd(String node, String signature, Result result) {
        String[] args = new String[]{"-getStInfo", "GET_DISK_BY_SIGNATURE", signature};
        return new VerificationCommand(node, args, null);
    }

    VerificationCommand getFSInfoCmd(String node, String path, Result result) {
        String[] args = new String[]{"-getStInfo", "-getFSInfo", path};
        return new VerificationCommand(node, args, null, result);
    }

    sDisk parseDiskBySignatureCmd(String node, RemoteExecCommand remCmd) throws StorageException {
        String output = null;
        sDisk disk = null;
        int vfyCode = 0;
        VerificationCommand vfyCmd = (VerificationCommand)remCmd;
        vfyCode = vfyCmd.getVfyCode();
        if (10011 == vfyCode) {
            return null;
        }
        if (0 != vfyCode) {
            throw new StorageException("7002");
        }
        try {
            output = vfyCmd.getOutput();
            disk = this.parseDisk(output, node);
        }
        catch (Exception e) {
            throw new StorageException("7002", e);
        }
        return disk;
    }

    private FSInfo parseFSInfo(RemoteExecCommand cmd, String node, String path) throws StorageException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("parseFSInfo: Node=" + node + " , Path=" + path));
        }
        Vector retSet = new Vector();
        FSInfo fsInfo = null;
        int vfyCode = 0;
        String output = null;
        VerificationCommand vfyCmd = (VerificationCommand)cmd;
        vfyCode = vfyCmd.getVfyCode();
        if (0 == vfyCode) {
            output = vfyCmd.getOutput();
        }
        fsInfo = this.parseFSInfoInternal(output, node);
        return fsInfo;
    }

    private FSInfo parseFSInfoInternal(String output, String node) throws StorageException {
        FSInfo fsInfo = null;
        String fsname = null;
        int fstype = 0;
        long fsbsize = 1L;
        long fsblocks = 0L;
        long fsbfree = 0L;
        long fsbavail = 0L;
        long fsfiles = 1L;
        long fsfree = 0L;
        int fsaccess = 1;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Prasing FSInfo string: " + output));
        }
        try {
            fsname = GenericUtil.getMidStrNoCase(output, "fsname");
            fsbfree = Long.parseLong(GenericUtil.getMidStrNoCase(output, "fsbfree"));
            fsblocks = fsbavail = Long.parseLong(GenericUtil.getMidStrNoCase(output, "fsbavail"));
        }
        catch (ParsingException pe) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Problem parsing the string " + output));
                Trace.out((Exception)pe);
            }
            throw new StorageException();
        }
        catch (NumberFormatException nfe) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Problem converting string to long in output: " + output));
                Trace.out((Exception)nfe);
            }
            throw new StorageException();
        }
        fsInfo = new FSInfo(node, fsname, fstype, fsbsize, fsblocks, fsbfree, fsbavail, fsfiles, fsfree, fsaccess);
        return fsInfo;
    }
}

