/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.StorageSize;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.sPartition;

class sDisk
extends StorageInfo
implements StorageConstants {
    private String m_devName;
    private String m_signature;
    private Vector m_partitionList;
    private Hashtable m_partitionTable = new Hashtable();

    sDisk(String devName, String node, String signature) {
        super(devName, node, 1);
        this.m_partitionList = new Vector();
        this.m_devName = devName;
        this.m_signature = signature;
    }

    public String getSignature() {
        return this.m_signature;
    }

    public String getDevName() {
        return this.m_devName;
    }

    public String getName() {
        return "\\Device\\Harddisk" + this.m_devName;
    }

    protected void addPartition(sPartition part) throws StorageException {
        String partNum = part.getPartitionNumber();
        if (null != this.m_partitionTable.get(partNum)) {
            Trace.out((String)("Already added PartNum " + partNum + " to " + this));
            throw new StorageException();
        }
        this.m_partitionTable.put(partNum, part);
        this.m_partitionList.add(part);
    }

    protected Vector getPartitionList() {
        return (Vector)this.m_partitionList.clone();
    }

    protected sPartition getPartition(String partNum) {
        return (sPartition)this.m_partitionTable.get(partNum);
    }

    public String getOwner() {
        Trace.out((String)"Operation getOwner is Unsupported.");
        return new String("UNSUPPORTED");
    }

    public String getGroup() {
        Trace.out((String)"Operation getGroup is Unsupported.");
        return new String("UNSUPPORTED");
    }

    public String getPermissions() {
        Trace.out((String)"Operation getOPermissions is Unsupported.");
        return new String("UNSUPPORTED");
    }

    public int getNumPartitions() {
        return this.m_partitionList.size();
    }

    public String toString() {
        return this.m_node + ":" + this.m_devName;
    }

    public StorageSize getFree() {
        return this.m_size;
    }
}

