/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.Iterator;
import java.util.Vector;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.SharedStorageSet;
import oracle.ops.verification.framework.storage.SharedStrategy;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageFilter;
import oracle.ops.verification.framework.storage.sDisk;
import oracle.ops.verification.framework.storage.sPartition;
import oracle.ops.verification.util.MultiNodeException;

public class sDiskSharedStrategy
extends SharedStrategy
implements StorageConstants {
    public void findShared(Vector stList, Vector superSet) throws StorageException, MultiNodeException {
        Vector diskSuperSet = new Vector();
        Vector partSuperSet = null;
        SharedStorageSet diskSet2 = null;
        super.findShared(stList, diskSuperSet);
        for (SharedStorageSet diskSet2 : diskSuperSet) {
            Vector diskList = diskSet2.getSharedSet();
            sDisk disk = (sDisk)diskList.elementAt(0);
            if (0 == disk.getPartitionList().size()) {
                superSet.add(diskSet2);
                continue;
            }
            partSuperSet = new Vector();
            this.findSharedPartitions(diskSet2, partSuperSet);
            superSet.addAll(partSuperSet);
        }
        Trace.out((String)("SharedSets of parts found:" + superSet.size()));
    }

    private void findSharedPartitions(SharedStorageSet diskSet, Vector superSet) throws StorageException {
        Iterator partIter = null;
        Iterator diskIter = null;
        sPartition part2 = null;
        sPartition matchPart = null;
        Vector diskList = diskSet.getSharedSet();
        sDisk disk = (sDisk)diskList.elementAt(0);
        SharedStorageSet partSet = null;
        StorageFilter filter = new StorageFilter();
        Vector<sPartition> sharedParts = new Vector<sPartition>();
        Vector partListClone = disk.getPartitionList();
        Trace.out((String)("looking for sharedParts of disk " + disk));
        partIter = partListClone.iterator();
        while (partIter.hasNext()) {
            part2 = (sPartition)partIter.next();
            if (!part2.isRaw()) continue;
            sharedParts.add(part2);
            partIter.remove();
        }
        String[] fsList = new String[]{"OraCFS"};
        Vector CFSParts = filter.filterByFileSystem(partListClone, fsList);
        sharedParts.addAll(CFSParts);
        for (sPartition part2 : sharedParts) {
            String partNum = part2.getPartitionNumber();
            partSet = new SharedStorageSet(6);
            diskIter = diskList.iterator();
            Trace.out((String)("Looking for partitions with partNum: " + partNum));
            while (diskIter.hasNext()) {
                disk = (sDisk)diskIter.next();
                matchPart = disk.getPartition(partNum);
                Trace.out((String)("matchpart is " + matchPart));
                if (null == matchPart) continue;
                partSet.add(matchPart);
            }
            superSet.add(partSet);
        }
    }
}

