/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.net.UnknownHostException;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.StorageType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.sDisk;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sStorageUtil
implements StorageConstants {
    private static String m_localHost = null;
    private static final int[] m_ValidDiscoveryTypes = new int[]{1, 14};
    private static final int[] m_ShareCheckTypes = new int[]{1, 14};

    public boolean isTypeValid(int type) {
        return type > 0;
    }

    public static int[] getDiscoveryTypes() {
        return sStorageUtil.getDiscoveryTypes(OracleFileType.RAC_DATA_FILES);
    }

    public static int[] getDiscoveryTypes(OracleFileType fileType) {
        return m_ValidDiscoveryTypes;
    }

    public static String getTypeStr(int type) {
        switch (type) {
            case 1: {
                return "Disk";
            }
            case 2: {
                return "NFS";
            }
            case 5: {
                return "File System";
            }
            case 3: {
                return "Vx Disk Group";
            }
            case 4: {
                return "Vx Volume";
            }
            case 6: {
                return "Disk Partition";
            }
            case 14: {
                return "ACFS";
            }
        }
        return "Unknown";
    }

    public static StorageType getTypeEnum(int type) {
        switch (type) {
            case 1: {
                return StorageType.DISK;
            }
            case 2: {
                return StorageType.NFS;
            }
            case 5: {
                return StorageType.FILESYSTEM;
            }
            case 3: {
                return StorageType.VXDG;
            }
            case 4: {
                return StorageType.VXVOLUME;
            }
            case 6: {
                return StorageType.DISK_PARTITION;
            }
            case 14: {
                return StorageType.ACFS;
            }
        }
        return StorageType.UNKNOWN;
    }

    public static int getTypeByStr(String str) throws StorageException {
        int type = -1;
        if (str.equals("FS")) {
            type = 5;
        } else if (str.equals("DISK")) {
            type = 1;
        } else if (str.equals("VXVOLUME")) {
            type = 4;
        } else if (str.equals("ASM")) {
            type = 13;
        } else if (str.equals("ACFS")) {
            type = 14;
        } else {
            Trace.out((String)("_st_:String " + str + " is not a recognized type."));
            throw new StorageException();
        }
        return type;
    }

    protected static String getLocalHost() throws StorageException {
        if (null == m_localHost) {
            try {
                m_localHost = VerificationUtil.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new StorageException("7007", e);
            }
        }
        return m_localHost;
    }

    public static int getNumDiskPartitions(StorageInfo stInfo) {
        if (stInfo.getType() == 1) {
            return ((sDisk)stInfo).getNumPartitions();
        }
        return -1;
    }
}

