/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.ACFSSharedStrategy;
import oracle.ops.verification.framework.storage.FSSharedVerifyStrategy;
import oracle.ops.verification.framework.storage.SharedStrategy;
import oracle.ops.verification.framework.storage.SharedVerifyStrategy;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.sDiskSharedStrategy;
import oracle.ops.verification.framework.storage.sDiskSharedVerifyStrategy;
import oracle.ops.verification.framework.storage.sStorageUtil;

class sStrategyProvider
implements StorageConstants {
    sStrategyProvider() {
    }

    static SharedStrategy getSharedStrategy(int type) throws StorageException {
        switch (type) {
            case 1: {
                return new sDiskSharedStrategy();
            }
            case 14: {
                return new ACFSSharedStrategy();
            }
        }
        Trace.out((String)("genInfoCmd: Can't handle " + sStorageUtil.getTypeStr(type)));
        throw new StorageException();
    }

    static SharedVerifyStrategy getSharedVerifyStrategy(int type) throws StorageException {
        switch (type) {
            case 1: {
                return new sDiskSharedVerifyStrategy();
            }
            case 14: {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)"FSSharedVerifyStrategy chosen for TYPE_ACFS.");
                }
                return new FSSharedVerifyStrategy();
            }
        }
        Trace.out((String)("genInfoCmd: Can't handle " + sStorageUtil.getTypeStr(type)));
        throw new StorageException();
    }
}

