/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.util.RemoteExecCommand;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.sStorageUtil;
import oracle.ops.verification.util.GenericUtil;

class sVXDGInfo
extends StorageInfo
implements StorageConstants {
    private static final String VXDG_LOC = "/usr/sbin/";
    private String m_dgid = null;

    sVXDGInfo(String dgname, String node, String dgid) {
        super(dgname, node, 3);
        this.m_dgid = dgid;
    }

    public void getDetails(Vector stList) {
    }

    public String getSignature() {
        return this.m_dgid;
    }

    public static sVXDGInfo getDGByVolume(StorageInfo stInfo) throws StorageException {
        String cmdStr = "/usr/sbin/vxprint -lv " + stInfo.getName() + " | egrep -i '(Disk.group)|(path=)' ";
        String[] args = new String[]{""};
        String localHost = sStorageUtil.getLocalHost();
        RemoteExecCommand cmd = new RemoteExecCommand(cmdStr, args, null, localHost, null, null, null);
        boolean cmdSucc = false;
        Command[] cmdArray = new Command[]{cmd};
        Trace.out((String)"_st_:about to get enclosing dg");
        try {
            cmdSucc = new ClusterCmd().submit(cmdArray);
        }
        catch (ClusterException e) {
            Trace.out((String)(">>ClusterException[Thread:" + Thread.currentThread().getName() + "]: " + (Object)((Object)e)));
            throw new StorageException("7001", e);
        }
        if (!cmdSucc) {
            Trace.out((String)"ClusterCmd.submit failed ");
            throw new StorageException("7001");
        }
        sVXDGInfo foundDg = sVXDGInfo.parseGetDGByVolume(cmd, stInfo);
        if (foundDg == null) {
            Trace.out((String)("_st_: No DiskGroups found for " + stInfo.getName()));
            throw new StorageException("7008");
        }
        return foundDg;
    }

    private static sVXDGInfo parseGetDGByVolume(RemoteExecCommand cmd, StorageInfo stInfo) throws StorageException {
        int numDGs = 0;
        String dgName = null;
        String path = null;
        String givenPath = stInfo.getPath();
        String node = cmd.getNode();
        String[] lines = cmd.getCommandResult().getResultString();
        sVXDGInfo foundDg = null;
        try {
            givenPath = givenPath.replaceFirst("rdsk", "dsk");
        }
        catch (PatternSyntaxException e1) {
            Trace.stackTrace((Throwable)e1);
            Trace.out((String)"_st_: path not in /dev/vx/dsk/<diskgroup>/<volume> format");
        }
        if (0 != lines.length % 2) {
            Trace.out((String)"_st_: numLines not even");
            for (int lNum = 0; lNum < lines.length; ++lNum) {
                Trace.out((String)("_st_:line[" + lNum + "]= " + lines[lNum]));
            }
            throw new StorageException();
        }
        for (int lNum = 0; lNum < lines.length; ++lNum) {
            dgName = GenericUtil.getNextStrNoCase(lines[lNum], "Disk group:", null);
            ++numDGs;
            path = GenericUtil.getNextStrNoCase(lines[++lNum], "path=", null);
            try {
                path = path.replaceFirst("rdsk", "dsk");
            }
            catch (PatternSyntaxException e2) {
                Trace.stackTrace((Throwable)e2);
            }
            Trace.out((String)("_st_ testing:" + path + "|" + dgName + "|" + givenPath));
            if (!givenPath.equals(path)) continue;
            foundDg = new sVXDGInfo(dgName, stInfo.getNode(), null);
        }
        if (1 == numDGs) {
            foundDg = new sVXDGInfo(dgName, stInfo.getNode(), null);
        }
        return foundDg;
    }

    public static Vector getSharedOnLocal() throws StorageException {
        String cmdStr = "/usr/sbin/vxdg -sq list";
        String[] args = new String[]{""};
        String localNode = sStorageUtil.getLocalHost();
        RemoteExecCommand cmd = new RemoteExecCommand("/usr/sbin/vxdg -sq list", args, null, localNode, null, null, null);
        boolean cmdSucc = false;
        Command[] cmdArray = new Command[]{cmd};
        Trace.out((String)"_st_:about to get the list of shared dgs");
        try {
            cmdSucc = new ClusterCmd().submit(cmdArray);
        }
        catch (ClusterException e) {
            Trace.out((String)(">>ClusterException[Thread:" + Thread.currentThread().getName() + "]: " + (Object)((Object)e)));
            throw new StorageException("7001", e);
        }
        if (!cmdSucc) {
            Trace.out((String)"ClusterCmd.submit failed ");
            throw new StorageException("7001");
        }
        return sVXDGInfo.parseVXDGList(cmd);
    }

    private static Vector parseVXDGList(RemoteExecCommand cmd) throws StorageException {
        Vector<sVXDGInfo> retVector = new Vector<sVXDGInfo>();
        boolean isEnabled = false;
        boolean isShared = false;
        String currLine = null;
        String[] resultLines = cmd.getCommandResult().getResultString();
        String name = null;
        String state = null;
        String dgid = null;
        sVXDGInfo dgInfo = null;
        try {
            for (int i = 0; i < resultLines.length; ++i) {
                currLine = resultLines[i];
                StringTokenizer stLine = new StringTokenizer(currLine);
                name = stLine.nextToken();
                state = stLine.nextToken().toLowerCase();
                dgid = stLine.nextToken();
                isEnabled = -1 != state.indexOf("enabled");
                boolean bl = isShared = -1 != state.indexOf("shared");
                if (!isShared) {
                    Trace.out((String)("_st_: VXDG -s list gave unshared dg! " + currLine));
                }
                if (!isShared || !isEnabled) continue;
                dgInfo = new sVXDGInfo(name, cmd.getNode(), dgid);
                Trace.out((String)("_st_:added " + dgInfo));
                retVector.add(dgInfo);
            }
        }
        catch (Exception e) {
            Trace.out((String)("The last line caused an exception: " + currLine));
            throw new StorageException("7001", e);
        }
        Trace.out((String)("_st_: Num shared local dgs found " + retVector.size()));
        Enumeration stEnum = retVector.elements();
        int i = 0;
        while (stEnum.hasMoreElements()) {
            Trace.out((String)("in retVector" + stEnum.nextElement()));
            ++i;
        }
        return retVector;
    }

    public String toString() {
        return this.getNode() + ":" + this.getName() + ":" + this.m_dgid;
    }
}

