/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.asm.ASM;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.ASMFactory;
import oracle.cluster.asm.DiskGroup;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.storage.ASMDiskGroup;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.VerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMDiskGroupsUtil {
    private String[] m_nodeList;
    private String m_kfodLocation = null;
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");

    public ASMDiskGroupsUtil(String[] nodeList) {
        this.m_nodeList = nodeList;
    }

    public void setKfodLocation(String location) {
        this.m_kfodLocation = location;
    }

    public String getKfodLocation() {
        return this.m_kfodLocation;
    }

    public boolean isASMRunning(String nodename) throws ASMDiskGroupsUtilException {
        Trace.out((int)2, (String)"Entry");
        boolean isrun = false;
        try {
            ASMFactory asmfact = ASMFactory.getInstance();
            ASM asm = asmfact.getASM();
            Node node = ServerFactory.getInstance().getNode(nodename);
            isrun = asm.isRunning(node);
        }
        catch (SoftwareModuleException e) {
            throw new ASMDiskGroupsUtilException(e.getMessage());
        }
        catch (NotExistsException e) {
            throw new ASMDiskGroupsUtilException(e.getMessage());
        }
        catch (ServerException e) {
            throw new ASMDiskGroupsUtilException(e.getMessage());
        }
        catch (NodeException e) {
            throw new ASMDiskGroupsUtilException(e.getMessage());
        }
        Trace.out((int)2, (String)"Exit");
        return isrun;
    }

    public List<DiskGroup> getDiskGroups() throws ASMDiskGroupsUtilException {
        Trace.out((int)2, (String)"Entry");
        List ldg = null;
        try {
            ASMFactory asmfact = ASMFactory.getInstance();
            ldg = asmfact.getDiskGroups();
        }
        catch (ASMException e) {
            Trace.out((String)("ASMException occurred when attempting to query list of diskgroups" + (Object)((Object)e)));
            throw new ASMDiskGroupsUtilException(e.getMessage());
        }
        catch (NotExistsException e) {
            Trace.out((String)("NotExistsException returned when attempting to query list of diskgroups" + (Object)((Object)e)));
            throw new ASMDiskGroupsUtilException(e.getMessage());
        }
        catch (Exception e) {
            Trace.out((String)("General exception occurred when attempting to query list of diskgroups" + e));
            throw new ASMDiskGroupsUtilException(e.getMessage());
        }
        Trace.out((int)2, (String)"Exit");
        return ldg;
    }

    public boolean getDiskGroups(String[] nodeList, ResultSet dgResultSet, Hashtable<String, List<ASMDiskGroup>> htdg) throws ASMDiskGroupsUtilException {
        Trace.out((int)2, (String)"Entry");
        int nodeCount = nodeList.length;
        VerificationCommand[] getDGListCmdArray = new VerificationCommand[nodeCount];
        dgResultSet = new ResultSet();
        Trace.out((String)"DiskGroup query using kfod...");
        if (this.m_kfodLocation == null) {
            String clusterwareHome = null;
            ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
            try {
                clusterwareHome = clusterwareInfo.isCRSConfigured() ? VerificationUtil.getCRSHome() : VerificationUtil.getHAHome();
            }
            catch (InstallException e) {
                throw new ASMDiskGroupsUtilException(e.getMessage());
            }
            this.m_kfodLocation = clusterwareHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "kfod";
        }
        for (int j = 0; j < nodeCount; ++j) {
            String[] arg = new String[]{"-runexe", this.m_kfodLocation, "op=GROUPS", "nohdr=true"};
            String[] env = null;
            getDGListCmdArray[j] = new VerificationCommand(nodeList[j], arg, env);
        }
        new GlobalHandler().submit((Command[])getDGListCmdArray, 0, dgResultSet);
        if (!dgResultSet.anySuccess()) {
            String message = s_msgBundle.getMessage("5131", true);
            ErrorDescription errorDesc = new ErrorDescription(message);
            dgResultSet.addErrorDescription(this.m_nodeList, errorDesc);
            return false;
        }
        for (int nodeIndex = 0; nodeIndex < nodeCount; ++nodeIndex) {
            VerificationCommand getDGListCmd = getDGListCmdArray[nodeIndex];
            Result result = getDGListCmd.getResult();
            if (result.getStatus() != 1) continue;
            String node = getDGListCmd.getNode();
            String output = getDGListCmd.getOutput();
            Trace.out((String)("kfod output on node " + node + "= >" + output + "<"));
            ArrayList<ASMDiskGroup> dgl = new ArrayList<ASMDiskGroup>();
            boolean isOK = this.parseDGListOutput(output, dgl);
            Trace.out((String)("Result of parseDGListOutput(): " + isOK));
            if (isOK) {
                htdg.put(node, dgl);
                continue;
            }
            dgResultSet.addResult(node, 3);
            ErrorDescription error = new ErrorDescription(s_msgBundle.getMessage("5155", true, (Object[])new String[]{node}));
            dgResultSet.addErrorDescription(node, error);
        }
        Trace.out((int)2, (String)"Exit");
        return true;
    }

    private boolean parseDGListOutput(String output, List<ASMDiskGroup> dgl) {
        Trace.out((int)2, (String)"Entry");
        String[] dgout = output.split("\\n");
        if (dgout.length < 1) {
            Trace.out((String)"Output DG List is empty");
            return false;
        }
        for (int i = 0; i < dgout.length; ++i) {
            Trace.out((String)("DGList: dg[" + i + "]=" + dgout[i]));
            ASMDiskGroup dg = new ASMDiskGroup();
            if (!dg.parseInput(dgout[i])) continue;
            dgl.add(dg);
        }
        Trace.out((int)2, (String)"Exit");
        return true;
    }
}

