/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.cluster.verification.StorageSize;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.util.ComparableComparator;
import oracle.ops.verification.framework.util.InvalidRangeManipulationException;
import oracle.ops.verification.framework.util.RangeOperator;
import oracle.ops.verification.framework.util.RangePredicate;
import oracle.ops.verification.framework.util.RangeType;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.framework.util.VersionComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeOfValue {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    List<RangePredicate> m_includeList = new ArrayList<RangePredicate>();
    List<RangePredicate> m_excludeList = new ArrayList<RangePredicate>();
    private Comparator<Object> m_comparator = null;
    private RangeType m_rangeType = null;

    public RangeOfValue(RangeType rt) {
        this.m_rangeType = rt;
        this.m_comparator = RangeType.VERSION.equals((Object)rt) ? new VersionComparator("-") : ComparableComparator.getInstance();
    }

    public RangeOfValue(RangeType rt, Comparator<Object> comparator) {
        this.m_rangeType = rt;
        this.m_comparator = comparator;
    }

    public void include(RangeOperator operator, Object value) throws InvalidRangeManipulationException {
        RangePredicate rangePredicate = new RangePredicate(this.m_rangeType, operator, this.getTypeSafeObject(value), this.m_comparator);
        this.m_includeList.add(rangePredicate);
    }

    public void include(RangeOperator firstOperator, Object firstValue, RangeOperator secondOperator, Object secondValue) throws InvalidRangeManipulationException {
        RangePredicate rangePredicate = new RangePredicate(this.m_rangeType, firstOperator, this.getTypeSafeObject(firstValue), secondOperator, this.getTypeSafeObject(secondValue), this.m_comparator);
        this.m_includeList.add(rangePredicate);
    }

    public void exclude(RangeOperator operator, Object value) throws InvalidRangeManipulationException {
        RangePredicate rangePredicate = new RangePredicate(this.m_rangeType, operator, this.getTypeSafeObject(value), this.m_comparator);
        this.m_excludeList.add(rangePredicate);
    }

    public void exclude(RangeOperator firstOperator, Object firstValue, RangeOperator secondOperator, Object secondValue) throws InvalidRangeManipulationException {
        RangePredicate rangePredicate = new RangePredicate(this.m_rangeType, firstOperator, this.getTypeSafeObject(firstValue), secondOperator, this.getTypeSafeObject(secondValue), this.m_comparator);
        this.m_excludeList.add(rangePredicate);
    }

    public boolean contains(Object value) throws InvalidRangeManipulationException {
        if (value == null) {
            return false;
        }
        Object obj = this.getTypeSafeObject(value);
        return this.isInTheRange(obj, this.m_includeList) && !this.isInTheRange(obj, this.m_excludeList);
    }

    public boolean contains(RangeOfValue range) throws InvalidRangeManipulationException {
        if (range == null) {
            return false;
        }
        if (this.m_rangeType != range.m_rangeType) {
            return false;
        }
        RangePredicate thisLowerBound = this.getLowestBoundRangePredicate();
        RangePredicate thisUpperBound = this.getHighestBoundRangePredicate();
        RangePredicate otherLoweBound = range.getLowestBoundRangePredicate();
        RangePredicate otherUpperBound = range.getHighestBoundRangePredicate();
        if (thisLowerBound == null || thisUpperBound == null || otherLoweBound == null || otherUpperBound == null) {
            return false;
        }
        return thisLowerBound.compareLowerBounds(otherLoweBound) >= 0 && thisUpperBound.compareUpperBounds(otherUpperBound) >= 0;
    }

    public boolean equals(RangeOfValue range) throws InvalidRangeManipulationException {
        if (range == null) {
            return false;
        }
        if (this.m_rangeType != range.m_rangeType) {
            return false;
        }
        RangePredicate thisLowerBound = this.getLowestBoundRangePredicate();
        RangePredicate thisUpperBound = this.getHighestBoundRangePredicate();
        RangePredicate otherLowerBound = range.getLowestBoundRangePredicate();
        RangePredicate otherUpperBound = range.getHighestBoundRangePredicate();
        boolean lowerBoundCompares = false;
        boolean upperBoundCompares = false;
        if (thisLowerBound == null && otherLowerBound == null) {
            lowerBoundCompares = true;
        } else if (thisLowerBound == null || otherLowerBound == null) {
            lowerBoundCompares = false;
        } else {
            boolean bl = lowerBoundCompares = thisLowerBound.compareLowerBounds(otherLowerBound) == 0;
        }
        upperBoundCompares = thisUpperBound == null && otherUpperBound == null ? true : (thisUpperBound == null || otherUpperBound == null ? false : thisUpperBound.compareUpperBounds(otherUpperBound) == 0);
        return lowerBoundCompares && upperBoundCompares;
    }

    public RangePredicate getLowestBoundRangePredicate() {
        if (this.m_includeList.size() < 1) {
            return null;
        }
        RangePredicate lbrp = null;
        boolean first = true;
        for (RangePredicate rp : this.m_includeList) {
            if (first) {
                lbrp = rp;
                first = false;
                continue;
            }
            if (lbrp.compareLowerBounds(rp) >= 0) continue;
            lbrp = rp;
        }
        return lbrp;
    }

    public RangePredicate getHighestBoundRangePredicate() {
        if (this.m_includeList.size() < 1) {
            return null;
        }
        RangePredicate hbrp = null;
        boolean first = true;
        for (RangePredicate rp : this.m_includeList) {
            if (first) {
                hbrp = rp;
                first = false;
                continue;
            }
            if (hbrp.compareUpperBounds(rp) >= 0) continue;
            hbrp = rp;
        }
        return hbrp;
    }

    private boolean isInTheRange(Object value, List<RangePredicate> predicateList) {
        RangePredicate rangePredicate;
        boolean included = false;
        Iterator<RangePredicate> i$ = predicateList.iterator();
        while (i$.hasNext() && !(included = (rangePredicate = i$.next()).contains(value))) {
        }
        return included;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getTypeSafeObject(Object value) throws InvalidRangeManipulationException {
        Object returnVal = value;
        if (this.m_rangeType.equals((Object)RangeType.INTEGER)) {
            if (value instanceof String || value instanceof Integer || value instanceof Byte || value instanceof Short) {
                try {
                    return Long.parseLong(value.toString());
                }
                catch (NumberFormatException e) {
                    Object[] msgParams = new String[]{value.toString(), this.m_rangeType.toString()};
                    String msg = s_msgBundle.getMessage("9036", false, msgParams);
                    if (!Trace.isLevelEnabled((int)1)) throw new InvalidRangeManipulationException(msg);
                    Trace.out((String)msg);
                    throw new InvalidRangeManipulationException(msg);
                }
            }
            Object[] msgParams = new String[]{value.toString(), this.m_rangeType.toString()};
            String msg = s_msgBundle.getMessage("9036", false, msgParams);
            if (!Trace.isLevelEnabled((int)1)) throw new InvalidRangeManipulationException(msg);
            Trace.out((String)msg);
            throw new InvalidRangeManipulationException(msg);
        }
        if (this.m_rangeType.equals((Object)RangeType.FLOAT)) {
            if (value instanceof String || value instanceof Number) {
                try {
                    return Double.parseDouble(value.toString());
                }
                catch (NumberFormatException e) {
                    Object[] msgParams = new String[]{value.toString(), this.m_rangeType.toString()};
                    String msg = s_msgBundle.getMessage("9036", false, msgParams);
                    if (!Trace.isLevelEnabled((int)1)) throw new InvalidRangeManipulationException(msg);
                    Trace.out((String)msg);
                    throw new InvalidRangeManipulationException(msg);
                }
            }
            Object[] msgParams = new String[]{value.toString(), this.m_rangeType.toString()};
            String msg = s_msgBundle.getMessage("9036", false, msgParams);
            if (!Trace.isLevelEnabled((int)1)) throw new InvalidRangeManipulationException(msg);
            Trace.out((String)msg);
            throw new InvalidRangeManipulationException(msg);
        }
        if (this.m_rangeType.equals((Object)RangeType.STRING)) {
            if (value instanceof String) return returnVal;
            return value.toString();
        }
        if (!this.m_rangeType.equals((Object)RangeType.STORAGE_SIZE)) return returnVal;
        if (value instanceof StorageSize) return returnVal;
        Object[] msgParams = new String[]{value.toString(), this.m_rangeType.toString()};
        String msg = s_msgBundle.getMessage("9036", false, msgParams);
        if (!Trace.isLevelEnabled((int)1)) throw new InvalidRangeManipulationException(msg);
        Trace.out((String)msg);
        throw new InvalidRangeManipulationException(msg);
    }

    public String getBoundedRangeString() {
        return this.getMinValue() + " " + this.getMaxValue();
    }

    public String getMinValue() {
        RangePredicate rp = this.getLowestBoundRangePredicate();
        return rp.getMinValue();
    }

    public String getMaxValue() {
        RangePredicate rp = this.getHighestBoundRangePredicate();
        return rp.getMaxValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (RangePredicate rangePredicate : this.m_includeList) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(rangePredicate);
            first = false;
        }
        for (RangePredicate rangePredicate : this.m_excludeList) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("not ");
            sb.append(rangePredicate);
            first = false;
        }
        return sb.toString();
    }
}

