/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.util.Comparator;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.util.InvalidRangeManipulationException;
import oracle.ops.verification.framework.util.RangeOperator;
import oracle.ops.verification.framework.util.RangeType;
import oracle.ops.verification.framework.util.VerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangePredicate {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private RangeOperator m_firstOp = null;
    private Object m_firstValue = null;
    private RangeOperator m_secondOp = null;
    private Object m_secondValue = null;
    private Comparator<Object> m_comparator = null;
    private RangeType m_rangeType = null;

    public RangePredicate(RangeType rt, RangeOperator firstOp, Object firstValue, RangeOperator secondOp, Object secondValue, Comparator<Object> comparator) throws InvalidRangeManipulationException {
        if (firstOp == null || secondOp == null) {
            String msg = s_msgBundle.getMessage("9037", false);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)msg);
            }
            throw new InvalidRangeManipulationException(msg);
        }
        if (firstOp == RangeOperator.EQ || secondOp == RangeOperator.EQ) {
            Object[] msgParams = new String[]{firstOp.toString(), secondOp.toString()};
            String msg = s_msgBundle.getMessage("9038", false, msgParams);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)msg);
            }
            throw new InvalidRangeManipulationException(msg);
        }
        if (!(firstOp != RangeOperator.LE && firstOp != RangeOperator.LT || secondOp != RangeOperator.LE && secondOp != RangeOperator.LT)) {
            Object[] msgParams = new String[]{firstOp.toString(), secondOp.toString()};
            String msg = s_msgBundle.getMessage("9038", false, msgParams);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)msg);
            }
            throw new InvalidRangeManipulationException(msg);
        }
        if (!(firstOp != RangeOperator.GE && firstOp != RangeOperator.GT || secondOp != RangeOperator.GE && secondOp != RangeOperator.GT)) {
            Object[] msgParams = new String[]{firstOp.toString(), secondOp.toString()};
            String msg = s_msgBundle.getMessage("9038", false, msgParams);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)msg);
            }
            throw new InvalidRangeManipulationException(msg);
        }
        this.m_rangeType = rt;
        this.m_comparator = comparator;
        if (firstOp == RangeOperator.LE || firstOp == RangeOperator.LT) {
            this.m_secondOp = firstOp;
            this.m_secondValue = firstValue;
            this.m_firstOp = secondOp;
            this.m_firstValue = secondValue;
        } else {
            this.m_firstOp = firstOp;
            this.m_firstValue = firstValue;
            this.m_secondOp = secondOp;
            this.m_secondValue = secondValue;
        }
        if (this.m_comparator.compare(this.m_firstValue, this.m_secondValue) > 0) {
            Object[] msgParams = new String[]{this.m_firstValue.toString(), this.m_firstOp.toString(), this.m_secondValue.toString(), this.m_secondOp.toString()};
            String msg = s_msgBundle.getMessage("9039", false, msgParams);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)msg);
            }
            throw new InvalidRangeManipulationException(msg);
        }
    }

    public RangePredicate(RangeType rt, RangeOperator operator, Object value, Comparator<Object> comparator) throws InvalidRangeManipulationException {
        if (operator == null) {
            String msg = s_msgBundle.getMessage("9037", false);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)msg);
            }
            throw new InvalidRangeManipulationException(msg);
        }
        this.m_rangeType = rt;
        this.m_firstOp = operator;
        this.m_firstValue = value;
        this.m_comparator = comparator;
    }

    public boolean contains(Object value) {
        if (value == null) {
            return false;
        }
        boolean contained = false;
        if (this.m_firstOp == RangeOperator.EQ) {
            return this.m_comparator.compare(value, this.m_firstValue) == 0;
        }
        if (this.m_firstOp == RangeOperator.GE) {
            contained = this.m_comparator.compare(value, this.m_firstValue) >= 0;
        } else if (this.m_firstOp == RangeOperator.GT) {
            contained = this.m_comparator.compare(value, this.m_firstValue) > 0;
        } else if (this.m_firstOp == RangeOperator.LE) {
            contained = this.m_comparator.compare(value, this.m_firstValue) <= 0;
        } else if (this.m_firstOp == RangeOperator.LT) {
            boolean bl = contained = this.m_comparator.compare(value, this.m_firstValue) < 0;
        }
        if (!contained || this.m_secondOp == null) {
            return contained;
        }
        if (this.m_secondOp == RangeOperator.LE) {
            contained = this.m_comparator.compare(value, this.m_secondValue) <= 0;
        } else if (this.m_secondOp == RangeOperator.LT) {
            contained = this.m_comparator.compare(value, this.m_secondValue) < 0;
        }
        return contained;
    }

    int compareLowerBounds(RangePredicate rp) {
        if ((this.m_firstOp.equals((Object)RangeOperator.EQ) || this.m_firstOp.equals((Object)RangeOperator.GE)) && (rp.m_firstOp.equals((Object)RangeOperator.EQ) || rp.m_firstOp.equals((Object)RangeOperator.GE))) {
            return this.m_comparator.compare(this.m_firstValue, rp.m_firstValue) * -1;
        }
        if (this.m_firstOp.equals((Object)RangeOperator.EQ) || this.m_firstOp.equals((Object)RangeOperator.GE)) {
            if (rp.m_firstOp.equals((Object)RangeOperator.LE) || rp.m_firstOp.equals((Object)RangeOperator.LT)) {
                return -1;
            }
            if (rp.m_firstOp.equals((Object)RangeOperator.GT)) {
                if (this.m_rangeType.equals((Object)RangeType.INTEGER)) {
                    Long val = Long.parseLong(rp.m_firstValue.toString()) + 1L;
                    return this.m_comparator.compare(this.m_firstValue, val) * -1;
                }
                int comparisonResult = this.m_comparator.compare(this.m_firstValue, rp.m_firstValue);
                if (comparisonResult <= 0) {
                    return 1;
                }
                return -1;
            }
        }
        if (this.m_firstOp.equals((Object)RangeOperator.GT)) {
            if (rp.m_firstOp.equals((Object)RangeOperator.EQ) || rp.m_firstOp.equals((Object)RangeOperator.GE)) {
                if (this.m_rangeType.equals((Object)RangeType.INTEGER)) {
                    Long val = Long.parseLong(this.m_firstValue.toString()) + 1L;
                    return this.m_comparator.compare(val, rp.m_firstValue) * -1;
                }
                int comparisonResult = this.m_comparator.compare(this.m_firstValue, rp.m_firstValue);
                if (comparisonResult < 0) {
                    return 1;
                }
                return -1;
            }
            if (rp.m_firstOp.equals((Object)RangeOperator.LE) || rp.m_firstOp.equals((Object)RangeOperator.LT)) {
                return -1;
            }
            if (rp.m_firstOp.equals((Object)RangeOperator.GT)) {
                return this.m_comparator.compare(this.m_firstValue, rp.m_firstValue) * -1;
            }
        }
        if (this.m_firstOp.equals((Object)RangeOperator.LE) || this.m_firstOp.equals((Object)RangeOperator.LT)) {
            if (rp.m_firstOp.equals((Object)RangeOperator.LE) || rp.m_firstOp.equals((Object)RangeOperator.LT)) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    int compareUpperBounds(RangePredicate rp) {
        if (this.m_firstOp.equals((Object)RangeOperator.EQ) && rp.m_firstOp.equals((Object)RangeOperator.EQ)) {
            return this.m_comparator.compare(this.m_firstValue, rp.m_firstValue);
        }
        if (this.m_secondOp != null && rp.m_secondOp != null) {
            return this.compareUpperBounds(this.m_secondOp, this.m_secondValue, rp.m_secondOp, rp.m_secondValue);
        }
        if (this.m_secondOp == null && rp.m_secondOp == null) {
            return this.compareUpperBounds(this.m_firstOp, this.m_firstValue, rp.m_firstOp, rp.m_firstValue);
        }
        if (this.m_secondOp != null) {
            return this.compareUpperBounds(this.m_secondOp, this.m_secondValue, rp.m_firstOp, rp.m_firstValue);
        }
        return this.compareUpperBounds(this.m_firstOp, this.m_firstValue, rp.m_secondOp, rp.m_secondValue);
    }

    private int compareUpperBounds(RangeOperator op1, Object val1, RangeOperator op2, Object val2) {
        if (op1.equals((Object)RangeOperator.EQ) || op1.equals((Object)RangeOperator.LE)) {
            if (op2.equals((Object)RangeOperator.EQ) || op2.equals((Object)RangeOperator.LE)) {
                return this.m_comparator.compare(val1, val2);
            }
            if (op2.equals((Object)RangeOperator.GE) || op2.equals((Object)RangeOperator.GT)) {
                return -1;
            }
            if (op2.equals((Object)RangeOperator.LT)) {
                if (this.m_rangeType.equals((Object)RangeType.INTEGER)) {
                    Long val = Long.parseLong(val2.toString()) - 1L;
                    return this.m_comparator.compare(val1, val);
                }
                int comparisonResult = this.m_comparator.compare(val1, val2);
                if (comparisonResult >= 0) {
                    return 1;
                }
                return -1;
            }
        }
        if (op1.equals((Object)RangeOperator.GE) || op1.equals((Object)RangeOperator.GT)) {
            if (op2.equals((Object)RangeOperator.GE) || op2.equals((Object)RangeOperator.GT)) {
                return 0;
            }
            return 1;
        }
        if (op1.equals((Object)RangeOperator.LT)) {
            if (op2.equals((Object)RangeOperator.LT)) {
                return this.m_comparator.compare(val1, val2);
            }
            if (op2.equals((Object)RangeOperator.GE) || op2.equals((Object)RangeOperator.GT)) {
                return -1;
            }
            if (op2.equals((Object)RangeOperator.EQ) || op2.equals((Object)RangeOperator.LE)) {
                if (this.m_rangeType.equals((Object)RangeType.INTEGER)) {
                    Long val = Long.parseLong(val1.toString()) - 1L;
                    return this.m_comparator.compare(val, val2);
                }
                int comparisonResult = this.m_comparator.compare(val1, val2);
                if (comparisonResult > 0) {
                    return 1;
                }
                return -1;
            }
        }
        return -1;
    }

    public String getMinValue() {
        return this.m_firstValue.toString();
    }

    public String getMaxValue() {
        return this.m_secondValue != null ? this.m_secondValue.toString() : this.m_firstValue.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.m_secondOp != null) {
            sb.append("between " + this.m_firstValue + " & " + this.m_secondValue);
        } else {
            if (this.m_firstOp != RangeOperator.EQ) {
                sb.append(this.m_firstOp.toString().toLowerCase() + " ");
            }
            sb.append(this.m_firstValue);
        }
        return sb.toString();
    }
}

