/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.impl.verification.FixupGeneratorResultImpl;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.FixupGeneratorResult;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.NoFixupGeneratorResultException;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.cluster.verification.constraints.XmlTaskFactory;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.NoSuchCRSHomeException;
import oracle.ops.mgmt.cluster.NoSuchExecutableException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.VerifyNetwork;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.ConfigUtil;
import oracle.ops.verification.framework.util.HAHomeNotFoundException;
import oracle.ops.verification.framework.util.InvalidEnvironmentException;
import oracle.ops.verification.framework.util.InvalidOUIInventoryDataException;
import oracle.ops.verification.framework.util.InventoryFilePointerException;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.OUIData;
import oracle.ops.verification.framework.util.VersionComparator;
import oracle.ops.verification.framework.util.sVerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerificationUtil
implements VerificationConstants {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static long KILO_BYTE = 1024L;
    private static long MEGA_BYTE = 0x100000L;
    private static long GIGA_BYTE = 0x40000000L;
    private static long TERA_BYTE = 0x10000000000L;
    private static String TRACE_CLUVFY_FNAME = "cvutrace.log";
    private static String TRACE_CVUHELPER_FNAME = "cvuhelper.log";
    private static int CLUVFY = 1;
    private static int CVUHELPER = 2;
    private static String CV = "cv";
    private static String LOG = "log";
    private static boolean m_isLocalNodeOperationChecked = false;
    private static boolean m_isLocal = false;
    public static final String NODE_ALL = "CV_NODE_ALL";
    public static final String ASSUME_DISTID = "CV_ASSUME_DISTID";
    public static final String ORA_INST_INVPTR_PROPERTY = "oracle.installer.invPtrLoc";
    private static final String CTSS_CHECK_COMMAND = "crsctl check ctss";
    private static final String CTSS_RES_QUERY_COMMAND = "crsctl stat resource ora.ctssd -init";
    public static final String FIXUP_RESPONSE = "fixup.response";
    public static final String FIXUP_ENABLE = "fixup.enable";
    private static final String VDISK_DEFAULT_PERMISSIONS = "0640";
    private static final String ASM_PATH_CHARACTER = "+";
    private static final String CV_CRS_PREREQ_XML = "crsinst_prereq.xml";
    private static final String CV_DB_PREREQ_XML = "dbinst_prereq.xml";
    private static final String CV_HA_PREREQ_XML = "sihainst_prereq.xml";
    public static final String HA_HOME_REQ = "HA";
    public static final String CRS_HOME_REQ = "CRS";
    public static final String HA_OR_CRS_HOME_REQ = "BOTH";
    protected static String s_cvhome;
    protected static String s_destloc;
    protected static String m_fixupRootDir;
    protected static boolean m_defaultFixupReqd;
    protected static boolean m_fixupGenerated;
    protected static String m_settledFixupRootDir;
    protected static String s_traceloc;
    protected static String s_RDBMSVersion;
    protected static String s_currentGroup;
    protected static boolean m_isLocalNodeOper;
    protected static String s_HAHome;
    protected static Map<String, String> s_variableValueRepos;
    protected static Map<String, Boolean> s_conditionValueRepos;
    protected static Map<VerificationType, String> s_preReqXmlRepos;
    protected static String s_genericPreReqXmlFile;

    public static String[] getNodelist() throws NodelistNotFoundException {
        ParamManager pm = null;
        try {
            pm = ParamManager.getInstance();
        }
        catch (UninitializedParamManagerException e) {
            throw new NodelistNotFoundException(e.getMessage());
        }
        Argument nodelistArg = pm.getArgument(Argument.ARG_NODELIST);
        String[] nodelist = nodelistArg == null ? null : (nodelistArg.isAllSpecified() ? VerificationUtil.getStaticNodelist() : pm.getMultiPartArgVal(Argument.ARG_NODELIST));
        if (nodelist != null) {
            Trace.out((String)"====VerificationUtil gets the nodelist from ParamManager as: ");
            for (int i = 0; i < nodelist.length; ++i) {
                Trace.out((String)("  ==Node " + i + " is:" + nodelist[i]));
            }
        } else {
            Trace.out((String)"Nodelist was null. Trying to get the localhost");
            try {
                nodelist = new String[]{VerificationUtil.getLocalHost()};
            }
            catch (UnknownHostException e) {
                Trace.out((String)("Could not retrieve localhost name. " + e.getMessage()));
                throw new NodelistNotFoundException(e.getMessage());
            }
        }
        for (int p = 0; p < nodelist.length; ++p) {
            Trace.out((String)("==== Nodelist before processing: nodelist[" + p + "]:" + nodelist[p]));
        }
        HashSet<String> hset = new HashSet<String>(nodelist.length);
        if (nodelist != null) {
            for (int k = 0; k < nodelist.length; ++k) {
                nodelist[k] = VerificationUtil.getShortHostname(nodelist[k]);
                hset.add(nodelist[k]);
            }
            nodelist = hset.toArray(new String[hset.size()]);
        }
        for (int p = 0; p < nodelist.length; ++p) {
            Trace.out((String)("==== Nodelist after: nodelist[" + p + "]:" + nodelist[p]));
        }
        return nodelist;
    }

    public static String getShortHostname(String longHostname) {
        if (longHostname == null) {
            return null;
        }
        int dotIdx = longHostname.indexOf(".");
        String hostName = dotIdx != -1 ? longHostname.substring(0, dotIdx) : longHostname;
        return hostName;
    }

    public static String getLocalNodename() throws NodelistNotFoundException {
        String localNodeName = null;
        String crsHome = VerificationUtil.getCRSHome();
        try {
            ClusterInfo cluInfo = new ClusterInfo(crsHome);
            localNodeName = cluInfo.getLocalNodeName();
        }
        catch (NoSuchCRSHomeException nche) {
            Trace.out((String)("====  ALERT!! CRS_HOME is bad or missing. NoSuchCRSHomeException: '" + nche.getMessage() + "'"));
            throw new NodelistNotFoundException(s_msgBundle.getMessage("9001", false, new Object[]{new String(crsHome)}));
        }
        catch (NoSuchExecutableException nsee) {
            Trace.out((String)("==== ALERT!! olsnodes executable is missing. NoSuchExecutableException: '" + nsee.getMessage() + "'"));
            throw new NodelistNotFoundException(s_msgBundle.getMessage("9003", false));
        }
        catch (ClusterInfoException cie) {
            Trace.out((String)("==== ALERT!! CRS home available, but olsnodes  does not work. Exception: '" + cie.getMessage() + "'"));
            throw new NodelistNotFoundException(s_msgBundle.getMessage("9004", false));
        }
        return localNodeName;
    }

    public static String getLocalHost() throws UnknownHostException {
        String longHostName = InetAddress.getLocalHost().getHostName();
        int dotIdx = longHostName.indexOf(".");
        String hostName = dotIdx != -1 ? longHostName.substring(0, dotIdx) : longHostName;
        Trace.out((String)("Hostname retrieved: " + longHostName + ", returned: " + hostName));
        return hostName;
    }

    public static String getNodeName(String hostName) {
        if (hostName != null) {
            return hostName.toLowerCase();
        }
        return null;
    }

    public static String[] getStaticNodelist() throws NodelistNotFoundException {
        String crsHome = VerificationUtil.getCRSHome();
        Trace.out((String)("==== CRS home: " + crsHome));
        if (crsHome != null && crsHome.trim().length() > 0) {
            try {
                ClusterInfo cluInfo = new ClusterInfo(crsHome);
                String[] nodelist = cluInfo.getNodeNames();
                Trace.out((String)"==== Nodelist retrieved from Oracle Clusterware");
                Trace.out((String)("==== Nodelist: " + VerificationUtil.strArr2List(nodelist)));
                return nodelist;
            }
            catch (NoSuchCRSHomeException nche) {
                Trace.out((String)("====  ALERT!! CRS_HOME is bad or missing. NoSuchCRSHomeException: '" + nche.getMessage() + "'"));
                throw new NodelistNotFoundException(s_msgBundle.getMessage("9001", false, new Object[]{new String(crsHome)}));
            }
            catch (NoSuchExecutableException nsee) {
                Trace.out((String)("==== ALERT!! olsnodes executable is missing. NoSuchExecutableException: '" + nsee.getMessage() + "'"));
                throw new NodelistNotFoundException(s_msgBundle.getMessage("9003", false));
            }
            catch (ClusterInfoException cie) {
                Trace.out((String)("==== ALERT!! CRS home available, but olsnodes  does not work. Exception: '" + cie.getMessage() + "'"));
                throw new NodelistNotFoundException(s_msgBundle.getMessage("9004", false));
            }
        }
        String ndlist = VerificationUtil.getConfiguredValue(NODE_ALL, true);
        if (ndlist == null || ndlist.trim().length() <= 0) {
            throw new NodelistNotFoundException(s_msgBundle.getMessage("9005", false, new Object[]{new String(NODE_ALL)}));
        }
        String[] nodelist = VerificationUtil.getTokensAsArray(ndlist, ",");
        Trace.out((String)"==== Nodelist retrieved from CV_NODE_ALL variable.");
        Trace.out((String)("==== Nodelist: " + ndlist));
        return nodelist;
    }

    public static String[] getVendorStaticNodelist() throws NodelistNotFoundException {
        String[] nodelist = null;
        try {
            ClusterInfo pre10iCluInfo = new ClusterInfo(VerificationUtil.getCVHome(), Version.get92Version());
            nodelist = pre10iCluInfo.getNodeNames();
            Trace.out((String)"==== Nodelist retrieved from vendor clusterware");
            Trace.out((String)("==== Nodelist: " + VerificationUtil.strArr2List(nodelist)));
            return nodelist;
        }
        catch (NoSuchCRSHomeException nche) {
            Trace.out((String)("====  ALERT!! CV_HOME is bad or missing. NoSuchCRSHomeException: '" + nche.getMessage() + "'"));
            throw new NodelistNotFoundException(s_msgBundle.getMessage("9000", false, new Object[]{new String(VerificationUtil.getCVHome())}));
        }
        catch (NoSuchExecutableException nsee) {
            Trace.out((String)("==== ALERT!! lsnodes executable is missing. NoSuchExecutableException: '" + nsee.getMessage() + "'"));
            throw new NodelistNotFoundException(s_msgBundle.getMessage("9002", false));
        }
        catch (ClusterInfoException cie) {
            Trace.out((String)("==== Unable to retrieve nodelist from vendor clusterware. Exception: '" + cie.getMessage() + "'"));
            return nodelist;
        }
    }

    public static void updateResultMap(Hashtable<Object, Vector<Object>> t, Object key, Object vectElem) {
        if (t.containsKey(key)) {
            Vector<Object> oldVal = t.get(key);
            oldVal.add(vectElem);
            t.put(key, oldVal);
        } else {
            Vector<Object> newVal = new Vector<Object>();
            newVal.add(vectElem);
            t.put(key, newVal);
        }
    }

    public static String strArr2List(String[] strArr) {
        if (strArr == null) {
            return "";
        }
        return VerificationUtil.strCollection2String(Arrays.asList(strArr));
    }

    public static String strArr2List(String[] strArr, String delimiter) {
        if (strArr == null) {
            return "";
        }
        return VerificationUtil.strCollection2String(Arrays.asList(strArr), delimiter);
    }

    public static String strArr2String(String[] strarr) {
        if (strarr == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strarr.length; ++i) {
            sb.append(strarr[i]);
        }
        return sb.toString();
    }

    public static String strArr2String(String[] strarr, String delim) {
        if (strarr == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strarr.length; ++i) {
            sb.append(strarr[i]);
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String[] string2strArr(String str) {
        return VerificationUtil.string2strArr(str, ",");
    }

    public static String[] string2strArr(String str, String delim) {
        Vector<String> strVect = new Vector<String>();
        int dlmPos = 0;
        int index = 0;
        while (index < str.length()) {
            dlmPos = str.indexOf(delim, index);
            if (dlmPos == -1) {
                strVect.add(str.substring(index));
                break;
            }
            if (dlmPos == index) {
                ++index;
                continue;
            }
            strVect.add(str.substring(index, dlmPos));
            index = dlmPos + 1;
        }
        return strVect.toArray(new String[strVect.size()]);
    }

    public static String strVect2List(Vector<String> v) {
        return VerificationUtil.strCollection2String(v);
    }

    public static String strList2List(List<String> l) {
        return VerificationUtil.strCollection2String(l);
    }

    public static <T> String strCollection2String(Collection<T> l) {
        return VerificationUtil.strCollection2String(l, ",");
    }

    public static <T> String strCollection2String(Collection<T> l, String delim) {
        StringBuffer strBuf = new StringBuffer("");
        if (l != null) {
            boolean first = true;
            for (T item : l) {
                if (first) {
                    first = false;
                } else {
                    strBuf.append(delim);
                }
                strBuf.append(String.valueOf(item));
            }
        }
        return strBuf.toString();
    }

    public static Vector getTokens(String str, String dlm) {
        int dlmPos = 0;
        Vector<String> tokenList = new Vector<String>();
        int index = 0;
        while (index < str.length()) {
            dlmPos = str.indexOf(dlm, index);
            if (dlmPos == -1) {
                tokenList.add(str.substring(index));
                return tokenList;
            }
            if (dlmPos == index) {
                ++index;
                continue;
            }
            tokenList.add(str.substring(index, dlmPos));
            index = dlmPos + 1;
        }
        return tokenList;
    }

    public static String[] getTokensAsArray(String str, String dlm) {
        String[] tokarr;
        Vector vector = VerificationUtil.getTokens(str, dlm);
        if (vector != null) {
            tokarr = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                tokarr[i] = (String)vector.elementAt(i);
            }
        } else {
            tokarr = new String[]{};
        }
        return tokarr;
    }

    public static String getDefaultOracleUser() {
        String curUser = System.getProperty("user.name");
        Trace.out((String)("==== Oracle user(current user) is " + curUser));
        return curUser;
    }

    public static String getDefaultCRSUser() {
        String curUser = System.getProperty("user.name");
        Trace.out((String)("==== Oracle user(current user) is " + curUser));
        return curUser;
    }

    public static String getDefaultOperGroup() {
        return VDMUtil.getDefaultOperGroup();
    }

    public static String getDefaultDbaGroup() {
        return VDMUtil.getDefaultDbaGroup();
    }

    public static String getDefaultAsmGroup() {
        return VDMUtil.getDefaultAsmGroup();
    }

    public static String getDefaultOraInvGroup() {
        return VDMUtil.getDefaultOraInvGroup();
    }

    public static String getDefaultUmask() {
        return VDMUtil.getDefaultUmask();
    }

    public static String fetchTextByTags(String sfmtd, String start_tag, String end_tag) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, start_tag, end_tag);
    }

    public static String fetchTextByTags(String sfmtd, String entity, String start_tag, String end_tag) {
        if (null == sfmtd || sfmtd.length() == 0) {
            return null;
        }
        String fmtdstr = null == entity || entity.trim().length() == 0 ? sfmtd : sfmtd;
        int begin = fmtdstr.indexOf(start_tag);
        if (begin == -1) {
            return null;
        }
        begin += start_tag.length();
        int end = fmtdstr.indexOf(end_tag);
        if (end == -1) {
            return null;
        }
        String data = fmtdstr.substring(begin, end);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nTags " + start_tag + " and " + end_tag + " contains:" + data + "\n"));
        }
        return data;
    }

    public static boolean fetchExecResult(String sfmtd) {
        int res;
        String eres = VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_ERES>", "</CV_ERES>");
        try {
            res = Integer.parseInt(eres);
        }
        catch (NumberFormatException e) {
            Trace.out((String)("Invalid exec result in the output. " + e.getMessage()));
            return false;
        }
        return res == 0;
    }

    public static String fetchVerificationResult(String sfmtd) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_VRES>", "</CV_VRES>");
    }

    public static String fetchVerificationValue(String sfmtd) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_VAL>", "</CV_VAL>");
    }

    public static boolean fetchVerificationStatus(String sfmtd) {
        String tagValue = VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_VRES>", "</CV_VRES>");
        return tagValue.equals("0");
    }

    public static String fetchCommandValue(String sfmtd) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_CMD>", "</CV_CMD>");
    }

    public static String fetchError(String sfmtd) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_ERR>", "</CV_ERR>");
    }

    public static String fetchTrace(String sfmtd) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_TRC>", "</CV_TRC>");
    }

    public static String fetchLog(String sfmtd) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_LOG>", "</CV_LOG>");
    }

    public static String fetchProgressText(String sfmtd) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_PTXT>", "</CV_PTXT>");
    }

    public static String getSrcLoc() {
        String cvhome;
        String srcLoc = cvhome = VerificationUtil.getCVHome();
        Trace.out((String)("==== Source location is: " + srcLoc));
        return srcLoc;
    }

    public static String getCVHome() {
        if (s_cvhome != null) {
            return s_cvhome;
        }
        String prop = System.getProperty("CV_HOME");
        if (prop == null || prop.trim().length() <= 0) {
            prop = "." + FSEP;
        }
        if (!prop.endsWith(FSEP)) {
            prop = prop + FSEP;
        }
        s_cvhome = prop;
        return s_cvhome;
    }

    public static String getCurrentGroup() {
        return s_currentGroup;
    }

    public static void setCurrentGroup(String curGrp) {
        s_currentGroup = curGrp;
    }

    public static String getCVUSubDir() {
        return "CVU_" + VerificationUtil.getRDBMSVersion() + "_" + System.getProperty("user.name");
    }

    public static String getCVUSubDirPath() {
        return VerificationUtil.getDestLoc() + VerificationUtil.getCVUSubDir() + FSEP;
    }

    public static String getDefaultFixupRootDir() {
        return VerificationUtil.getCVUSubDirPath() + "fixup";
    }

    public static void setFixupRootDir(String fixupRootDir) {
        m_fixupRootDir = fixupRootDir.endsWith("/") ? fixupRootDir + "fixup" : fixupRootDir + "/fixup";
        m_settledFixupRootDir = null;
    }

    public static String getFixupRootDir() {
        if (m_fixupRootDir == null) {
            m_fixupRootDir = VerificationUtil.getDefaultFixupRootDir();
        }
        return m_fixupRootDir;
    }

    public static void markFixupRootDirAsSettled(String fixupRootDir) {
        m_settledFixupRootDir = fixupRootDir;
    }

    public static boolean isFixupRootDirSettled(String fixupRootDir) {
        return m_settledFixupRootDir != null && m_settledFixupRootDir.equals(fixupRootDir);
    }

    public static void setDefaultFixupRequirement(boolean fixupReqd) {
        m_defaultFixupReqd = fixupReqd;
    }

    public static boolean getDefaultFixupRequirement() {
        return m_defaultFixupReqd;
    }

    public static void setFixupGenerated(boolean fixupGenerated) {
        m_fixupGenerated = fixupGenerated;
    }

    public static boolean isFixupGenerated() {
        return m_fixupGenerated;
    }

    public static String getDestLoc() {
        if (s_destloc != null) {
            Trace.out((String)("==== CV_DESTLOC(pre-fetched value): '" + s_destloc + "'"));
            return s_destloc;
        }
        String prop = System.getProperty("CV_DESTLOC");
        Trace.out((String)("==== CV_DESTLOC system property set as '" + prop + "'"));
        if (prop == null || prop.trim().length() <= 0) {
            Trace.out((String)"==== Null(or empty) CV_DESTLOC property.");
        } else if (!prop.endsWith(FSEP)) {
            prop = prop + FSEP;
        }
        s_destloc = prop;
        Trace.out((String)("==== CV_DESTLOC: '" + s_destloc + "'"));
        return s_destloc;
    }

    public static void setDestLoc(String destloc) {
        s_destloc = destloc;
        if (!s_destloc.endsWith(FSEP)) {
            s_destloc = s_destloc + FSEP;
        }
    }

    public static void setCVHome(String cvhome) {
        s_cvhome = cvhome;
        if (!s_cvhome.endsWith(FSEP)) {
            s_cvhome = s_cvhome + FSEP;
        }
    }

    public static String getTraceLoc() {
        if (s_traceloc != null) {
            return s_traceloc;
        }
        String prop = System.getProperty("CV_TRACELOC");
        if (prop == null || prop.trim().length() <= 0) {
            prop = VerificationUtil.getEnv("CV_TRACELOC");
        }
        if (prop == null || prop.trim().length() <= 0) {
            return null;
        }
        if (!prop.endsWith(FSEP)) {
            prop = prop + FSEP;
        }
        s_traceloc = prop;
        return s_traceloc;
    }

    public static String getCmd4RemExec() {
        String remExec = VDMUtil.getCmd4RemExec();
        Trace.out((String)("==== Remote Exec name: " + remExec));
        return remExec;
    }

    public static String[] getCmdFiles4RemExec() {
        return VDMUtil.getCmdFiles4RemExec();
    }

    public static String getCRSHome() {
        sVerificationUtil psVerUtil = new sVerificationUtil();
        String inventoryFile = null;
        OUIData ouid = null;
        try {
            inventoryFile = psVerUtil.getInventoryFileLocation();
            ouid = OUIData.getInstance(inventoryFile);
        }
        catch (InvalidOUIInventoryDataException e) {
            Trace.out((String)"getCRSHome(): ERROR instantiating the OUIData object");
            Trace.out((String)e.getMessage());
            Trace.out((Exception)e);
            return null;
        }
        return ouid.getCRSHomeLocation();
    }

    public static boolean isHAInstalled() {
        boolean haInstalled = false;
        ClusterwareInfo clustInfo = new ClusterwareInfo();
        String ouiLoc = VerificationUtil.getCVHome() + FSEP + "oui";
        String invPtrProp = System.setProperty(ORA_INST_INVPTR_PROPERTY, sVerificationUtil.getInventoryConfigFilePointer());
        try {
            haInstalled = clustInfo.isHAInstalled(ouiLoc);
            Trace.out((String)("haInstalled=" + haInstalled));
        }
        catch (InstallException ie) {
            Trace.out((String)"Caught InstallException");
            VerificationUtil.reportException((Exception)((Object)ie));
        }
        if (invPtrProp == null) {
            System.clearProperty(ORA_INST_INVPTR_PROPERTY);
        } else {
            System.setProperty(ORA_INST_INVPTR_PROPERTY, invPtrProp);
        }
        return haInstalled;
    }

    public static boolean isHAConfigured() {
        boolean haConfigured = false;
        ClusterwareInfo clustInfo = new ClusterwareInfo();
        try {
            haConfigured = clustInfo.isHAConfigured();
            Trace.out((String)("haConfigured=" + haConfigured));
        }
        catch (InstallException ie) {
            Trace.out((String)"Caught InstallException");
            VerificationUtil.reportException((Exception)((Object)ie));
        }
        return haConfigured;
    }

    public static boolean isCRSInstalled() {
        boolean crsInstalled = false;
        ClusterwareInfo clustInfo = new ClusterwareInfo();
        String ouiLoc = VerificationUtil.getCVHome() + FSEP + "oui";
        String invPtrProp = System.setProperty(ORA_INST_INVPTR_PROPERTY, sVerificationUtil.getInventoryConfigFilePointer());
        try {
            crsInstalled = clustInfo.isCRSInstalled(ouiLoc);
            Trace.out((String)("crsInstalled=" + crsInstalled));
        }
        catch (InstallException ie) {
            Trace.out((String)"Caught InstallException");
            VerificationUtil.reportException((Exception)((Object)ie));
        }
        if (invPtrProp == null) {
            System.clearProperty(ORA_INST_INVPTR_PROPERTY);
        } else {
            System.setProperty(ORA_INST_INVPTR_PROPERTY, invPtrProp);
        }
        return crsInstalled;
    }

    public static String getHAHomeWithException() throws HAHomeNotFoundException {
        try {
            ClusterwareInfo cluInfo = new ClusterwareInfo();
            if (!cluInfo.isHAConfigured()) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"HA is not configured");
                }
                throw new HAHomeNotFoundException(s_msgBundle.getMessage("5318", true));
            }
        }
        catch (InstallException ie) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)(" Could not detemine whether HA is configured:" + ie.getMessage()));
            }
            throw new HAHomeNotFoundException(ie.getMessage());
        }
        return sVerificationUtil.getHAHomeWithException();
    }

    public static String getHAHome() {
        String haHome;
        block2: {
            haHome = null;
            try {
                haHome = VerificationUtil.getHAHomeWithException();
            }
            catch (HAHomeNotFoundException hae) {
                if (!Trace.isLevelEnabled((int)5)) break block2;
                Trace.out((String)("HA home can not be found:" + hae.getMessage()));
                Trace.out((Exception)hae);
            }
        }
        return haHome;
    }

    public static String getHAorCRSHome(String[] nodeList, String homeType, List<String> validNodes, ResultSet resultSet) {
        String exeHome = null;
        ErrorDescription errDesc = null;
        if (homeType.contentEquals(HA_HOME_REQ) || homeType.contentEquals(HA_OR_CRS_HOME_REQ)) {
            block18: {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"Attempt to get HA (OracleRestart) home");
                }
                try {
                    exeHome = VerificationUtil.getHAHomeWithException();
                }
                catch (HAHomeNotFoundException hae) {
                    if (!homeType.contentEquals(HA_HOME_REQ)) break block18;
                    String errMsg1 = hae.getMessage();
                    if (errMsg1 != null && errMsg1.length() > 0) {
                        ReportUtil.printError(errMsg1);
                    }
                    Trace.out((String)("\nHAHomeNotFoundEXCEPTION: \n" + hae));
                }
            }
            if (exeHome == null) {
                if (homeType.contentEquals(HA_HOME_REQ)) {
                    errDesc = new ErrorDescription("5307", s_msgBundle);
                    resultSet.addErrorDescription(errDesc);
                    ReportUtil.printError(errDesc.getErrorMessage());
                    resultSet.addResult(nodeList, 2);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)"\nReturning NULL HA (OracleRestart) home");
                    }
                    return null;
                }
            } else {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\nReturning HA (OracleRestart) home: " + exeHome));
                }
                validNodes.addAll(Arrays.asList(nodeList));
                return exeHome;
            }
        }
        if (homeType.contentEquals(CRS_HOME_REQ) || homeType.contentEquals(HA_OR_CRS_HOME_REQ) && exeHome == null) {
            String[] validNodeArr = null;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Attempt to get CRS home");
            }
            if ((exeHome = VerificationUtil.getCRSHome()) == null) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"Failed to retrieve CRS home");
                }
                errDesc = new ErrorDescription("5301", s_msgBundle);
                resultSet.addErrorDescription(errDesc);
                ReportUtil.printError(errDesc.getErrorMessage());
                resultSet.addResult(nodeList, 2);
                return null;
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\nReturning CRS home: " + exeHome));
            }
            if ((validNodeArr = VerificationUtil.getNodesWithCRSInstall(nodeList, resultSet)) == null) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"CRS is not installed on any given node");
                }
                resultSet.addResult(nodeList, 2);
                return null;
            }
            validNodes.addAll(Arrays.asList(validNodeArr));
            return exeHome;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Failed to retrieve HA (OracleRestart) orCRS home");
        }
        errDesc = new ErrorDescription("5321", s_msgBundle);
        resultSet.addErrorDescription(errDesc);
        ReportUtil.printError(errDesc.getErrorMessage());
        resultSet.addResult(nodeList, 2);
        return null;
    }

    public static boolean isCRSInstalledOnLocalNode() throws UnknownHostException {
        String localNd = VerificationUtil.getLocalHost();
        String[] ndList = new String[]{localNd};
        Vector<String> sucV = new Vector<String>(1);
        Vector<String> failV = new Vector<String>(1);
        return VerificationUtil.isCRSInstalled(ndList, sucV, failV);
    }

    public static boolean isCRSInstalled(String[] nodeList, Vector<String> succNodeVect, Vector<String> failNodeVect) {
        sVerificationUtil psVerUtil = new sVerificationUtil();
        succNodeVect.clear();
        failNodeVect.clear();
        String inventoryFile = null;
        OUIData ouid = null;
        try {
            inventoryFile = psVerUtil.getInventoryFileLocation();
            ouid = OUIData.getInstance(inventoryFile);
        }
        catch (InvalidOUIInventoryDataException e) {
            ReportUtil.printError(e.getMessage());
            Trace.out((Exception)e);
        }
        if (ouid == null) {
            Trace.out((String)"isCRSInstalled(): ERROR instantiating the OUIData object");
            for (int i = 0; i < nodeList.length; ++i) {
                failNodeVect.add(nodeList[i]);
            }
            return false;
        }
        for (int i = 0; i < nodeList.length; ++i) {
            String node = nodeList[i];
            if (ouid.isCRSInstalledOnNode(node)) {
                Trace.out((String)("CRS found installed  on node: " + node));
                succNodeVect.add(node);
                continue;
            }
            Trace.out((String)("CRS wasn't found installed  on node: " + node));
            failNodeVect.add(node);
        }
        return failNodeVect.size() == 0;
    }

    public static boolean isDirWritable(Collection<String> nodeList, String path, Collection<String> succNodes, Collection<String> failNodes) {
        String[] tempNodeList = nodeList.toArray(new String[nodeList.size()]);
        return VerificationUtil.pathExists(tempNodeList, path, 4, succNodes, failNodes);
    }

    public static boolean isDirWritable(String[] nodeList, String path, Collection<String> succNodes, Collection<String> failNodes) {
        return VerificationUtil.pathExists(nodeList, path, 4, succNodes, failNodes);
    }

    public static boolean isDirPathWritable(String[] nodeList, String path, Collection<String> succNodes, Collection<String> failNodes) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if (VerificationUtil.pathExists(nodeList, path, 4, succNodes, failNodes)) {
            return true;
        }
        if (VerificationUtil.pathExists(nodeList, path, 1, succNodes, failNodes)) {
            return false;
        }
        if (path.lastIndexOf(FSEP) == -1) {
            return false;
        }
        String parent = path.substring(0, path.lastIndexOf(FSEP));
        while (true) {
            Trace.out((String)("Checking path: '" + parent + "'"));
            if (VerificationUtil.pathExists(nodeList, parent, 4, succNodes, failNodes)) {
                return true;
            }
            if (VerificationUtil.pathExists(nodeList, parent, 1, succNodes, failNodes)) {
                return false;
            }
            if (parent.lastIndexOf(FSEP) == -1) {
                return false;
            }
            if (parent.length() == parent.lastIndexOf(FSEP) + 1) break;
            if ((parent = parent.substring(0, parent.lastIndexOf(FSEP))).charAt(parent.length() - 1) != ':') continue;
            parent = new String(parent + FSEP);
            Trace.out((String)("Added '" + FSEP + "' to: '" + parent + "'"));
        }
        return false;
    }

    private static boolean dirExists(Collection<String> nodeList, String path, Collection<String> succNodes, Collection<String> failNodes) {
        String[] tempNodeList = nodeList.toArray(new String[nodeList.size()]);
        return VerificationUtil.pathExists(tempNodeList, path, 1, succNodes, failNodes);
    }

    private static boolean pathExists(Collection<String> nodeList, String path, Collection<String> succNodes, Collection<String> failNodes) {
        String[] tempNodeList = nodeList.toArray(new String[nodeList.size()]);
        return VerificationUtil.pathExists(tempNodeList, path, 0, succNodes, failNodes);
    }

    public static boolean pathExists(String[] nodeList, String path, int pathType, Collection<String> succNodes, Collection<String> failNodes) {
        boolean succ;
        block10: {
            ClusterCmd clusterCmd = new ClusterCmd();
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"ENTRY");
            }
            succNodes.clear();
            failNodes.clear();
            try {
                succ = VerificationUtil.isLocalNodeOperation() ? clusterCmd.pathExists(new String[]{"localnode"}, path, pathType) : clusterCmd.pathExists(nodeList, path, pathType);
                if (!succ) break block10;
                for (int i = 0; i < nodeList.length; ++i) {
                    succNodes.add(nodeList[i]);
                }
            }
            catch (ClusterException ce) {
                Trace.out((String)("Exception occured: \n" + (Object)((Object)ce)));
                succ = false;
                for (int i = 0; i < nodeList.length; ++i) {
                    failNodes.add(nodeList[i]);
                }
            }
            catch (ClusterOperationException coe) {
                Trace.out((String)("Didn't expect ClusterOperationException " + (Object)((Object)coe)));
                succ = false;
                for (int i = 0; i < nodeList.length; ++i) {
                    try {
                        int status = coe.getStatus(nodeList[i]);
                        if (0 == status) {
                            succNodes.add(nodeList[i]);
                            continue;
                        }
                        failNodes.add(nodeList[i]);
                        if (2 != status) continue;
                        Trace.out((String)coe.getException(nodeList[i]).getMessage());
                        continue;
                    }
                    catch (NoSuchNodeException ns) {
                        Trace.out((String)("\n UNEXPECTED::: \n" + (Object)((Object)ns)));
                        failNodes.add(nodeList[i]);
                    }
                }
            }
        }
        return succ;
    }

    public static boolean checkDestLoc(String[] nodeList, ResultSet resultSet, Collection<String> succNodes, Collection<String> failNodes, boolean report) {
        ErrorDescription errDesc;
        String[] tempNodeList;
        Object[] args;
        Vector<String> wDLNodes = new Vector<String>();
        Vector<String> noWDLNodes = new Vector<String>();
        String destLoc = VerificationUtil.getDestLoc();
        String subDirPath = VerificationUtil.getCVUSubDirPath();
        ResultSet verResultSet = new ResultSet();
        Vector<String> incompatibleNodes = new Vector<String>();
        ClusterCmd clusterCmd = new ClusterCmd();
        Trace.out((String)("destloc is--->" + destLoc));
        Trace.out((String)("subDirPath is--->" + subDirPath));
        succNodes.clear();
        failNodes.clear();
        if (nodeList == null || nodeList.length == 0) {
            return false;
        }
        try {
            ClusterCmd cmd = new ClusterCmd();
            cmd.createDirWithModeOnNodes(nodeList, subDirPath);
        }
        catch (ClusterException e) {
            Trace.out((String)("ce exception occurred when trying to create CV_DESTLOC:" + e.getMessage()));
        }
        VerificationUtil.isDirWritable(nodeList, destLoc, wDLNodes, noWDLNodes);
        if (wDLNodes.size() > 0) {
            Vector<String> wSubDirNodes = new Vector<String>();
            Vector<String> noWSubDirNodes = new Vector<String>();
            VerificationUtil.isDirWritable(wDLNodes, subDirPath, wSubDirNodes, noWSubDirNodes);
            succNodes.addAll(wSubDirNodes);
            if (noWSubDirNodes.size() > 0) {
                Vector<String> subDirNodes = new Vector<String>();
                Vector<String> noSubDirNodes = new Vector<String>();
                VerificationUtil.dirExists(noWSubDirNodes, subDirPath, subDirNodes, noSubDirNodes);
                succNodes.addAll(noSubDirNodes);
                if (subDirNodes.size() > 0) {
                    if (report) {
                        args = new String[]{subDirPath};
                        ReportUtil.printError(s_msgBundle.getMessage("9013", false, args));
                        ReportUtil.sureprintNodelist(subDirNodes);
                    }
                    failNodes.addAll(subDirNodes);
                    tempNodeList = subDirNodes.toArray(new String[subDirNodes.size()]);
                    resultSet.addResult(tempNodeList, 2);
                    for (String node : subDirNodes) {
                        errDesc = new ErrorDescription(s_msgBundle.getMessage("7546", false, (Object[])new String[]{destLoc, node}), s_msgBundle.getMessage("7547", false, (Object[])new String[]{subDirPath}), s_msgBundle.getMessage("7548", false));
                        resultSet.addErrorDescription(node, errDesc);
                    }
                }
            }
        }
        if (noWDLNodes.size() > 0) {
            Vector<String> dLNodes = new Vector<String>();
            Vector<String> noDLNodes = new Vector<String>();
            VerificationUtil.pathExists(noWDLNodes, destLoc, dLNodes, noDLNodes);
            if (dLNodes.size() > 0) {
                failNodes.addAll(dLNodes);
                tempNodeList = dLNodes.toArray(new String[dLNodes.size()]);
                resultSet.addResult(tempNodeList, 2);
                if (report) {
                    args = new String[]{destLoc};
                    ReportUtil.printError(s_msgBundle.getMessage("9012", false, args));
                    ReportUtil.sureprintNodelist(dLNodes);
                }
                for (String node : dLNodes) {
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7546", false, (Object[])new String[]{destLoc, node}), s_msgBundle.getMessage("7549", false, (Object[])new String[]{destLoc}), s_msgBundle.getMessage("7548", false));
                    resultSet.addErrorDescription(node, errDesc);
                }
            }
            if (noDLNodes.size() > 0) {
                Vector<String> wParentNodes = new Vector<String>();
                Vector<String> noWParentNodes = new Vector<String>();
                String destLocParent = new File(destLoc).getParent();
                VerificationUtil.isDirWritable(noDLNodes, destLocParent, wParentNodes, noWParentNodes);
                succNodes.addAll(wParentNodes);
                if (noWParentNodes.size() > 0) {
                    failNodes.addAll(noWParentNodes);
                    tempNodeList = noWParentNodes.toArray(new String[noWParentNodes.size()]);
                    resultSet.addResult(tempNodeList, 2);
                    if (report) {
                        args = new String[]{destLoc};
                        ReportUtil.printError(s_msgBundle.getMessage("9014", false, args));
                        ReportUtil.sureprintNodelist(noWParentNodes);
                    }
                    for (String node : noWParentNodes) {
                        errDesc = new ErrorDescription(s_msgBundle.getMessage("7546", false, (Object[])new String[]{destLoc, node}), s_msgBundle.getMessage("7550", false, (Object[])new String[]{destLoc, node}), s_msgBundle.getMessage("7548", false));
                        resultSet.addErrorDescription(node, errDesc);
                    }
                }
            }
        }
        if (succNodes.size() > 0) {
            tempNodeList = succNodes.toArray(new String[succNodes.size()]);
            resultSet.addResult(tempNodeList, 1);
        }
        if (failNodes.size() > 0) {
            if (1 == nodeList.length) {
                args = null;
                if (report) {
                    ReportUtil.sureprintln(s_msgBundle.getMessage("9016", false, args));
                    ReportUtil.sureprintln(s_msgBundle.getMessage("0007", false));
                }
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7552", false, (Object[])new String[]{destLoc}));
                errDesc.setCause(s_msgBundle.getMessage("7553", false));
                errDesc.setAction(s_msgBundle.getMessage("7554", false));
                resultSet.addErrorDescription(errDesc);
            } else if (failNodes.size() == nodeList.length) {
                args = null;
                if (report) {
                    ReportUtil.sureprintln(s_msgBundle.getMessage("9016", false, args));
                    ReportUtil.sureprintln(s_msgBundle.getMessage("0007", false));
                }
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7551", false, (Object[])new String[]{destLoc}));
                errDesc.setCause(s_msgBundle.getMessage("7553", false));
                errDesc.setAction(s_msgBundle.getMessage("7554", false));
                resultSet.addErrorDescription(errDesc);
            } else if (report) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                ReportUtil.sureprintNodelist(new Vector<String>(succNodes));
            }
        }
        if (succNodes.size() == 0) {
            return false;
        }
        tempNodeList = succNodes.toArray(new String[succNodes.size()]);
        new GlobalExecution().getExectaskVer(tempNodeList, verResultSet);
        Trace.out((String)"VerificationUtil::   getExectaskVer() performed!!");
        succNodes.clear();
        failNodes.clear();
        incompatibleNodes.clear();
        VerificationUtil.checkGetExectaskVerResults(resultSet, verResultSet, succNodes, failNodes, incompatibleNodes, report);
        if (incompatibleNodes.size() != 0) {
            Trace.out((String)("The exectask is found to be incompatiable on nodes: " + VerificationUtil.strVect2List(incompatibleNodes)));
            tempNodeList = incompatibleNodes.toArray(new String[incompatibleNodes.size()]);
            for (int i = 0; i < tempNodeList.length; ++i) {
                String node;
                node = tempNodeList[i];
                boolean succ = false;
                try {
                    succ = clusterCmd.removeDirectory(new String[]{node}, subDirPath, true);
                    if (!succ) continue;
                    Trace.out((String)("Successfully deleted the contents of directory '" + subDirPath + "' on node '" + node + "'"));
                    Vector<String> newSuccNode = new Vector<String>();
                    Vector<String> newFailNode = new Vector<String>();
                    Vector<String> newIncompatibleNode = new Vector<String>();
                    Trace.out((String)("Populating destloc with new exectask on node :" + node));
                    new GlobalExecution().getExectaskVer(new String[]{node}, verResultSet);
                    VerificationUtil.checkGetExectaskVerResults(resultSet, verResultSet, newSuccNode, newFailNode, newIncompatibleNode, report);
                    if (newSuccNode.size() != 0) {
                        Trace.out((String)("Compatible exectask copied to node :" + node));
                        succNodes.add(node);
                        continue;
                    }
                    Trace.out((String)("Incompatible exectask. New exectask couldn't be copied to node :" + node));
                    failNodes.add(node);
                    continue;
                }
                catch (ClusterException ce) {
                    Trace.out((String)("Exception occured: \n" + (Object)((Object)ce)));
                    Trace.out((String)("Failure in deleting contents of directory '" + subDirPath + "' on node '" + node + "'"));
                    failNodes.add(node);
                    resultSet.addResult(node, 2);
                    if (report) {
                        ReportUtil.printError(s_msgBundle.getMessage("7546", false, (Object[])new String[]{destLoc, node}) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    }
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7546", false, (Object[])new String[]{destLoc, node}), s_msgBundle.getMessage("7555", false, (Object[])new String[]{subDirPath}), s_msgBundle.getMessage("7548", false));
                    resultSet.addErrorDescription(node, errDesc);
                }
            }
        }
        if (succNodes.size() == 0) {
            if (report) {
                ReportUtil.printError(s_msgBundle.getMessage("7560", false) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            }
            errDesc = new ErrorDescription(s_msgBundle.getMessage("7560", false));
            resultSet.addErrorDescription(errDesc);
        }
        return succNodes.size() == nodeList.length;
    }

    private static void checkGetExectaskVerResults(ResultSet resultSet, ResultSet verResultSet, Collection<String> succNodes, Collection<String> failNodes, Collection<String> incompatibleNodes, boolean report) {
        Hashtable t = verResultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                String exectaskVersion = (String)result.getResultInfoSet().firstElement();
                Trace.out((String)("Exectask version on node '" + node + "' is '" + exectaskVersion + '\"'));
                if (VerificationUtil.compatibleExectask(exectaskVersion)) {
                    Trace.out((String)("Compatible exectask found on node: " + node));
                    succNodes.add(node);
                    continue;
                }
                Trace.out((String)("Incompatible exectask found on node: " + node));
                incompatibleNodes.add(node);
                continue;
            }
            failNodes.add(node);
            resultSet.addResult(node, 2);
            Trace.out((String)("Exectask version couldn't be fetched from node: " + node));
            if (report) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("7559", false, (Object[])new String[]{node}));
            }
            ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("7559", false, (Object[])new String[]{node}));
            resultSet.addErrorDescription(node, errDesc);
        }
    }

    public static boolean isUserEquivalence(String[] nodeList, Vector<String> succNodeVect, Vector<String> failNodeVect) {
        succNodeVect.clear();
        failNodeVect.clear();
        ResultSet userEquivResultSet = new ResultSet();
        boolean userEquivResult = new GlobalExecution().checkUserEquiv(nodeList, userEquivResultSet);
        Trace.out((String)"VerificationUtil::   checkUserEquiv() performed!!");
        Hashtable t = userEquivResultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                succNodeVect.add(node);
                Trace.out((String)("User Equivalence exists on on node: " + node));
                continue;
            }
            failNodeVect.add(node);
            Trace.out((String)("User Equivalence couldn't be performed on node: " + node));
        }
        return failNodeVect.size() == 0;
    }

    public static String[] getUserEquivalentNodes(String[] nodeList, ResultSet resultSet) {
        String[] validNodeArr = nodeList;
        Vector<String> failNodeVect = new Vector<String>();
        Vector<String> succNodeVect = new Vector<String>();
        validNodeArr = VerificationUtil.getReachableNodes(nodeList, resultSet, true);
        if (validNodeArr == null || validNodeArr.length == 0) {
            return null;
        }
        boolean userEquivOnAll = VerificationUtil.isUserEquivalence(validNodeArr, succNodeVect, failNodeVect);
        if (!userEquivOnAll) {
            if (succNodeVect.size() == 0) {
                ReportUtil.printError(s_msgBundle.getMessage("4008", true) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                if (resultSet != null) {
                    resultSet.addResult(validNodeArr, 2);
                    ErrorDescription errDesc = new ErrorDescription("4008", s_msgBundle);
                    resultSet.addErrorDescription(errDesc);
                    for (int i = 0; i < validNodeArr.length; ++i) {
                        String node = validNodeArr[i];
                        errDesc = new ErrorDescription(s_msgBundle.getMessage("4098", true, (Object[])new String[]{node}), s_msgBundle, "4098");
                        resultSet.addErrorDescription(node, errDesc);
                    }
                }
                return null;
            }
            if (failNodeVect.size() != 0) {
                ReportUtil.printWarning(s_msgBundle.getMessage("4009", false));
                ReportUtil.sureprintNodelist(failNodeVect);
                ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                ReportUtil.sureprintNodelist(succNodeVect);
                String[] invalidNodeArr = failNodeVect.toArray(new String[failNodeVect.size()]);
                if (resultSet != null) {
                    resultSet.addResult(invalidNodeArr, 2);
                    if (invalidNodeArr != null && invalidNodeArr.length != 0) {
                        resultSet.addResult(invalidNodeArr, 2);
                        for (int i = 0; i < invalidNodeArr.length; ++i) {
                            String node = invalidNodeArr[i];
                            ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("4098", false, (Object[])new String[]{node}));
                            resultSet.addErrorDescription(node, errDesc);
                        }
                    }
                }
                validNodeArr = succNodeVect.toArray(new String[succNodeVect.size()]);
            }
        }
        if (resultSet != null) {
            resultSet.addResult(validNodeArr, 1);
        }
        return validNodeArr;
    }

    public static String[] getUserEquivalentNodes(String[] nodeList) {
        return VerificationUtil.getUserEquivalentNodes(nodeList, null);
    }

    public static boolean isUserEquivalenceOnNode(String node, boolean displayErr) {
        boolean nodeReachable = false;
        nodeReachable = VerificationUtil.areNodesReachable(new String[]{node}, new Vector<String>(), new Vector<String>());
        if (!nodeReachable) {
            if (displayErr) {
                ReportUtil.printError(s_msgBundle.getMessage("4097", false, (Object[])new String[]{node}));
            }
            return false;
        }
        if (!VerificationUtil.isUserEquivalence(new String[]{node}, new Vector<String>(), new Vector<String>())) {
            if (displayErr) {
                ReportUtil.printError(s_msgBundle.getMessage("4098", false, (Object[])new String[]{node}));
            }
            return false;
        }
        return true;
    }

    public static boolean areNodesReachable(String[] nodeList, Vector<String> succNodeVect, Vector<String> failNodeVect) {
        succNodeVect.clear();
        failNodeVect.clear();
        boolean[] nodeConArray = new boolean[nodeList.length];
        try {
            new VerifyNetwork().checkReachFromLocalNode(nodeList, nodeConArray);
        }
        catch (NetworkException e) {
            Trace.out((String)("NetworkException " + e));
        }
        Trace.out((String)"VerificationUtil::   checkReachFromSrcNode() performed!!");
        for (int i = 0; i < nodeList.length; ++i) {
            String node = nodeList[i];
            if (nodeConArray[i]) {
                succNodeVect.add(node);
                Trace.out((String)("Node '" + node + "' is reachable"));
                continue;
            }
            failNodeVect.add(node);
            Trace.out((String)("Node '" + node + "' is not reachable"));
        }
        return failNodeVect.size() == 0;
    }

    public static String[] getReachableNodes(String[] nodeList, ResultSet resultSet) {
        return VerificationUtil.getReachableNodes(nodeList, resultSet, true);
    }

    public static String[] getReachableNodes(String[] nodeList, ResultSet resultSet, boolean bShowErr) {
        String[] validNodeArr = nodeList;
        Vector<String> failNodeVect = new Vector<String>();
        Vector<String> succNodeVect = new Vector<String>();
        boolean allReachable = false;
        allReachable = VerificationUtil.areNodesReachable(nodeList, succNodeVect, failNodeVect);
        if (!allReachable) {
            if (succNodeVect.size() == 0) {
                if (bShowErr) {
                    ReportUtil.printError(s_msgBundle.getMessage("4095", true) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                }
                if (resultSet != null) {
                    ErrorDescription errDesc = new ErrorDescription("4095", s_msgBundle);
                    resultSet.addErrorDescription(errDesc);
                    resultSet.addResult(nodeList, 2);
                    if (nodeList != null && nodeList.length != 0) {
                        for (int i = 0; i < nodeList.length; ++i) {
                            String node = nodeList[i];
                            errDesc = new ErrorDescription(s_msgBundle.getMessage("4097", false, (Object[])new String[]{node}));
                            resultSet.addErrorDescription(node, errDesc);
                        }
                    }
                }
                return null;
            }
            if (failNodeVect.size() != 0) {
                if (bShowErr) {
                    ReportUtil.printWarning(s_msgBundle.getMessage("4096", false));
                    ReportUtil.sureprintNodelist(failNodeVect);
                    ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                    ReportUtil.sureprintNodelist(succNodeVect);
                }
                validNodeArr = succNodeVect.toArray(new String[succNodeVect.size()]);
            }
        }
        if (resultSet != null) {
            resultSet.addResult(validNodeArr, 1);
            String[] invalidArr = VerificationUtil.diffStringArr(nodeList, validNodeArr);
            if (invalidArr != null && invalidArr.length != 0) {
                resultSet.addResult(invalidArr, 2);
                for (int i = 0; i < invalidArr.length; ++i) {
                    String node = invalidArr[i];
                    ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("4097", false, (Object[])new String[]{node}), s_msgBundle, "4097");
                    resultSet.addErrorDescription(node, errDesc);
                }
            }
        }
        return validNodeArr;
    }

    public static String[] getReachableNodes(String[] nodeList) {
        return VerificationUtil.getReachableNodes(nodeList, null);
    }

    public static boolean isNodeReachable(String node) {
        Trace.out((String)("==== Checking rechability of node: " + node));
        String[] nodelist = new String[]{node};
        String[] noderslt = VerificationUtil.getReachableNodes(nodelist, null, false);
        return null != noderslt && noderslt.length != 0;
    }

    public static String[] getNodesWithCRSInstall(String[] nodeList, ResultSet resultSet) {
        String[] validNodeArr = nodeList;
        Vector<String> succNodeVect = new Vector<String>();
        Vector<String> failNodeVect = new Vector<String>();
        boolean crsInstallOnAll = VerificationUtil.isCRSInstalled(nodeList, succNodeVect, failNodeVect);
        if (!crsInstallOnAll) {
            if (succNodeVect.size() == 0) {
                ReportUtil.printError(s_msgBundle.getMessage("4037", false) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                if (resultSet != null) {
                    resultSet.addResult(nodeList, 2);
                    ErrorDescription errDesc = new ErrorDescription("4037", s_msgBundle);
                    resultSet.addErrorDescription(errDesc);
                    for (int i = 0; i < validNodeArr.length; ++i) {
                        String node = validNodeArr[i];
                        errDesc = new ErrorDescription("7593", new String[]{node}, s_msgBundle);
                        resultSet.addErrorDescription(node, errDesc);
                    }
                }
                return null;
            }
            if (failNodeVect.size() != 0) {
                ReportUtil.printWarning(s_msgBundle.getMessage("4038", false));
                ReportUtil.sureprintNodelist(failNodeVect);
                ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                ReportUtil.sureprintNodelist(succNodeVect);
                String[] invalidNodeArr = failNodeVect.toArray(new String[failNodeVect.size()]);
                if (resultSet != null) {
                    resultSet.addResult(invalidNodeArr, 2);
                    if (invalidNodeArr != null && invalidNodeArr.length != 0) {
                        resultSet.addResult(invalidNodeArr, 2);
                        for (int i = 0; i < invalidNodeArr.length; ++i) {
                            String node = invalidNodeArr[i];
                            ErrorDescription errDesc = new ErrorDescription("7593", new String[]{node}, s_msgBundle);
                            resultSet.addErrorDescription(node, errDesc);
                        }
                    }
                }
                validNodeArr = succNodeVect.toArray(new String[succNodeVect.size()]);
            }
        }
        if (resultSet != null) {
            resultSet.addResult(validNodeArr, 1);
            String[] invalidArr = VerificationUtil.diffStringArr(nodeList, validNodeArr);
            if (invalidArr != null && invalidArr.length != 0) {
                resultSet.addResult(invalidArr, 2);
            }
        }
        return validNodeArr;
    }

    public static String[] getNodesWithCRSInstall(String[] nodeList) {
        return VerificationUtil.getReachableNodes(nodeList, null);
    }

    public static String[] diffStringArr(String[] masterArr, String[] subArr) {
        Vector<String> resultVect = new Vector<String>();
        for (int i = 0; i < masterArr.length; ++i) {
            boolean toInclude = true;
            for (int j = 0; j < subArr.length; ++j) {
                if (!subArr[j].equals(masterArr[i])) continue;
                toInclude = false;
                break;
            }
            if (!toInclude) continue;
            resultVect.add(masterArr[i]);
        }
        return resultVect.toArray(new String[resultVect.size()]);
    }

    public static String getDaemonDisplayName(String daemonTag) {
        String daemonDispName;
        if (daemonTag.equalsIgnoreCase("crsd")) {
            daemonDispName = VDMUtil.getDaemonDisplayName("crsd");
            if (daemonDispName == null) {
                ReportUtil.printError(s_msgBundle.getMessage("9006", false) + LSEP);
            }
        } else if (daemonTag.equalsIgnoreCase("ocssd")) {
            daemonDispName = VDMUtil.getDaemonDisplayName("ocssd");
            if (daemonDispName == null) {
                ReportUtil.printError(s_msgBundle.getMessage("9007", false) + LSEP);
            }
        } else if (daemonTag.equalsIgnoreCase("evmd")) {
            daemonDispName = VDMUtil.getDaemonDisplayName("evmd");
            if (daemonDispName == null) {
                ReportUtil.printError(s_msgBundle.getMessage("9008", false) + LSEP);
            }
        } else {
            daemonDispName = daemonTag;
        }
        return daemonDispName;
    }

    public static String getDaemonInternalName(String daemonTag) {
        String daemonIntlName;
        if (daemonTag.equalsIgnoreCase("crsd")) {
            daemonIntlName = VDMUtil.getDaemonInternalName("crsd");
            if (daemonIntlName == null) {
                ReportUtil.printError(s_msgBundle.getMessage("9009", false) + LSEP);
            }
        } else if (daemonTag.equalsIgnoreCase("ocssd")) {
            daemonIntlName = VDMUtil.getDaemonInternalName("ocssd");
            if (daemonIntlName == null) {
                ReportUtil.printError(s_msgBundle.getMessage("9010", false) + LSEP);
            }
        } else if (daemonTag.equalsIgnoreCase("evmd")) {
            daemonIntlName = VDMUtil.getDaemonInternalName("evmd");
            if (daemonIntlName == null) {
                ReportUtil.printError(s_msgBundle.getMessage("9011", false) + LSEP);
            }
        } else {
            daemonIntlName = daemonTag;
        }
        return daemonIntlName;
    }

    public static MessageBundle getMessageBundle(String facility) {
        return MessageBundle.getMessageBundle((String)facility);
    }

    public static String getEnv(String envVar) {
        String value = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        NativeResult nativeRes = nativeSys.getEnvironment(envVar);
        value = nativeRes != null && nativeRes.getStatus() ? nativeRes.getStringResult() : null;
        if (Trace.isLevelEnabled((int)3)) {
            Trace.out((String)("==== getEnv reports: " + envVar + "=" + value));
        }
        return value;
    }

    public static String getUniqueDistributionID() {
        sVerificationUtil sUtil = new sVerificationUtil();
        String udid = sUtil.getUniqueDistributionID();
        if (udid == null || 0 == udid.trim().length()) {
            udid = VerificationUtil.getConfiguredValue(ASSUME_DISTID, true);
            if (udid == null) {
                udid = "unknown";
            }
            Trace.out((String)("==== Using default distribution ID: " + udid));
        }
        return udid;
    }

    public static String getOperatingSystemName() {
        return System.getProperty("os.name") + System.getProperty("os.version");
    }

    public static int compareVersions(String str1, String str2, String dlm) {
        VersionComparator versionComparator = new VersionComparator(dlm);
        return versionComparator.compare(str1, str2);
    }

    public static String getConfiguredValue(String var, boolean bFBToEnv) {
        ConfigUtil cu = ConfigUtil.getInstance();
        return cu.getConfiguredValue(var, bFBToEnv);
    }

    public static void getExecutionEnvironment() throws InvalidEnvironmentException {
        String destLoc = VerificationUtil.getDestLoc();
        if (!new File(destLoc).isAbsolute()) {
            throw new InvalidEnvironmentException(s_msgBundle.getMessage("9018", false, (Object[])new String[]{destLoc}));
        }
        VerificationUtil.setRDBMSVersion("11.2.0.1.0");
        Trace.out((String)("RDBMS Version is -->" + VerificationUtil.getRDBMSVersion()));
        sVerificationUtil.getExecutionEnvironment();
    }

    public static boolean compatibleExectask(String exectaskVersion) {
        Trace.out((String)("Comparing framework version '" + VerificationUtil.getFrameworkVersion() + "' with exectask version '" + exectaskVersion + "'"));
        return VerificationUtil.getFrameworkVersion().equals(exectaskVersion);
    }

    public static String getFrameworkVersion() {
        return VerificationUtil.getRDBMSVersion() + "." + "03_25_10";
    }

    public static String getRDBMSVersion() {
        return s_RDBMSVersion;
    }

    public static void setRDBMSVersion(String rdbmsVer) {
        s_RDBMSVersion = rdbmsVer;
    }

    public static String getRequestedRelease() {
        String reqRel = null;
        try {
            ParamManager pm = ParamManager.getInstance();
            reqRel = pm.getSinglePartArgVal(Argument.ARG_RELEASE);
            Trace.out((String)("==== Requested release is: " + reqRel));
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((Exception)e);
        }
        return reqRel;
    }

    public static String getCRSActiveVersion() {
        String actVersion = null;
        String crsHome = VerificationUtil.getCRSHome();
        if (crsHome == null) {
            Trace.out((String)"Bailing out because CRS home couldn't be obtained");
            return null;
        }
        Trace.out((String)("crsHome=" + crsHome));
        try {
            ClusterInfo cluInfo = new ClusterInfo(crsHome);
            actVersion = cluInfo.getCRSActiveVersionString();
        }
        catch (NoSuchCRSHomeException nche) {
            Trace.out((String)"Caught NoSuchCRSHomeException");
            VerificationUtil.reportException((Exception)((Object)nche));
        }
        catch (NoSuchExecutableException nsee) {
            Trace.out((String)"Caught NoSuchExecutableException");
            VerificationUtil.reportException((Exception)((Object)nsee));
        }
        catch (ClusterInfoException cie) {
            Trace.out((String)"Caught ClusterInfoException");
            VerificationUtil.reportException((Exception)((Object)cie));
        }
        Trace.out((String)("==== The active version for CRS is: " + actVersion));
        return actVersion;
    }

    public static String getCRSSoftwareVersion(String hostname) {
        String crsHome;
        String softVersion = null;
        String node = VerificationUtil.getNodeName(hostname);
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if ((crsHome = VerificationUtil.getCRSHome()) == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"ERROR: CRS home undefined.");
            }
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("crsHome=" + crsHome));
        }
        try {
            ClusterInfo cluInfo = new ClusterInfo(crsHome);
            softVersion = cluInfo.getCRSSoftwareVersionString(node);
        }
        catch (NoSuchCRSHomeException nche) {
            Trace.out((String)"Caught NoSuchCRSHomeException");
            VerificationUtil.reportException((Exception)((Object)nche));
        }
        catch (NoSuchExecutableException nsee) {
            Trace.out((String)"Caught NoSuchExecutableException");
            VerificationUtil.reportException((Exception)((Object)nsee));
        }
        catch (ClusterInfoException cie) {
            Trace.out((String)"Caught ClusterInfoException");
            VerificationUtil.reportException((Exception)((Object)cie));
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nThe software version for CRS on node '" + node + "' is: " + softVersion));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return softVersion;
    }

    public static Version getCRSSoftwareVersionObj() {
        String crsHome;
        Version softVersion = null;
        String softVerStr = null;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if ((crsHome = VerificationUtil.getCRSHome()) == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"ERROR: CRS home undefined.");
            }
            return null;
        }
        try {
            ClusterInfo cluInfo = new ClusterInfo(crsHome);
            softVerStr = cluInfo.getCRSSoftwareVersionString();
            if (softVerStr == null) {
                return null;
            }
        }
        catch (NoSuchCRSHomeException nche) {
            Trace.out((String)"Caught NoSuchCRSHomeException");
            VerificationUtil.reportException((Exception)((Object)nche));
            return null;
        }
        catch (NoSuchExecutableException nsee) {
            Trace.out((String)"Caught NoSuchExecutableException");
            VerificationUtil.reportException((Exception)((Object)nsee));
            return null;
        }
        catch (ClusterInfoException cie) {
            Trace.out((String)"Caught ClusterInfoException");
            VerificationUtil.reportException((Exception)((Object)cie));
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("CRS version string obtained: '" + softVerStr + "' "));
        }
        try {
            softVersion = Version.getVersion((String)softVerStr);
        }
        catch (ConfigurationException ce) {
            Trace.out((String)("Configuration Exception: \n" + ce.getMessage()));
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nThe version object for CRS on the local node is: " + softVersion.toString()));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return softVersion;
    }

    public static void setLocalNodeOperation(boolean isLocalNodeOper) {
        m_isLocalNodeOper = isLocalNodeOper;
    }

    public static boolean isLocalNodeOperation() {
        ParamManager pm = null;
        boolean localNode = false;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        try {
            pm = ParamManager.getInstance();
            if (pm.getMode() == ParamManager.OperationMode.MODE_API) {
                return m_isLocalNodeOper;
            }
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((Exception)e);
            return false;
        }
        if (m_isLocalNodeOperationChecked) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Returning saved value of: " + m_isLocal));
            }
            return m_isLocal;
        }
        m_isLocalNodeOperationChecked = true;
        Argument nodelistArg = pm.getArgument(Argument.ARG_NODELIST);
        if (nodelistArg != null) {
            String[] nodelist;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"nodelistArg not NULL");
            }
            try {
                nodelist = VerificationUtil.getNodelist();
            }
            catch (NodelistNotFoundException nlnfe) {
                nodelist = new String[]{};
            }
            if (nodelist.length == 1) {
                String localhost = null;
                try {
                    localhost = Utils.getLocalHost();
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\nComparing localhost '" + localhost + "' with nodelist[0] '" + nodelist[0] + "'\n"));
                    }
                    if (nodelist[0].equalsIgnoreCase(localhost)) {
                        localNode = true;
                        if (Trace.isLevelEnabled((int)5)) {
                            Trace.out((String)("Nodelist equal to localhost: " + localhost));
                        }
                    } else {
                        ClusterInfo cInfo;
                        if (Trace.isLevelEnabled((int)5)) {
                            Trace.out((String)"Nodelist not equal to localhost");
                        }
                        if (localhost.equalsIgnoreCase((cInfo = new ClusterInfo(VerificationUtil.getCRSHome())).getHostName(nodelist[0]))) {
                            localNode = true;
                            if (Trace.isLevelEnabled((int)5)) {
                                Trace.out((String)"localhost equal to cluster info host name.");
                            }
                        }
                    }
                }
                catch (UnknownHostException uhe) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)"UnknownHostException caught");
                    }
                }
                catch (ClusterInfoException cie) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)"ClusterInfoException caught");
                    }
                }
            }
        } else if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"nodelistArg IS NULL!!");
        }
        Argument referenceNodeArg = pm.getArgument(Argument.ARG_REFNODE);
        Argument sourceNodeArg = pm.getArgument(Argument.ARG_SRCNODE);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nnodelistArg is: '" + nodelistArg + "'" + "\nreferenceNodeArg is: '" + referenceNodeArg + "'" + "\nsourceNodeArg is: '" + sourceNodeArg + "'" + "\nlocalNode is: '" + localNode + "'"));
        }
        boolean bl = m_isLocal = (nodelistArg == null || localNode) && referenceNodeArg == null && sourceNodeArg == null;
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("m_isLocal is: '" + m_isLocal + "'"));
        }
        return m_isLocal;
    }

    public static boolean isLocalNode(String node) {
        block18: {
            String localNode;
            String localHost;
            String nodeName;
            block17: {
                int dotIdx;
                nodeName = null;
                localHost = null;
                localNode = null;
                if (Trace.isLevelEnabled((int)2)) {
                    Trace.out((String)"ENTRY");
                }
                nodeName = (dotIdx = node.indexOf(".")) != -1 ? node.substring(0, dotIdx) : node;
                try {
                    localHost = VerificationUtil.getLocalHost();
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\nComparing '" + nodeName + "' to localHOST '" + localHost + "'"));
                    }
                    if (nodeName.equalsIgnoreCase(localHost)) {
                        if (Trace.isLevelEnabled((int)2)) {
                            Trace.out((String)"EXIT - returning: true");
                        }
                        return true;
                    }
                }
                catch (UnknownHostException uhe) {
                    if (!Trace.isLevelEnabled((int)5)) break block17;
                    Trace.out((String)"UnknownHostException caught");
                }
            }
            if (VerificationUtil.sameHost(nodeName, localHost)) {
                return true;
            }
            try {
                if (!new ClusterwareInfo().isCRSConfigured()) break block18;
                try {
                    localNode = VerificationUtil.getLocalNodename();
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\nComparing '" + nodeName + "' to localNODE '" + localNode + "'"));
                    }
                    if (nodeName.equalsIgnoreCase(localNode)) {
                        if (Trace.isLevelEnabled((int)2)) {
                            Trace.out((String)"EXIT - returning: true");
                        }
                        return true;
                    }
                }
                catch (NodelistNotFoundException nlnfe) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)"NodelistNotFoundException caught");
                    }
                }
            }
            catch (InstallException e) {
                if (!Trace.isLevelEnabled((int)5)) break block18;
                Trace.out((String)("InstallException caught: " + (Object)((Object)e)));
            }
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Returning: false");
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return false;
    }

    public static boolean sameHost(String host1, String host2) {
        InetAddress[] inetArr1 = null;
        InetAddress[] inetArr2 = null;
        try {
            inetArr1 = InetAddress.getAllByName(host1);
            inetArr2 = InetAddress.getAllByName(host2);
        }
        catch (UnknownHostException e) {
            return false;
        }
        for (int i = 0; i < inetArr1.length; ++i) {
            for (int j = 0; j < inetArr2.length; ++j) {
                if (!inetArr1[i].getHostAddress().equals(inetArr2[j].getHostAddress())) continue;
                return true;
            }
        }
        Trace.out((String)("VerificationUtil::sameHost() Host:" + host1 + " and Host: " + host2 + " are not same."));
        return false;
    }

    public static boolean evaluateCondition(String condition) {
        boolean conditionValue = false;
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Evaluating the condition '" + condition + "'"));
        }
        if (s_conditionValueRepos.containsKey(condition)) {
            conditionValue = s_conditionValueRepos.get(condition);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"The condition value was set. condition = %s, value = %b", (Object[])new Object[]{condition, conditionValue});
            }
        } else {
            if (CRS_HOME_REQ.equals(condition)) {
                try {
                    return new ClusterwareInfo().isCRSConfigured();
                }
                catch (InstallException e) {
                    Trace.out((Exception)((Object)e));
                    return false;
                }
            }
            if (HA_HOME_REQ.equals(condition)) {
                try {
                    return new ClusterwareInfo().isHAConfigured();
                }
                catch (InstallException e) {
                    Trace.out((Exception)((Object)e));
                    return false;
                }
            }
            if (condition != null && condition.startsWith("PROCESSOR.")) {
                String arch = condition.substring("PROCESSOR.".length());
                String archRegEx = arch.replaceAll("x", ".*");
                archRegEx = archRegEx.replaceAll("X", ".*");
                String osarch = sVerificationUtil.getCurrentArch();
                return Pattern.compile(archRegEx, 2).matcher(osarch).matches();
            }
            conditionValue = sVerificationUtil.evaluateCondition(condition);
        }
        Trace.out((String)("evaluating condtion: CONDITION = " + condition + " VALUE=" + conditionValue));
        return conditionValue;
    }

    public static void setConditionValue(String condition, boolean value) {
        Trace.out((String)("setting condtion: CONDITION = " + condition + " VALUE=" + value));
        s_conditionValueRepos.put(condition, value);
    }

    public static void clearConditionValue(String condition) {
        Trace.out((String)("clearing condition: VAR = " + condition));
        s_conditionValueRepos.remove(condition);
    }

    public static String getPreReqXmlPath(VerificationType vfyType) throws XmlFilePathException {
        String reqRel = VerificationUtil.getRequestedRelease();
        if (reqRel == null) {
            reqRel = "11gR2";
        }
        return VerificationUtil.getPreReqXmlPath(vfyType, reqRel);
    }

    public static String getPreReqXmlPath(VerificationType vfyType, String reqRel) throws XmlFilePathException {
        File filePath;
        String xmlFilePath = s_preReqXmlRepos.get((Object)vfyType);
        if (xmlFilePath == null) {
            xmlFilePath = s_genericPreReqXmlFile;
            if (xmlFilePath == null) {
                xmlFilePath = sVerificationUtil.getPreReqXmlPath();
            }
            String xmlDirPath = null;
            if (xmlFilePath == null) {
                xmlDirPath = VerificationUtil.getPreReqDirPath(reqRel);
                xmlFilePath = xmlDirPath + VerificationUtil.getPreReqXmlFileName(vfyType);
            }
        }
        if (!(filePath = new File(xmlFilePath)).exists()) {
            throw new XmlFilePathException(xmlFilePath + " does not exist.");
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Pre-req xml file is: '" + xmlFilePath + "'"));
        }
        return xmlFilePath;
    }

    public static String getPreReqDirPath(String release) {
        String xmlDirPath = VerificationUtil.getEnv("CV_HOME");
        if (xmlDirPath == null) {
            xmlDirPath = System.getProperty("CV_HOME");
        }
        xmlDirPath = release == null ? xmlDirPath + "/cv/cvdata/" + "11gR2".toLowerCase() + "/" : xmlDirPath + "/cv/cvdata/" + release.toLowerCase() + "/";
        return xmlDirPath;
    }

    public static String getPreReqXmlFileName(VerificationType vfyType) {
        String preReqXmlFileName = null;
        switch (vfyType) {
            case PREREQ_CRS_INST: 
            case SYSREQ_CRS: 
            case PREREQ_NODE_ADD: {
                preReqXmlFileName = CV_CRS_PREREQ_XML;
                break;
            }
            case PREREQ_DB_INST: 
            case PREREQ_DB_CONFIG: 
            case PREREQ_SI_DB_INST: 
            case PREREQ_SI_DB_CONFIG: 
            case SYSREQ_DB: 
            case SYSREQ_SI_DB: {
                preReqXmlFileName = CV_DB_PREREQ_XML;
                break;
            }
            case PREREQ_SI_HA_INST: 
            case PREREQ_SI_HA_CONFIG: 
            case SYSREQ_SI_HA: {
                preReqXmlFileName = CV_HA_PREREQ_XML;
            }
        }
        return preReqXmlFileName;
    }

    public static String getPreReqXmlSchemaURI(String release) throws XmlFilePathException {
        String cvhome = VerificationUtil.getCVHome();
        String fsep = File.separator;
        String fullpath = new File(cvhome + "cv" + fsep + "cvdata" + fsep + "prereq.xsd").toURI().toString();
        Trace.out((String)("==== Pre-req schema file: " + fullpath));
        return fullpath;
    }

    public static boolean isPreReqSupported() throws VerificationException {
        String prereqFile = s_genericPreReqXmlFile;
        return VerificationUtil.isPreReqSupported(prereqFile);
    }

    public static boolean isPreReqSupported(VerificationType vfyType) throws VerificationException {
        try {
            String prereqFile = VerificationUtil.getPreReqXmlPath(vfyType);
            return VerificationUtil.isPreReqSupported(prereqFile);
        }
        catch (XmlFilePathException e) {
            throw new VerificationException(e);
        }
    }

    private static boolean isPreReqSupported(String prereqFile) throws VerificationException, PreReqNotSupportedException {
        try {
            XmlTaskFactory xmlTaskFactory = XmlTaskFactory.getInstance();
            xmlTaskFactory.getTasks(prereqFile, VerificationUtil.getUniqueDistributionID(), new String[]{VerificationUtil.getLocalHost()});
            return true;
        }
        catch (UnknownHostException e) {
            throw new VerificationException(e);
        }
        catch (XmlParserException e) {
            throw new VerificationException(e);
        }
    }

    public static String getCompSoftwareConfigXmlPath() throws XmlFilePathException {
        return VerificationUtil.getCompSoftwareConfigXmlPath("11gR2");
    }

    public static String getCompSoftwareConfigXmlPath(String release) throws XmlFilePathException {
        String xmlDirPath = VerificationUtil.getEnv("CV_HOME");
        if (xmlDirPath == null) {
            xmlDirPath = System.getProperty("CV_HOME");
        }
        xmlDirPath = release == null || "11gR2".equals(release) ? xmlDirPath + "/cv/cvdata/" : xmlDirPath + "/cv/cvdata/" + release.toLowerCase() + "/";
        String fullpath = xmlDirPath + "ora_software_cfg.xml";
        Trace.out((String)("==== Software Config data file: " + fullpath));
        return fullpath;
    }

    public static String getOSVersionCompatXmlPath() throws XmlFilePathException {
        String xmlFilePath = sVerificationUtil.getOSVersionCompatXmlPath();
        return xmlFilePath;
    }

    private static String resolveVariable(String name) {
        String value = null;
        if (s_variableValueRepos.containsKey(name)) {
            value = s_variableValueRepos.get(name);
            Trace.out((String)("pre-req variable found in the repository.var name=" + name + " value=" + value));
        } else {
            value = "TEMP_AREA".equalsIgnoreCase(name) ? System.getProperty("java.io.tmpdir") : ("INSTALL_USER".equalsIgnoreCase(name) ? System.getProperty("user.name") : ("BACKUP_USER".equalsIgnoreCase(name) ? System.getProperty("user.name") : sVerificationUtil.getVariableValue(name)));
        }
        return value;
    }

    public static String getVariableValue(String variable) {
        Pattern p = Pattern.compile("([^%]*)%([^%]+)%(.*)");
        Matcher m = p.matcher(variable);
        String returnValue = null;
        if (m.matches()) {
            while (m.matches()) {
                returnValue = m.group(1);
                String resolvableVar = m.group(2);
                String resolvedValue = VerificationUtil.resolveVariable(resolvableVar);
                if (resolvedValue == null) {
                    returnValue = null;
                    break;
                }
                returnValue = returnValue + resolvedValue;
                returnValue = returnValue + m.group(3);
                m = p.matcher(returnValue);
            }
        } else {
            returnValue = VerificationUtil.resolveVariable(variable);
        }
        Trace.out((String)("getting variable: VAR = " + variable + " VALUE=" + returnValue));
        return returnValue;
    }

    public static void setVariableValue(String varName, String varValue) {
        Trace.out((String)("setting variable: VAR = " + varName + " VALUE=" + varValue));
        String oldValue = s_variableValueRepos.put(varName, varValue);
    }

    public static void clearVariableValue(String varName) {
        Trace.out((String)("clearing variable: VAR = " + varName));
        s_variableValueRepos.remove(varName);
    }

    public static void setupTracingCVUHelper(boolean isCLImode) {
        VerificationUtil.setupTracing(isCLImode, CVUHELPER);
    }

    public static void setupTracing(boolean isCLImode) {
        VerificationUtil.setupTracing(isCLImode, CLUVFY);
    }

    public static void setupTracing(boolean isCLImode, int whoIsIt) {
        int tracingLvl;
        String traceFileName;
        String traceProp = System.getProperty("TRACING.ENABLED");
        String traceLvl = System.getProperty("TRACING.LEVEL");
        boolean tracetostdout = false;
        boolean saveTraceState = false;
        if (traceProp != null && traceProp.equalsIgnoreCase("false")) {
            Trace.setSavePreviousLog((boolean)false);
            return;
        }
        if (!isCLImode) {
            return;
        }
        if (null != System.getProperty("TRACING.STDOUT")) {
            tracetostdout = true;
        }
        System.setProperty("TRACING.ENABLED", "true");
        if (!tracetostdout) {
            saveTraceState = Trace.isTraceEnabled();
            Trace.traceEnabled((boolean)false);
        }
        if ((traceFileName = VerificationUtil.getTraceFile(whoIsIt)) == null) {
            Trace.traceEnabled((boolean)false);
            return;
        }
        if (!tracetostdout) {
            Trace.traceEnabled((boolean)saveTraceState);
        }
        Trace.setSavePreviousLog((boolean)true);
        if (traceLvl != null) {
            try {
                tracingLvl = Integer.parseInt(traceLvl);
            }
            catch (NumberFormatException e) {
                tracingLvl = 5;
            }
        } else {
            tracingLvl = 5;
        }
        Trace.enableTracing();
        Trace.setMaxLogOutputSize((int)2);
        Trace.setMaxLogOutputFiles((int)4);
        boolean conRes = Trace.configure((boolean)false, (boolean)tracetostdout, (boolean)true, (boolean)true, (String)traceFileName, (boolean)true);
        Trace.out((String)("Trace.configure returns " + conRes));
        Trace.setTraceLevel((int)tracingLvl);
        Trace.out((String)("tracing is on at level " + tracingLvl + " to file " + traceFileName));
    }

    private static String getTraceFile(int whoIsIt) {
        String errmsg;
        ClusterCmd clusterCmd;
        String traceFileName;
        String logDir;
        String fileSep;
        block20: {
            fileSep = System.getProperty("file.separator");
            logDir = VerificationUtil.getCVHome() + CV + fileSep + LOG;
            traceFileName = null;
            clusterCmd = new ClusterCmd();
            String traceLoc = VerificationUtil.getTraceLoc();
            if (traceLoc != null) {
                logDir = traceLoc;
            }
            errmsg = LSEP + s_msgBundle.getMessage("8503", false) + LSEP + s_msgBundle.getMessage("7728", false, (Object[])new String[]{logDir}) + LSEP;
            try {
                if (clusterCmd.isDirWritable(logDir)) break block20;
                File fLogDir = new File(logDir);
                try {
                    if (!fLogDir.exists()) {
                        try {
                            String[] lclNode = new String[]{VerificationUtil.getLocalHost()};
                            clusterCmd.createDirWithPermissionsOnNodes(lclNode, logDir, "775");
                        }
                        catch (UnknownHostException uhe) {
                            System.out.println(errmsg);
                            return traceFileName;
                        }
                        catch (ClusterException ce) {
                            System.out.println(errmsg);
                            return traceFileName;
                        }
                    }
                    if (clusterCmd.isDirWritable(logDir)) break block20;
                    String cmdToRun = "chmod 775 " + logDir;
                    try {
                        Runtime rt = Runtime.getRuntime();
                        Process proc = rt.exec(cmdToRun);
                        int ret = proc.waitFor();
                    }
                    catch (IOException e) {
                        System.out.println(errmsg);
                        return traceFileName;
                    }
                    catch (InterruptedException e) {
                        System.out.println(errmsg);
                        return traceFileName;
                    }
                }
                catch (SecurityException e) {
                    System.out.println(errmsg);
                    return traceFileName;
                }
                catch (ClusterException ce) {
                    System.out.println(errmsg);
                    return traceFileName;
                }
            }
            catch (ClusterException ce) {
                System.out.println(errmsg);
                return traceFileName;
            }
        }
        try {
            if (!clusterCmd.isDirWritable(logDir)) {
                System.out.println(errmsg);
                return traceFileName;
            }
        }
        catch (ClusterException ce) {
            System.out.println(errmsg);
            return traceFileName;
        }
        if (whoIsIt == CLUVFY) {
            traceFileName = logDir + fileSep + TRACE_CLUVFY_FNAME;
        } else if (whoIsIt == CVUHELPER) {
            traceFileName = logDir + fileSep + TRACE_CVUHELPER_FNAME;
        }
        if (Trace.isLevelEnabled((int)3)) {
            Trace.out((String)("Using trace file: '" + traceFileName + "'"));
        }
        return traceFileName;
    }

    public static long sizeInBytes(long size, StorageUnit unit) {
        switch (unit) {
            case BYTE: {
                return size;
            }
            case KBYTE: {
                return size * KILO_BYTE;
            }
            case MBYTE: {
                return size * MEGA_BYTE;
            }
            case GBYTE: {
                return size * GIGA_BYTE;
            }
            case TBYTE: {
                return size * TERA_BYTE;
            }
        }
        return -1L;
    }

    public static double sizeInBytes(double size, StorageUnit unit) {
        switch (unit) {
            case BYTE: {
                return size;
            }
            case KBYTE: {
                return size * 1024.0;
            }
            case MBYTE: {
                return size * 1024.0 * 1024.0;
            }
            case GBYTE: {
                return size * 1024.0 * 1024.0 * 1024.0;
            }
            case TBYTE: {
                return size * 1024.0 * 1024.0 * 1024.0 * 1024.0;
            }
        }
        return -1.0;
    }

    public static double sizeInSpecificUnit(long size, StorageUnit unit) {
        switch (unit) {
            case BYTE: {
                return size;
            }
            case KBYTE: {
                return size / KILO_BYTE;
            }
            case MBYTE: {
                return size / MEGA_BYTE;
            }
            case GBYTE: {
                return size / GIGA_BYTE;
            }
            case TBYTE: {
                return size / TERA_BYTE;
            }
        }
        return -1.0;
    }

    public static String getCompleteMessage(Throwable e) {
        Throwable nextCause;
        StringBuffer sb = new StringBuffer();
        Throwable thrw = e;
        sb.append(e.getMessage());
        while ((nextCause = thrw.getCause()) != null) {
            sb.append(LSEP + nextCause.getMessage());
            thrw = nextCause;
        }
        return sb.toString();
    }

    public static String[] getDefaultDiscoveryDevice() {
        return new sVerificationUtil().getDefaultDiscoveryDevice();
    }

    public static boolean containsWildCard(String path) {
        return new sVerificationUtil().containsWildCard(path);
    }

    public static String getFileListCommand() {
        return new sVerificationUtil().getFileListCommand();
    }

    public static List parseFileListOutput(String[] cmdOut) {
        return new sVerificationUtil().parseFileListOutput(cmdOut);
    }

    public static String getOraInventoryGroup() {
        return sVerificationUtil.getOraInventoryGroup();
    }

    public static String getUSMDriverStatePath() {
        return new String(VerificationUtil.getCRSHome() + FSEP + "bin" + FSEP + new sVerificationUtil().getUSMDriverScript());
    }

    public static String getUSMDeviceOwner() {
        return new sVerificationUtil().getUSMDeviceOwner();
    }

    public static String getDefaultUSMDevPerms() {
        return new sVerificationUtil().getDefaultUSMDevPerms();
    }

    public static boolean checkPlatform() {
        String osname = sVerificationUtil.getCurrentOS();
        String osarch = sVerificationUtil.getCurrentArch();
        return sVerificationUtil.checkPlatform(osname, osarch);
    }

    public static String getCurrentOS() {
        return sVerificationUtil.getCurrentOS();
    }

    public static String getCurrentArch() {
        return sVerificationUtil.getCurrentArch();
    }

    public static boolean checkPlatform(String osname, String osarch) {
        Trace.out((String)("Check Platform: osname=" + osname + " ; osarch=" + osarch));
        return sVerificationUtil.checkPlatform(osname, osarch);
    }

    public static boolean checkPlatformOS() {
        Trace.out((String)"Check Platform OS.");
        String osname = sVerificationUtil.getCurrentOS();
        return sVerificationUtil.checkPlatformOS(osname);
    }

    public static boolean checkPlatformOS(String osname) {
        Trace.out((String)("Check Platform OS: osname=" + osname));
        return sVerificationUtil.checkPlatformOS(osname);
    }

    public static String getSupportedOS() {
        return sVerificationUtil.getSupportedOS();
    }

    public static String getSupportedArch() {
        return sVerificationUtil.getSupportedArch();
    }

    public static String getInventoryConfigFilePointer() throws InventoryFilePointerException {
        String defaultInvPtr = sVerificationUtil.getInventoryConfigFilePointer();
        String invPtrProp = System.getProperty(ORA_INST_INVPTR_PROPERTY);
        String invPtr = defaultInvPtr;
        boolean crs_or_siha = true;
        try {
            ClusterwareInfo cluInfo = new ClusterwareInfo();
            if (!Cluster.isCluster() && !cluInfo.isHAConfigured()) {
                crs_or_siha = false;
            }
        }
        catch (InstallException ie) {
            Trace.out((Exception)((Object)ie));
            crs_or_siha = false;
        }
        if (crs_or_siha) {
            if (invPtrProp != null && !invPtrProp.equals(defaultInvPtr)) {
                throw new InventoryFilePointerException(s_msgBundle.getMessage("7608", false, (Object[])new String[]{ORA_INST_INVPTR_PROPERTY, defaultInvPtr, invPtrProp}));
            }
        } else if (invPtrProp != null && invPtrProp.length() != 0) {
            invPtr = invPtrProp;
        }
        return invPtr;
    }

    private static void reportException(Exception e) {
        String errMsg = e.getMessage();
        if (errMsg != null && errMsg.length() != 0) {
            ReportUtil.printError(errMsg);
        }
        Trace.out((Exception)e);
    }

    public static boolean isAbsoluteURI(String str) {
        return str.startsWith("file:") || str.startsWith("http:");
    }

    public static FixupGeneratorResult getFixupGeneratorResult() throws NoFixupGeneratorResultException {
        String fixupRootDir = VerificationUtil.getFixupRootDir();
        File fileRef = new File(fixupRootDir);
        if (fixupRootDir == null || fixupRootDir.length() == 0) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)(fixupRootDir == null ? "fixupRootDir is NULL" : "fixupRootDir is empty string"));
            }
            throw new NoFixupGeneratorResultException(s_msgBundle.getMessage("7508", false) + s_msgBundle.getMessage("7700", false));
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("fixupRootDir is: '" + fixupRootDir + "'"));
        }
        if (!fileRef.exists()) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Fixup root directory '" + fixupRootDir + "' does not exist"));
            }
            throw new NoFixupGeneratorResultException(s_msgBundle.getMessage("7707", false, (Object[])new String[]{fixupRootDir}));
        }
        if (!fileRef.isDirectory()) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Path for fixup root directory '" + fixupRootDir + "' is for a regular file"));
            }
            throw new NoFixupGeneratorResultException(s_msgBundle.getMessage("7508", false) + s_msgBundle.getMessage("7702", false, (Object[])new String[]{fixupRootDir}));
        }
        String[] nodeArr = fileRef.list();
        int nodeCount = nodeArr.length;
        if (nodeCount == 0) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("No fixups are generated in fixup root directory '" + fixupRootDir + "' "));
            }
            throw new NoFixupGeneratorResultException(s_msgBundle.getMessage("7708", false, (Object[])new String[]{fixupRootDir}));
        }
        String[] fixupFiles = new String[]{FIXUP_RESPONSE, FIXUP_ENABLE};
        HashSet<String> fixableNodes = new HashSet<String>();
        HashSet<String> nonFixableNodes = new HashSet<String>();
        FixupGeneratorResultImpl fixupGenResult = new FixupGeneratorResultImpl();
        String workDir = VerificationUtil.getCVUSubDirPath();
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("workDir is: '" + workDir + "'"));
        }
        for (int i = 0; i < nodeCount; ++i) {
            String[] elementList;
            String node = nodeArr[i];
            String fixupNodeDir = fixupRootDir + VerificationConstants.FSEP + node;
            fileRef = new File(fixupNodeDir);
            boolean fixupScriptsExist = true;
            if (!fileRef.isDirectory() || (elementList = fileRef.list()).length != 2) {
                if (!Trace.isLevelEnabled((int)5)) continue;
                Trace.out((String)("Path '" + fixupNodeDir + "' ignored; it is not a directory with two files"));
                continue;
            }
            for (int j = 0; j < 2; ++j) {
                if (elementList[0].equals(fixupFiles[j]) || elementList[1].equals(fixupFiles[j])) continue;
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("fixupFile '" + fixupNodeDir + VerificationConstants.FSEP + fixupFiles[j] + "' does not exist"));
                }
                fixupScriptsExist = false;
                break;
            }
            if (!fixupScriptsExist) continue;
            boolean allFixupScriptsCopied = true;
            for (int j = 0; j < 2; ++j) {
                String fixupFile = fixupRootDir + VerificationConstants.FSEP + node + VerificationConstants.FSEP + fixupFiles[j];
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("fixupFile being considered is: '" + fixupFile + "'"));
                }
                if (!(fileRef = new File(fixupFile)).exists()) {
                    if (!Trace.isLevelEnabled((int)5)) break;
                    Trace.out((String)("fixupFile '" + fixupFile + "' does not exist"));
                    break;
                }
                if (fileRef.isDirectory()) {
                    if (!Trace.isLevelEnabled((int)5)) break;
                    Trace.out((String)("fixupFile '" + fixupFile + "' is a directory"));
                    break;
                }
                String targetFile = workDir + fixupFiles[j];
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("targetFile is: '" + targetFile + "'"));
                }
                boolean fileCopied = false;
                String errMsg = s_msgBundle.getMessage("7709", false, (Object[])new String[]{fixupFile, targetFile, node});
                try {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("Attempt to copy fixup file '" + fixupFile + "' to file '" + targetFile + "' on node '" + node + "'"));
                    }
                    fileCopied = new ClusterCmd().copyFileToNodes(fixupFile, new String[]{node}, targetFile);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("Fixup file '" + fixupFile + "' was successfully copied to file '" + targetFile + "' on node '" + node + "'"));
                    }
                }
                catch (ClusterException e) {
                    errMsg = errMsg + VerificationConstants.LSEP + e.getMessage();
                }
                if (fileCopied) continue;
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)errMsg);
                }
                fixupGenResult.addErrorDescription(new ErrorDescription(errMsg, s_msgBundle, "7709"));
                allFixupScriptsCopied = false;
                nonFixableNodes.add(node);
            }
            if (!allFixupScriptsCopied) continue;
            fixableNodes.add(node);
        }
        fixupGenResult.setFixableNodes(fixableNodes);
        fixupGenResult.setNonFixableNodes(nonFixableNodes);
        if (fixableNodes.size() != 0) {
            fixupGenResult.setFixupScript(workDir + "runfixup.sh");
        }
        if (fixableNodes.size() == 0 && nonFixableNodes.size() == 0) {
            throw new NoFixupGeneratorResultException(s_msgBundle.getMessage("7708", false, (Object[])new String[]{fixupRootDir}));
        }
        return fixupGenResult;
    }

    public static void assertWritableDir(String path) throws InvalidPathException {
        if (path == null || path.length() == 0) {
            throw new InvalidPathException(s_msgBundle.getMessage("7517", true));
        }
        File fileRef = new File(path);
        if (!fileRef.isAbsolute()) {
            throw new InvalidPathException(s_msgBundle.getMessage("7518", true, (Object[])new String[]{path}));
        }
        if (!fileRef.isDirectory()) {
            throw new InvalidPathException(s_msgBundle.getMessage("7509", true, (Object[])new String[]{path}));
        }
        if (!fileRef.canWrite()) {
            throw new InvalidPathException(s_msgBundle.getMessage("0020", true, (Object[])new String[]{path}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void assertWritableOrCreatableDir(String path) throws InvalidPathException {
        if (path == null || path.length() == 0) throw new InvalidPathException(s_msgBundle.getMessage("7517", true));
        File fileRef = new File(path);
        if (!fileRef.isAbsolute()) throw new InvalidPathException(s_msgBundle.getMessage("7518", true, (Object[])new String[]{path}));
        if (!fileRef.exists()) {
            ClusterCmd clusterCmd = new ClusterCmd();
            try {
                String[] localNode = new String[]{VerificationUtil.getLocalHost()};
                clusterCmd.createDirWithPermissionsOnNodes(localNode, path, "755");
                return;
            }
            catch (UnknownHostException uhe) {
                throw new InvalidPathException(s_msgBundle.getMessage("7704", true, (Object[])new String[]{path}) + LSEP + uhe.getMessage());
            }
            catch (ClusterException ce) {
                throw new InvalidPathException(s_msgBundle.getMessage("7704", true, (Object[])new String[]{path}) + LSEP + ce.getMessage());
            }
        } else {
            if (!fileRef.isDirectory()) {
                throw new InvalidPathException(s_msgBundle.getMessage("7509", true, (Object[])new String[]{path}));
            }
            if (fileRef.canWrite()) return;
            throw new InvalidPathException(s_msgBundle.getMessage("0020", true, (Object[])new String[]{path}));
        }
    }

    public static void setPreReqXmlFile(String xmlFilePath) throws VerificationException {
        Trace.out((String)("setting xml file: PATH = " + xmlFilePath));
        s_genericPreReqXmlFile = xmlFilePath;
    }

    public static void setPreReqXmlFile(VerificationType prereqType, String xmlFilePath) throws VerificationException {
        Trace.out((String)("setting xml file: PATH = " + xmlFilePath + " verification type =" + (Object)((Object)prereqType)));
        s_preReqXmlRepos.put(prereqType, xmlFilePath);
    }

    public static String getCTSSCheckCommand() {
        String crshome = VerificationUtil.getCRSHome();
        if (crshome == null) {
            return null;
        }
        return crshome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + CTSS_CHECK_COMMAND;
    }

    public static float getCTSSOffsetLimit() {
        return sVerificationUtil.getCTSSOffsetLimit();
    }

    public static String getCTSSResStatCommand() {
        String crshome = VerificationUtil.getCRSHome();
        if (crshome == null) {
            return null;
        }
        return crshome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + CTSS_RES_QUERY_COMMAND;
    }

    public static String getVDiskPermissions() {
        return VDISK_DEFAULT_PERMISSIONS;
    }

    public static String getOCROwner() {
        return VDMUtil.getDefaultOcrOwner();
    }

    public static String getOCRPermissions() {
        return VDMUtil.getDefaultOcrPermissions();
    }

    public static boolean isASMPath(String inpath) {
        return inpath.contains(ASM_PATH_CHARACTER);
    }

    public static String getCvuqdiskRPMname() {
        return "cvuqdisk-1.0.7-1.rpm";
    }

    public static boolean isVersionPre(String version, int majorVersion, int minorVersion) {
        String versionSeparator = ".";
        String requiredVersion = Integer.toString(majorVersion) + versionSeparator + Integer.toString(minorVersion);
        return VerificationUtil.isVersionPre(version, requiredVersion);
    }

    public static boolean isVersionPre(String version, String requiredVersion) {
        String versionSeparator = ".";
        int comparisonResult = new VersionComparator(versionSeparator).compare(version, requiredVersion);
        return comparisonResult < 0;
    }

    public static boolean isVersionPost(String version, String requiredVersion) {
        String versionSeparator = ".";
        int comparisonResult = new VersionComparator(versionSeparator).compare(version, requiredVersion);
        return comparisonResult >= 0;
    }

    public static boolean isCVUTestEnv() {
        String sysprop = System.getProperty("CVU_TEST_ENV");
        if (sysprop == null || sysprop.trim().length() <= 0) {
            sysprop = VerificationUtil.getEnv("CVU_TEST_ENV");
        }
        return Boolean.parseBoolean(sysprop);
    }

    public static String getLoginShell() {
        return sVerificationUtil.getLoginShell();
    }

    public static boolean isUSMSupported() {
        return sVerificationUtil.isUSMSupported();
    }

    public static boolean isUDEVSupported() {
        return sVerificationUtil.isUDEVSupported();
    }

    static {
        s_variableValueRepos = Collections.synchronizedMap(new HashMap());
        s_conditionValueRepos = Collections.synchronizedMap(new HashMap());
        s_preReqXmlRepos = Collections.synchronizedMap(new HashMap());
        s_genericPreReqXmlFile = null;
    }
}

