/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sCommandsUtil {
    private String m_awk = "/bin/awk";
    private String m_grep = "/bin/grep";
    private String m_nslookup = "/usr/bin/nslookup";
    private String m_cat = "/bin/cat";
    private String m_df = "/bin/df";
    private String m_ping = "/bin/ping";
    private String m_cp = "/bin/cp";
    private String m_ls = "/bin/ls";
    private String m_nsswitch = "/etc/nsswitch.conf";

    public sCommandsUtil() {
        Trace.out((String)"Commands defined");
        String osName = VerificationUtil.getCurrentOS().toLowerCase();
        if (!osName.contentEquals("linux")) {
            if (osName.contentEquals("solaris") || osName.contentEquals("sunos")) {
                this.m_nslookup = "/usr/sbin/nslookup";
            } else if (!(osName.contentEquals("hp-ux") || osName.contentEquals("hp_ux") || osName.contentEquals("digital unix"))) {
                if (osName.contentEquals("aix")) {
                    this.m_nsswitch = "/etc/netsvc.conf";
                } else if (osName.contentEquals("intel_solaris") || osName.contentEquals("sinix_y") || osName.contentEquals("reliantunix_m") || osName.contentEquals("unix_alpha") || osName.contentEquals("dynix") || osName.contentEquals("dynix/ptx") || osName.contentEquals("unixware") || osName.contentEquals("nec") || osName.contentEquals("ux/4800") || osName.contentEquals("hitachi_ux") || osName.contentEquals("iris") || osName.contentEquals("ncos") || osName.contentEquals("openvms") || osName.contentEquals("ibm_mvs")) {
                    // empty if block
                }
            }
        }
    }

    public String getAwk() {
        Trace.out((String)("Returning '" + this.m_grep + "'"));
        return this.m_awk;
    }

    public String getGrep() {
        Trace.out((String)("Returning '" + this.m_grep + "'"));
        return this.m_grep;
    }

    public String getNslookup() {
        return this.m_nslookup;
    }

    public String getNsswitch() {
        return this.m_nsswitch;
    }

    public String getCat() {
        return this.m_cat;
    }

    public String getDf() {
        return this.m_df;
    }

    public String getPing() {
        return this.m_ping;
    }

    public String getCp() {
        return this.m_cp;
    }

    public String getLs() {
        return this.m_ls;
    }
}

