/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.io.File;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.ops.mgmt.command.registry.RegistryKeyData;
import oracle.ops.mgmt.command.registry.RegistryNativeResult;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.util.HAHomeNotFoundException;
import oracle.ops.verification.framework.util.InvalidEnvironmentException;
import oracle.ops.verification.framework.util.InvalidOUIInventoryDataException;
import oracle.ops.verification.framework.util.VerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class sVerificationUtil {
    private static final String INSTLOC_KEY = "HKEY_LOCAL_MACHINE\\SOFTWARE\\ORACLE";
    private static final String INSTLOC_VALUE = "inst_loc";
    private static final String INVENTORY_XML_PATH_EXTENSION = VerificationConstants.FILE_SEPARATOR + "ContentsXML" + VerificationConstants.FILE_SEPARATOR + "inventory.xml";
    static final String OS_VER_COMPAT_XML_FILENAME = "usm_oscompat.xml";
    static final String LS_C1_COMMAND = "DIR";
    static final String NEW_LINE_STRING = "\\n";
    static final String WILD_CARD_CHARACTER = "*";
    static final String DEFAULT_ASM_DISKS = "\\\\.\\ORCLDISK*";
    static final String UNSUPPORTED = "UNSUPPORTED";
    static final String USM_DRIVER_SCRIPT = "acfsdriverstate";
    static final String STR_USMDEV_OWNER = "root";
    static final String STR_USMDEV_PERMS = "0770";
    private static String m_supportedOSName = "Windows";
    private static String[] m_supportedArchs = new String[]{"AMD64"};
    private static final String OLR_CRS_HOME_PROPERTY = "crs_home";
    private static final String WINDOWS_OLR_LOCATION = "HKEY_LOCAL_MACHINE\\Software\\Oracle\\Olr";

    protected sVerificationUtil() {
    }

    protected String getInventoryFileLocation() throws InvalidOUIInventoryDataException {
        String invDirectory = sVerificationUtil.getInventoryConfigFilePointer();
        if (invDirectory == null) {
            throw new InvalidOUIInventoryDataException("Error in fetching registry key for inst_loc");
        }
        String configFileName = invDirectory + INVENTORY_XML_PATH_EXTENSION;
        File configFile = new File(configFileName);
        if (!configFile.exists()) {
            Trace.out((String)("Inventory Config File '" + configFileName + "'   doesn't exist"));
            throw new InvalidOUIInventoryDataException("Inventory Config File '" + configFileName + "'   doesn't exist");
        }
        Trace.out((String)("Inventory File Location is-->" + configFileName));
        return configFileName;
    }

    public static String getInventoryConfigFilePointer() {
        String invDirectory = null;
        try {
            ClusterWindows clusterWindows = new ClusterWindows();
            invDirectory = clusterWindows.getRegStringDataOnNode(INSTLOC_KEY, INSTLOC_VALUE);
        }
        catch (ClusterException ce) {
            Trace.out((String)("Error in fetching registry key for inst_loc" + VerificationConstants.LINE_SEPARATOR + ce.getMessage()));
        }
        Trace.out((String)("Inventory Directory is-->" + invDirectory));
        return invDirectory;
    }

    public static String getUniqueDistributionID() {
        String distID = System.getProperty("os.version");
        Trace.out((String)("==== UniqueDistributionID=" + distID));
        return distID;
    }

    public static void getExecutionEnvironment() throws InvalidEnvironmentException {
        VerificationUtil.setCurrentGroup("Administrators");
    }

    public static boolean evaluateCondition(String condition) {
        if ("OCFS".equalsIgnoreCase(condition)) {
            return sVerificationUtil.isOCFSConfigured();
        }
        Trace.out((String)("ERROR with CONDITION handling: '" + condition + "' is NOT handled by evaluateCondition() SOSD."));
        return false;
    }

    private static boolean isOCFSConfigured() {
        String ocfsRegKey = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\ocfs";
        RegistryNativeResult m_result = new RegistryNativeResult();
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        try {
            nativeSystem.regKeyExists(VerificationUtil.getLocalHost(), ocfsRegKey, (NativeResult)m_result);
            return m_result.getStatus();
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static String getOraInventoryGroup() {
        return null;
    }

    public static String getPreReqXmlPath() throws XmlFilePathException {
        String xmlFile = VerificationUtil.getEnv("CV_PREREQ_XML");
        if (xmlFile == null) {
            xmlFile = System.getProperty("CV_PREREQ_XML");
        }
        Trace.out((String)("Pre-req xml file is: '" + xmlFile + "'"));
        return xmlFile;
    }

    public static String getCompSoftwareConfigXmlPath() throws XmlFilePathException {
        String xmlFile = VerificationUtil.getEnv("CV_SOFTWARE_XML");
        if (xmlFile == null) {
            throw new XmlFilePathException("Unable to find the location for software distribution xml file." + VerificationConstants.LINE_SEPARATOR + "Set CV_SOFTWARE_XML environment variable to the correct location.");
        }
        Trace.out((String)("CV_SOFTWARE_XML file is: '" + xmlFile + "'"));
        return xmlFile;
    }

    public static String getOSVersionCompatXmlPath() {
        String xmlFile = VerificationUtil.getEnv("CV_OSVERCOMPAT_XML");
        if (xmlFile == null) {
            xmlFile = System.getProperty("CV_OSVERCOMPAT_XML");
        }
        if (xmlFile == null) {
            String s_fsep = System.getProperty("file.separator");
            String cvhome = VerificationUtil.getCVHome();
            xmlFile = cvhome + "cv" + s_fsep + "cvdata" + s_fsep + OS_VER_COMPAT_XML_FILENAME;
        }
        Trace.out((String)("====  File listing supported OS versions for USM: " + xmlFile));
        return xmlFile;
    }

    public static String getVariableValue(String name) {
        return null;
    }

    public String[] getDefaultDiscoveryDevice() {
        return new String[]{DEFAULT_ASM_DISKS};
    }

    public String getFileListCommand() {
        return LS_C1_COMMAND;
    }

    public List<String> parseFileListOutput(String[] cmdOut) {
        List<String> fList = Arrays.asList(cmdOut);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Size of parsed output list is = " + fList.size()));
            for (int i = 0; i < fList.size(); ++i) {
                Trace.out((String)("Output " + i + " : " + fList.get(i)));
            }
        }
        return fList;
    }

    public boolean containsWildCard(String path) {
        return path.contains(WILD_CARD_CHARACTER);
    }

    public String getUSMDriverScript() {
        return new String(USM_DRIVER_SCRIPT);
    }

    public String getUSMDeviceOwner() {
        return new String(STR_USMDEV_OWNER);
    }

    public String getDefaultUSMDevPerms() {
        return new String(STR_USMDEV_PERMS);
    }

    public static boolean checkPlatform(String osname, String osarch) {
        boolean match = false;
        for (String arch : m_supportedArchs) {
            if (!osarch.equalsIgnoreCase(arch)) continue;
            match = true;
        }
        Trace.out((String)("Match = " + match));
        if (osname.contains(m_supportedOSName) && match) {
            Trace.out((String)"Return value = true");
            return true;
        }
        Trace.out((String)"Return value = false");
        return false;
    }

    public static boolean checkPlatformOS(String osname) {
        if (osname.contains(m_supportedOSName)) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Return value = true");
            }
            return true;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Return value = false");
        }
        return false;
    }

    public static String getSupportedOS() {
        return m_supportedOSName;
    }

    public static String getSupportedArch() {
        return Arrays.toString(m_supportedArchs);
    }

    public static String getCurrentOS() {
        return System.getProperty("os.name");
    }

    public static String getCurrentArch() {
        String processorArch = VerificationUtil.getEnv("PROCESSOR_ARCHITECTURE");
        String processorArch6432 = VerificationUtil.getEnv("PROCESSOR_ARCHITEW6432");
        if (processorArch6432 == null || processorArch6432.length() == 0) {
            return processorArch;
        }
        return processorArch6432;
    }

    public static void setFileDirPerm(String permStr, String fileDir) {
    }

    public static float getCTSSOffsetLimit() {
        float f = 1000.0f;
        return f;
    }

    public static String getHAHomeWithException() throws HAHomeNotFoundException {
        try {
            String olrCrsHomePropertyValue = sVerificationUtil.getPropertyValue("localnode", WINDOWS_OLR_LOCATION, OLR_CRS_HOME_PROPERTY);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("crs_home=" + olrCrsHomePropertyValue));
            }
            return olrCrsHomePropertyValue;
        }
        catch (NativeException ne) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("NativeException is caught:" + ne.getMessage()));
            }
            throw new HAHomeNotFoundException(ne.getMessage());
        }
    }

    private static String getPropertyValue(String node, String configLocation, String propertyName) throws NativeException {
        String propertyValue = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        NativeResult nativeResult = new NativeResult();
        RegistryKeyData regData = new RegistryKeyData(configLocation, propertyName);
        String nodeName = "localnode".equalsIgnoreCase(node) ? null : node;
        regData.setDataType(10);
        if (nativeSys.regKeyExists(nodeName, configLocation, nativeResult)) {
            nativeResult.setStatus(false);
            nativeSys.regGetData(node, configLocation, propertyName, regData, nativeResult);
            if (nativeResult.getStatus()) {
                propertyValue = regData.getStringData();
            }
        } else if (!nativeResult.getStatus()) {
            Object[] args = new Object[]{propertyName, configLocation, node, nativeResult.getOSString()};
            throw new NativeException("1011", args);
        }
        return propertyValue;
    }

    public static String getLoginShell() {
        return null;
    }

    public static boolean isUSMSupported() {
        if (System.getProperty("os.arch").equalsIgnoreCase("AMD64") && (sVerificationUtil.getCurrentOS().equalsIgnoreCase("Windows Server 2003") || sVerificationUtil.getCurrentOS().equalsIgnoreCase("Windows 2003"))) {
            Trace.out((String)("ACFS supported on: " + sVerificationUtil.getCurrentOS() + " with architecture of: " + System.getProperty("os.arch")));
            return true;
        }
        Trace.out((String)("ACFS NOT supported on: " + sVerificationUtil.getCurrentOS() + " with architecture of: " + System.getProperty("os.arch")));
        return false;
    }

    public static boolean isUDEVSupported() {
        return false;
    }
}

