/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.util;

import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.ParsingException;

public class GenericUtil {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");

    public static String getValueByKey(String str, String key) throws ParsingException {
        boolean keyFound = false;
        String val = null;
        String nextKey = null;
        try {
            StringTokenizer st = new StringTokenizer(str, "<>");
            while (st.hasMoreTokens() && !keyFound) {
                String rest = st.nextToken();
                StringTokenizer stComma = new StringTokenizer(rest, ",");
                if (!stComma.hasMoreTokens() || !key.equalsIgnoreCase(nextKey = stComma.nextToken())) continue;
                keyFound = true;
                if (!stComma.hasMoreTokens()) continue;
                val = stComma.nextToken();
            }
        }
        catch (NullPointerException e) {
            Trace.out((String)"str is not of the right format");
            Trace.stackTrace((Throwable)e);
            throw new ParsingException(s_msgBundle.getMessage("9041", true, new Object[]{new String(str)}));
        }
        return val;
    }

    public static int getIntValueByKey(String str, String key) throws ParsingException {
        int val;
        try {
            val = Integer.parseInt(GenericUtil.getValueByKey(str, key));
        }
        catch (NumberFormatException e) {
            Trace.out((String)"str is not of the right format");
            Trace.stackTrace((Throwable)e);
            throw new ParsingException(s_msgBundle.getMessage("9041", true, new Object[]{new String(str)}));
        }
        return val;
    }

    public static String getNextStrNoCase(String line, String preStr, String delim) {
        int index = -1;
        String val = null;
        String line_lowered = line.toLowerCase();
        index = line_lowered.indexOf(preStr = preStr.toLowerCase());
        if (-1 != index) {
            line = line.substring(index + preStr.length());
            StringTokenizer st = null != delim ? new StringTokenizer(line, delim) : new StringTokenizer(line);
            if (st.hasMoreTokens()) {
                val = st.nextToken();
                val = val.trim();
            }
        }
        return val;
    }

    public static String getPreStrNoCase(String line, String postStr, String delim) {
        int index = -1;
        String val = null;
        String line_lowered = line.toLowerCase();
        index = line_lowered.indexOf(postStr = postStr.toLowerCase());
        if (-1 != index) {
            line = line.substring(0, index);
            StringTokenizer st = null != delim ? new StringTokenizer(line, delim) : new StringTokenizer(line);
            while (st.hasMoreTokens()) {
                val = st.nextToken();
            }
            if (null != val) {
                val = val.trim();
            }
        }
        return val;
    }

    public static String getMidStrNoCase(String line, String preStr, String postStr, String delim) {
        int index = -1;
        String val = null;
        String line_lowered = line.toLowerCase();
        index = line_lowered.indexOf(postStr = postStr.toLowerCase());
        if (-1 != index) {
            line = line.substring(0, index);
            val = GenericUtil.getNextStrNoCase(line, preStr, delim);
        }
        return val;
    }

    public static String getMidStrNoCase(String line, String tag) throws ParsingException {
        String preStr = "<" + tag + ">";
        String postStr = "</" + tag + ">";
        String lineLower = line.toLowerCase();
        preStr = preStr.toLowerCase();
        postStr = postStr.toLowerCase();
        try {
            int preIndex = lineLower.indexOf(preStr);
            if (-1 == preIndex) {
                Trace.out((String)("str = " + lineLower + ", didn't contain " + preStr));
                throw new ParsingException(s_msgBundle.getMessage("9041", true, new Object[]{new String(line)}));
            }
            int startIndex = preIndex + preStr.length();
            int postIndex = lineLower.indexOf(postStr, startIndex);
            if (-1 == postIndex) {
                Trace.out((String)("str = " + lineLower.substring(startIndex, lineLower.length()) + " didn't contain postStr:" + preStr));
                throw new ParsingException(s_msgBundle.getMessage("9041", true, new Object[]{new String(line)}));
            }
            String midStr = line.substring(startIndex, postIndex);
            return midStr;
        }
        catch (NullPointerException npe) {
            Trace.out((String)("Poblem parsing " + line + " with tag " + tag));
            Trace.out((Exception)npe);
            throw new ParsingException(npe);
        }
    }

    public static Vector getAllStrByTags(String fmtdStr, String beginTag, String endTag) throws ParsingException {
        String postStr = "<" + endTag + ">";
        String preStr = "<" + beginTag + ">";
        int postStrLen = postStr.length();
        int preStrLen = preStr.length();
        int postIndex = 0;
        int preIndex = 0;
        Vector<String> strList = new Vector<String>();
        String midStr = null;
        String withPreStr = null;
        preIndex = fmtdStr.indexOf(preStr);
        if (-1 == preIndex) {
            return strList;
        }
        try {
            fmtdStr = fmtdStr.substring(preIndex);
            while (0 < (postIndex = fmtdStr.indexOf(postStr))) {
                withPreStr = fmtdStr.substring(0, postIndex);
                if (!withPreStr.startsWith(preStr)) {
                    throw new ParsingException("Bad Format.");
                }
                midStr = withPreStr.substring(preStrLen);
                strList.add(midStr);
                fmtdStr = fmtdStr.substring(postIndex + postStrLen);
            }
        }
        catch (ParsingException pe) {
            Trace.out((Exception)pe);
            throw pe;
        }
        catch (Exception e) {
            Trace.out((Exception)e);
            throw new ParsingException(e);
        }
        return strList;
    }

    public static Vector getAllStrByTags(String fmtdStr, String tag) throws ParsingException {
        String beginTag = tag;
        String endTag = "/" + tag;
        return GenericUtil.getAllStrByTags(fmtdStr, beginTag, endTag);
    }

    public static String[] getFieldsByTags(String itemStr, String[] tags) throws ParsingException {
        String[] vals = new String[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            vals[i] = GenericUtil.getMidStrNoCase(itemStr, tags[i]);
        }
        return vals;
    }

    public static int[] getIntFieldsByTags(String itemStr, String[] tags) throws ParsingException {
        int[] vals = new int[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            vals[i] = Integer.parseInt(GenericUtil.getMidStrNoCase(itemStr, tags[i]));
        }
        return vals;
    }
}

