/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.util;

import java.util.Collection;
import java.util.Iterator;
import oracle.ops.verification.util.ClassifierTable;

public class MultiNodeException
extends Exception {
    private ClassifierTable m_table;
    protected static final String LSEP = System.getProperty("line.separator");

    public MultiNodeException() {
    }

    public MultiNodeException(String node, Throwable t) {
        this.addThrowable(node, t);
    }

    public void addThrowable(String node, Throwable t) {
        if (null == this.m_table) {
            this.m_table = new ClassifierTable();
        }
        this.m_table.put(node, t);
    }

    public Collection getThrowables(String node) {
        Collection throwables = null != this.m_table ? this.m_table.getSubGroup(node) : null;
        return throwables;
    }

    public Collection getThrowables() {
        return this.m_table.values();
    }

    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        if (null != this.m_table) {
            for (String node : this.m_table.keySet()) {
                sb.append(LSEP + node + ":");
                Iterator expIter = this.getThrowables(node).iterator();
                while (expIter.hasNext()) {
                    sb.append(LSEP);
                    Throwable t = (Throwable)expIter.next();
                    sb.append(t.getMessage());
                }
            }
        }
        return sb.toString();
    }
}

