/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilQuery;
import oracle.sysman.oii.oiil.OiilQueryException;

public class GetMaxSharedMemory
implements OiilQuery {
    public static final long MB = 1024L;

    public Object performQuery(Vector v) throws OiilQueryException {
        String[] nodes = (String[])OiilActionInputElement.getNamedParam((Vector)v, (String)"nodes");
        String location = (String)OiilActionInputElement.getNamedParam((Vector)v, (String)"location");
        int maxSharedMem = 0;
        ClusterCmd cc = new ClusterCmd();
        for (int i = 0; i < nodes.length; ++i) {
            try {
                long sharedMemForNode = cc.getFreeSpace(nodes[i], location) / 1024L;
                if (i == 0) {
                    maxSharedMem = (int)sharedMemForNode;
                }
                if (sharedMemForNode >= (long)maxSharedMem) continue;
                maxSharedMem = (int)sharedMemForNode;
                continue;
            }
            catch (ClusterException e) {
                maxSharedMem = 0;
                throw new OiilQueryException("Exception", e.getMessage());
            }
        }
        return maxSharedMem;
    }

    public static void main(String[] args) throws OiilQueryException {
        Vector<OiilActionInputElement> v = new Vector<OiilActionInputElement>();
        String[] Nodes = new String[]{"staju05", "staju06"};
        v.add(new OiilActionInputElement("nodes", (Object)Nodes));
        v.add(new OiilActionInputElement("SharedMemLocation", (Object)"/dev/shm"));
        GetMaxSharedMemory g = new GetMaxSharedMemory();
        System.out.println("Result:" + g.performQuery(v));
    }
}

