/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.activehelp;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.install.commons.activehelp.Callout;
import oracle.install.commons.activehelp.HelpInfo;
import oracle.install.commons.activehelp.IndicatorIcon;
import oracle.install.commons.swing.Glasspane;
import oracle.install.commons.util.IconLibrary;

class ActiveHelpIndicator
extends JComponent {
    private HelpInfo helpInfo;
    private Callout callout;
    private JComponent referer;
    private ImageIcon indicatorIcon;
    private Dimension size;
    private RefererListener refererListener;
    private JLayeredPane activeHelpPane = new JLayeredPane();
    private int zOrder;
    private Timer hoverTimer;

    public ActiveHelpIndicator() {
        this(null);
    }

    public ActiveHelpIndicator(ImageIcon indicatorIcon) {
        IconLibrary iconLib;
        if (indicatorIcon == null && (indicatorIcon = (iconLib = IconLibrary.getInstance()).getIcon("/oracle/install/commons/activehelp/resource/image/audit-assist.png")) == null) {
            indicatorIcon = new IndicatorIcon();
        }
        this.indicatorIcon = indicatorIcon;
        this.size = new Dimension(indicatorIcon.getIconWidth(), indicatorIcon.getIconHeight());
        this.refererListener = new RefererListener();
        this.callout = new Callout();
        this.hoverTimer = new Timer(375, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ActiveHelpIndicator.this.showCallout();
            }
        });
        this.hoverTimer.setRepeats(false);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                ActiveHelpIndicator.this.hoverTimer.start();
            }

            public void mouseExited(MouseEvent e) {
                ActiveHelpIndicator.this.hoverTimer.stop();
            }
        });
        this.setBounds(0, 0, this.size.width, this.size.height);
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                ActiveHelpIndicator.this.hideCallout();
            }
        });
        this.setVisible(false);
    }

    public Component addToActiveHelpPane(JComponent component) {
        Container parent = component.getParent();
        if (parent == null) {
            Glasspane glasspane = Glasspane.getInstance(this.referer);
            JComponent layer = glasspane.getLayer(this.zOrder);
            if (layer != this.activeHelpPane) {
                this.zOrder = glasspane.addLayer(this.activeHelpPane);
            }
            this.activeHelpPane.add((Component)component, JLayeredPane.PALETTE_LAYER);
            parent = this.activeHelpPane;
        }
        return parent;
    }

    public boolean isShowingHelp() {
        return this.callout.isVisible();
    }

    public HelpInfo getHelpInfo() {
        return this.helpInfo;
    }

    public void setHelpInfo(HelpInfo helpInfo) {
        this.helpInfo = helpInfo;
        this.callout.setHelpInfo(helpInfo);
    }

    private void showCallout() {
        this.addToActiveHelpPane(this.callout);
        this.callout.setHelpInfo(this.helpInfo);
        this.callout.setReferer(this.referer);
        this.callout.setVisible(true);
    }

    private void hideCallout() {
        this.callout.setReferer(null);
        this.callout.setHelpInfo(null);
        this.callout.setVisible(false);
    }

    public int getHeight() {
        return this.size.height;
    }

    public int getWidth() {
        return this.size.width;
    }

    public Dimension getSize() {
        return this.size;
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    protected void paintComponent(Graphics g) {
        this.indicatorIcon.paintIcon(this, g, 0, 0);
    }

    public void setReferer(JComponent referer) {
        if (this.referer != null) {
            this.referer.removeComponentListener(this.refererListener);
            this.hideCallout();
        }
        if (referer != null) {
            if (this.referer != referer) {
                this.referer = referer;
                this.referer.addComponentListener(this.refererListener);
                this.relocate(this.referer);
            }
        } else {
            this.referer = null;
            this.setVisible(false);
        }
    }

    public JComponent getReferer() {
        return this.referer;
    }

    private void relocate(JComponent referer) {
        Point referLocation = referer.getLocationOnScreen();
        Component parent = this.addToActiveHelpPane(this);
        if (parent != null) {
            SwingUtilities.convertPointFromScreen(referLocation, parent);
            if (referLocation.x - this.size.width > 0) {
                referLocation.translate(-this.size.width, 0);
            } else {
                referLocation.translate(referer.getWidth(), 0);
            }
            this.setLocation(referLocation);
        }
    }

    class RefererListener
    implements ComponentListener {
        RefererListener() {
        }

        public void componentHidden(ComponentEvent e) {
            ActiveHelpIndicator.this.hideCallout();
            ActiveHelpIndicator.this.setVisible(false);
        }

        public void componentMoved(final ComponentEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Component referer = e.getComponent();
                    ActiveHelpIndicator.this.relocate((JComponent)referer);
                }
            });
        }

        public void componentResized(final ComponentEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Component referer = e.getComponent();
                    ActiveHelpIndicator.this.relocate((JComponent)referer);
                    ActiveHelpIndicator.this.setVisible(true);
                }
            });
        }

        public void componentShown(ComponentEvent e) {
            ActiveHelpIndicator.this.setVisible(true);
        }
    }
}

