/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.driver.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.stream.StreamSource;
import oracle.install.commons.base.driver.common.InstallerErrorCode;
import oracle.install.commons.base.driver.common.InstallerException;
import oracle.install.commons.base.driver.common.ResponseFileSource;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.base.interview.common.util.PrereqExecutor;
import oracle.install.commons.base.resource.StringResourceBundle;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreUtils;
import oracle.install.commons.bean.xml.XmlBeanStoreFormat;
import oracle.install.commons.bean.xml.XmlBeanStoreFormatRegistry;
import oracle.install.commons.flow.FlowApplication;
import oracle.install.commons.flow.FlowBuilder;
import oracle.install.commons.flow.FlowConfigException;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowDataRecorder;
import oracle.install.commons.flow.FlowExecutionMode;
import oracle.install.commons.flow.FlowExecutor;
import oracle.install.commons.flow.FlowExecutorType;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ApplicationEvent;
import oracle.install.commons.util.ApplicationListener;
import oracle.install.commons.util.ExitStatus;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.exception.ApplicationException;
import oracle.install.commons.util.exception.ErrorInfo;
import oracle.install.commons.util.message.Content;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Installer
extends FlowApplication {
    private static final Logger logger = Logger.getLogger(Installer.class.getName());
    private boolean noVariblesPassedAtCmdLine = true;
    private boolean executePrereqs;
    private boolean silent;
    private PrereqExecutor prereqExecutor;
    private File responseFile;
    private boolean showUsageMode;

    public PrereqExecutor getPrereqExecutor() {
        return this.prereqExecutor;
    }

    public void setPrereqExecutor(PrereqExecutor prereqExecutor) {
        this.prereqExecutor = prereqExecutor;
    }

    @Override
    protected void showUsage() {
        Object setupDriver = SetupDriver.getInstance();
        ((SetupDriver)setupDriver).showUsage();
        this.showUsageMode = true;
    }

    @Override
    protected FlowExecutor getFlowExecutor() {
        return this.executePrereqs && this.prereqExecutor != null ? this.prereqExecutor : super.getFlowExecutor();
    }

    @Override
    protected void processArguments(List<String> args) throws IllegalArgumentException {
        Properties commandLineArgs;
        Iterator<String> i = args.iterator();
        while (i.hasNext()) {
            String command = i.next();
            if ("-textual".equals(command)) {
                this.setUIType(UIType.TEXTUAL);
                i.remove();
                continue;
            }
            if (!"-executePrereqs".equals(command)) continue;
            this.executePrereqs = true;
            i.remove();
        }
        Object setupDriver = SetupDriver.getInstance();
        ((SetupDriver)setupDriver).processCommandLine(args.toArray(new String[0]));
        if (args.contains("-silent")) {
            this.setUIType(UIType.NONE);
            this.silent = true;
        }
        this.noVariblesPassedAtCmdLine = (commandLineArgs = ((SetupDriver)setupDriver).getCommandLineArgs()) == null || commandLineArgs.isEmpty();
        int index = args.indexOf("-responseFile");
        if (index != -1) {
            if (index + 1 < args.size() && !args.get(index + 1).startsWith("-")) {
                this.responseFile = new File(args.get(index + 1));
            } else {
                ErrorInfo errorInfo = ErrorInfo.getInstance(InstallerErrorCode.RESPONSE_FILE_EXPECTED, new Object[0]);
                throw new IllegalArgumentException(errorInfo.getMessage());
            }
        }
        if (this.silent && !this.executePrereqs && this.noVariblesPassedAtCmdLine && this.responseFile == null) {
            ErrorInfo errorInfo = ErrorInfo.getInstance(InstallerErrorCode.RESPONSE_FILE_EXPECTED, new Object[0]);
            throw new IllegalArgumentException(errorInfo.getMessage());
        }
        super.processArguments(args);
    }

    @Override
    protected FlowContext loadFlow() throws FlowConfigException {
        FlowContext flowContext = super.loadFlow();
        Object setupDriver = SetupDriver.getInstance();
        Object setupBean = ((SetupDriver)setupDriver).getSetupBean();
        if (BeanStoreUtils.isBean(setupBean)) {
            flowContext.addBean(setupBean);
            try {
                Content content = BeanStoreUtils.createBeanGridContent(setupBean);
                content.setTitle("Initial values of Setup Properties");
                logger.log(Level.INFO, content.getContent());
            }
            catch (BeanStoreException e) {
                logger.log(Level.WARNING, "Failed while logging initial values of Setup Properties", e);
            }
        }
        return flowContext;
    }

    @Override
    protected void run() {
        System.setProperty("java.security.policy", Installer.class.getResource("installer.policy").toExternalForm());
        Object setupDriver = SetupDriver.getInstance();
        try {
            Resource resource = super.getResource("oracle.install.commons.base.resource.StringResourceBundle");
            Installer.showStatus(resource.getString("Installer.status.loadDriver", "Loading Setup Driver", new Object[0]));
            ((SetupDriver)setupDriver).load();
            Installer.showStatus(resource.getString("Installer.status.registerBean", "Registering Setup Bean", new Object[0]));
            FlowBuilder.getInstance().registerFlowData(((SetupDriver)setupDriver).getSetupBean());
            Runtime.getRuntime().addShutdownHook(new Thread((SetupDriver)setupDriver){
                final /* synthetic */ SetupDriver val$setupDriver;
                {
                    this.val$setupDriver = setupDriver;
                }

                public void run() {
                    try {
                        logger.log(Level.INFO, "Unloading Setup Driver");
                        this.val$setupDriver.unload();
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                    }
                }
            });
        }
        catch (SetupDriverException e) {
            throw new InstallerException((Throwable)e, InstallerErrorCode.INSTALLER_INIT_FAILED, new Object[0]);
        }
        FlowExecutorType executorType = this.silent ? FlowExecutorType.SILENT : FlowExecutorType.INTERACTIVE;
        FlowExecutionMode executionMode = FlowExecutionMode.NEW;
        super.setFlowDataDefaults(((SetupDriver)setupDriver).getCommandLineArgs());
        super.setExecutorType(executorType);
        super.setExecutionMode(executionMode);
        if (this.responseFile != null) {
            this.validateResponseFile(this.responseFile);
            try {
                logger.log(Level.INFO, "Setting Response file data to the Installer");
                super.setFlowDataSource(new ResponseFileSource(this.responseFile));
            }
            catch (FileNotFoundException e) {
                throw new InstallerException(e);
            }
            catch (MalformedURLException e) {
                throw new InstallerException(e);
            }
            catch (SecurityException e) {
                throw new InstallerException((Throwable)e, InstallerErrorCode.RESPONSE_FILE_NOT_ACCESSIBLE, this.responseFile);
            }
        }
        FlowDataRecorder flowDataRecorder = FlowDataRecorder.getInstance();
        flowDataRecorder.setFlowDataSource(this.getFlowDataSource());
        flowDataRecorder.setEnabled(true);
        super.run();
    }

    public void startup(String appConfig, String flowConfig, String ... args) throws ApplicationException {
        super.startup(appConfig, flowConfig, (String)null, (Properties)null, args);
    }

    public void validateResponseFile(File responseFile) throws InstallerException {
        if (responseFile == null) {
            throw new InstallerException(InstallerErrorCode.INVALID_RESPONSE_FILE, new Object[0]);
        }
        if (!responseFile.exists()) {
            throw new InstallerException(InstallerErrorCode.RESPONSE_FILE_NOT_FOUND, responseFile.getPath());
        }
        logger.log(Level.INFO, "Validating Response File {0}", responseFile);
        XmlBeanStoreFormatRegistry registry = XmlBeanStoreFormatRegistry.getInstance();
        XmlBeanStoreFormat format = null;
        try {
            format = registry.getFileFormat(responseFile);
        }
        catch (Exception e) {
            throw new InstallerException(e);
        }
        if (format == null) {
            registry = XmlBeanStoreFormatRegistry.getInstance();
            Object[] supportedFileExts = registry.getSupportFileExtensions();
            throw new InstallerException(InstallerErrorCode.UNKNOWN_RESPONSE_FILE_FORMAT, supportedFileExts);
        }
        try {
            format.validate(new StreamSource(responseFile));
        }
        catch (Exception e) {
            throw new InstallerException((Throwable)e, InstallerErrorCode.INVALID_RESPONSE_FILE, responseFile.getPath(), e.getMessage());
        }
    }

    @Override
    public synchronized void shutdown() {
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        if (platformInfo.isWindows() && (this.showUsageMode || Installer.isCommandLineSwitchEnabled("-silent")) && Boolean.getBoolean("oracle.installer.wait")) {
            super.addApplicationListener(new ApplicationListener(){

                public void update(ApplicationEvent e) {
                    Application application = Application.getInstance();
                    Resource resource = application.getResource(StringResourceBundle.class.getName());
                    String message = resource.getString("installer.exit.prompt", "\nPlease press Enter to exit...", new Object[0]);
                    System.out.print(message);
                    try {
                        System.in.read();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            });
        }
        super.shutdown();
    }

    public static abstract class CommandLineOption {
        public static final String EXECUTE_PREREQS = "-executePrereqs";
        public static final String SILENT = "-silent";
        public static final String RESPONSE_FILE = "-responseFile";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommonExitStatus implements ExitStatus
    {
        PREREQUISITES_NOT_MET(-3, Level.SEVERE),
        PREREQUISITES_IGNORED(-6, Level.WARNING);

        private int intValue;
        private Level level;

        private CommonExitStatus(int intValue, Level level) {
            this.intValue = intValue;
            this.level = level;
        }

        @Override
        public int getIntValue() {
            return this.intValue;
        }

        @Override
        public Level getLevel() {
            return this.level;
        }

        @Override
        public String getMessage() {
            Application application = Application.getInstance();
            return application.getString(this, new Object[0]);
        }
    }
}

