/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.interview.common.action;

import java.util.List;
import java.util.concurrent.Callable;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.install.commons.base.prereq.PrereqChecker;
import oracle.install.commons.flow.DefaultAction;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowControl;
import oracle.install.commons.flow.FlowDirection;
import oracle.install.commons.flow.FlowWorker;
import oracle.install.commons.flow.Route;
import oracle.install.commons.util.exception.ExceptionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPrereqAction
extends DefaultAction {
    private String[] targetNodes;
    private boolean standalone;

    public boolean isStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public String[] getTargetNodes() {
        return this.targetNodes;
    }

    public void setTargetNodes(String[] targetNodes) {
        this.targetNodes = targetNodes;
    }

    public abstract List<VerificationTask> getProductVerificationTasks(FlowContext var1) throws VerificationException;

    @Override
    public final void execute(FlowContext flowContext) {
        if (flowContext.getFlowDirection() != FlowDirection.FORWARD) {
            return;
        }
        try {
            final List<VerificationTask> tasks = this.getProductVerificationTasks(flowContext);
            if (tasks != null && !tasks.isEmpty()) {
                FlowWorker worker = FlowWorker.getInstance(flowContext);
                worker.perform(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        PrereqChecker prereqChecker = PrereqChecker.getInstance();
                        prereqChecker.setVerificationTasks(tasks.toArray(new VerificationTask[0]));
                        prereqChecker.verify();
                        return null;
                    }
                });
            } else {
                FlowControl flowControl = flowContext.getFlowControl();
                if (flowControl != null) {
                    flowControl.forward();
                }
            }
        }
        catch (VerificationException ve) {
            ExceptionManager.handle(ve);
        }
    }

    @Override
    public Route transition(FlowContext flowContext) {
        return Route.SUCCESS;
    }
}

