/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.interview.common.validator;

import java.io.File;
import oracle.install.commons.base.driver.common.Installer;
import oracle.install.commons.base.prereq.CompositePrereqCheckerJob;
import oracle.install.commons.base.prereq.PrereqChecker;
import oracle.install.commons.base.prereq.PrereqCheckerErrorCode;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.Validator;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.LogManager;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.progress.Status;

public class PrereqValidator
implements Validator {
    public void validate(FlowContext flowContext) throws ValidationException {
        PrereqChecker checker = PrereqChecker.getInstance();
        CompositePrereqCheckerJob job = checker.getVerificationJob();
        Status status = job.getStatus();
        if (status == Status.FAILED) {
            Application.addExitStatus(Installer.CommonExitStatus.PREREQUISITES_NOT_MET);
            LogManager logManager = LogManager.getInstance();
            File defaultLogFile = logManager.getDefaultLogFile();
            Severity failureSeverity = job.getFailureSeverity();
            if (failureSeverity == Severity.FATAL) {
                throw new ValidationException((ErrorCode)PrereqCheckerErrorCode.MANDATORY_PREREQUISITES_NOT_MET, defaultLogFile);
            }
            throw new ValidationException((ErrorCode)PrereqCheckerErrorCode.OPTIONAL_PREREQUISITES_NOT_MET, defaultLogFile);
        }
        Application.removeExitStatus(Installer.CommonExitStatus.PREREQUISITES_NOT_MET);
    }
}

