/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.interview.common.view;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import oracle.install.commons.base.prereq.PrereqChecker;
import oracle.install.commons.base.prereq.PrereqCheckerEvent;
import oracle.install.commons.base.prereq.PrereqCheckerListener;
import oracle.install.commons.base.prereq.ui.PrereqCheckerPane;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowControl;
import oracle.install.commons.flow.FlowDirection;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.swing.CardStack;
import oracle.install.commons.swing.CardStackRegistry;
import oracle.install.commons.util.progress.Status;

@ViewDef(id="PrereqUI")
public class PrereqGUI
implements View {
    private PrereqCheckerPane prereqCheckerPane = new PrereqCheckerPane();

    public Component getView() {
        return this.prereqCheckerPane;
    }

    public void onEvent(final FlowContext flowContext, EventType eventType) {
        final CardStack cardStack = CardStackRegistry.getCardStack("oracle.install.commons.flow.jewt.cardstack");
        switch (eventType) {
            case INIT: {
                cardStack.addCard(this.prereqCheckerPane.getDetailsPane(), "prereqcheckerpane.details");
                PrereqChecker prereqChecker = PrereqChecker.getInstance();
                prereqChecker.addPrereqCheckerListener(this.prereqCheckerPane);
                prereqChecker.addPrereqCheckerListener(new PrereqCheckerListener(){

                    public void update(PrereqCheckerEvent e) {
                        block10: {
                            FlowControl flowControl = flowContext.getFlowControl();
                            PrereqCheckerEvent.Type type = (PrereqCheckerEvent.Type)e.getType();
                            block0 : switch (type) {
                                case VERIFICATION_STARTED: {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            cardStack.showBlankCard();
                                        }
                                    });
                                    if (flowControl == null) break;
                                    flowControl.lock(true);
                                    break;
                                }
                                case VERIFICATION_COMPLETED: {
                                    Status status = e.getJob().getStatus();
                                    switch (status) {
                                        case SUCCEEDED: {
                                            if (flowControl != null) {
                                                flowControl.forward();
                                                break block0;
                                            }
                                            break block10;
                                        }
                                        case FAILED: {
                                            if (flowControl != null) {
                                                flowControl.lock(FlowDirection.BACKWARD, false);
                                            }
                                            SwingUtilities.invokeLater(new Runnable(){

                                                public void run() {
                                                    PrereqGUI.this.prereqCheckerPane.showFailedChecksOnly();
                                                    cardStack.showCard("prereqcheckerpane.details");
                                                }
                                            });
                                        }
                                    }
                                }
                            }
                        }
                    }
                });
                this.prereqCheckerPane.addPropertyChangeListener("PrereqCheckerPane.failedChecksIgnored", new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        boolean failedChecksIgnored = (Boolean)evt.getNewValue();
                        FlowControl flowControl = flowContext.getFlowControl();
                        flowControl.lock(FlowDirection.FORWARD, !failedChecksIgnored);
                    }
                });
                break;
            }
            case LOAD: {
                FlowControl flowControl = flowContext.getFlowControl();
                switch (flowContext.getFlowDirection()) {
                    case FORWARD: {
                        this.prereqCheckerPane.showProgress(true);
                        flowControl.lock(true);
                        break;
                    }
                    case BACKWARD: {
                        this.prereqCheckerPane.showAllChecks();
                        cardStack.showCard("prereqcheckerpane.details");
                        flowControl.lock(false);
                    }
                }
                break;
            }
            case UNLOAD: {
                cardStack.showBlankCard();
            }
        }
    }

    public void processInput(FlowContext flowContext) {
    }

    public void localize(FlowContext flowContext) {
    }
}

