/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.interview.common.view;

import java.awt.Component;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.driver.common.SetupDriverEvent;
import oracle.install.commons.base.driver.common.SetupDriverListener;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowControl;
import oracle.install.commons.flow.FlowDirection;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.swing.CardStack;
import oracle.install.commons.swing.CardStackRegistry;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.StatusControl;
import oracle.install.commons.util.progress.ProgressPane;

@ViewDef(id="SetupUI")
public class SetupGUI
implements View {
    private ProgressPane progressPage = new ProgressPane();

    public SetupGUI() {
        this.progressPage.setErrorReportingEnabled(true);
    }

    public Component getView() {
        return this.progressPage;
    }

    public void localize(FlowContext flowContext) {
    }

    public void onEvent(final FlowContext flowContext, EventType eventType) {
        CardStack cardStack = CardStackRegistry.getCardStack("oracle.install.commons.flow.jewt.cardstack");
        switch (eventType) {
            case INIT: {
                Object setupDriver = SetupDriver.getInstance();
                ((SetupDriver)setupDriver).addSetupDriverListener(new SetupDriverListener(){

                    public void update(SetupDriverEvent e) {
                        FlowControl flowControl = flowContext.getFlowControl();
                        switch (e.getStatus()) {
                            case SUCCEEDED: {
                                if (flowControl == null) break;
                                flowControl.forward();
                                break;
                            }
                            case FAILED: 
                            case SUCCEEDED_PARTIALLY: 
                            case INPROGRESS: {
                                flowControl.lock(FlowDirection.FORWARD, false);
                            }
                        }
                    }
                });
                ((SetupDriver)setupDriver).setProgressUI(this.progressPage);
                break;
            }
            case LOAD: {
                Application application = Application.getInstance();
                StatusControl statusControl = application.getStatusControl();
                if (statusControl != null) {
                    statusControl.close();
                }
                cardStack.showCard("oracle.install.commons.flow.jewt.billboard");
                break;
            }
            case UNLOAD: {
                cardStack.showBlankCard();
            }
        }
    }

    public void processInput(FlowContext flowContext) {
    }
}

