/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.prereq;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.ClusterVerification;
import oracle.cluster.verification.FixupGeneratorResult;
import oracle.cluster.verification.NoFixupGeneratorResultException;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResultSet;
import oracle.install.commons.base.prereq.PrereqChecker;
import oracle.install.commons.base.prereq.PrereqCheckerErrorCode;
import oracle.install.commons.base.prereq.PrereqCheckerException;
import oracle.install.commons.base.prereq.ui.FixupDialog;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.exception.ErrorCode;

public class DefaultPrereqChecker
extends PrereqChecker {
    private static final Logger logger = Logger.getLogger(DefaultPrereqChecker.class.getName());

    protected void prepareNodes(String ... nodes) throws VerificationException {
        VerificationResultSet resultSet;
        ClusterVerification cvu = ClusterVerification.getInstance();
        Application application = Application.getInstance();
        boolean tracingEnabled = application.getLogLevel() == Level.FINEST;
        cvu.setTracing(tracingEnabled);
        logger.log(Level.INFO, "CVU tracingEnabled = " + tracingEnabled);
        VerificationResultSet verificationResultSet = resultSet = nodes == null || nodes.length == 0 ? cvu.checkFrameworkSetup() : cvu.checkFrameworkSetup(nodes);
        if (resultSet != null) {
            OverallStatus status = resultSet.getOverallStatus();
            switch (status) {
                case VERIFICATION_FAILED: 
                case OPERATION_FAILED: {
                    StringBuffer buffer = new StringBuffer();
                    List errors = resultSet.getErrors();
                    for (VerificationError error : errors) {
                        buffer.append("- ").append(error.getCause()).append("\n");
                    }
                    logger.log(Level.INFO, "Preparation of nodes for running verifications failed. Reason:\n{0}", buffer.toString());
                    break;
                }
                default: {
                    logger.log(Level.INFO, "Nodes are prepared for verification.");
                }
            }
        }
    }

    public void verify() throws Exception {
        ClusterVerification cvu = ClusterVerification.getInstance();
        cvu.cleanupFixupRootDir();
        super.verify();
    }

    public void fix() throws PrereqCheckerException {
        block6: {
            Application application = Application.getInstance();
            UIType uiType = application.getUIType();
            if (uiType == UIType.GRAPHICAL) {
                ClusterVerification cvu = null;
                try {
                    cvu = ClusterVerification.getInstance();
                }
                catch (VerificationException e) {
                    throw new PrereqCheckerException(e);
                }
                try {
                    FixupGeneratorResult result = cvu.getFixupGeneratorResult();
                    String fixupScript = result.getFixupScript();
                    List failedNodes = result.getFixableNodes();
                    if (fixupScript == null || failedNodes == null || failedNodes.size() <= 0) break block6;
                    if (FixupDialog.showDialog(null, fixupScript, failedNodes) == 0) {
                        cvu.cleanupFixupRootDir();
                        break block6;
                    }
                    throw new PrereqCheckerException((ErrorCode)PrereqCheckerErrorCode.FIXUP_NOT_PERFORMED, new Object[0]);
                }
                catch (NoFixupGeneratorResultException e) {
                    throw new PrereqCheckerException((ErrorCode)PrereqCheckerErrorCode.FIXUP_ROUTINES_NOT_AVAILABLE, new Object[0]);
                }
            }
        }
    }
}

