/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.prereq;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.install.commons.base.prereq.CompositePrereqCheckerJob;
import oracle.install.commons.base.prereq.DefaultPrereqChecker;
import oracle.install.commons.base.prereq.PrereqCheckerErrorCode;
import oracle.install.commons.base.prereq.PrereqCheckerEvent;
import oracle.install.commons.base.prereq.PrereqCheckerException;
import oracle.install.commons.base.prereq.PrereqCheckerJob;
import oracle.install.commons.base.prereq.PrereqCheckerListener;
import oracle.install.commons.util.EventSupport;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.progress.JobHelper;

public abstract class PrereqChecker {
    private static final Logger logger = Logger.getLogger(PrereqChecker.class.getName());
    private static PrereqChecker instance = null;
    private CompositePrereqCheckerJob verificationJob;
    private VerificationTask[] verificationTasks;
    private String[] nodes;
    private boolean initialized;
    private EventSupport<PrereqCheckerEvent> eventSupport = new EventSupport();

    public static PrereqChecker getInstance() {
        if (instance == null) {
            ProxyFactory proxyFactory = ProxyFactory.getInstance();
            instance = proxyFactory.createProxy(PrereqChecker.class, new DefaultPrereqChecker());
        }
        return instance;
    }

    protected PrereqChecker() {
    }

    public String[] getNodes() {
        return this.nodes;
    }

    public void setNodes(String[] nodes) throws VerificationException {
        this.nodes = nodes;
        this.initialized = false;
        this.prepare(nodes);
    }

    public VerificationTask[] getVerificationTasks() {
        return this.verificationTasks;
    }

    public void setVerificationTasks(VerificationTask ... verificationTasks) {
        this.verificationTasks = verificationTasks;
        CompositePrereqCheckerJob verificationJob = this.buildVerificationJob(this.verificationTasks);
        this.eventSupport.fireEvent(new PrereqCheckerEvent(this, PrereqCheckerEvent.Type.TASKS_CHANGED, verificationJob));
    }

    public CompositePrereqCheckerJob getVerificationJob() {
        return this.verificationJob;
    }

    public final void prepare(String ... nodes) throws VerificationException {
        if (!this.initialized) {
            try {
                this.eventSupport.fireEvent(new PrereqCheckerEvent(this, PrereqCheckerEvent.Type.NODE_PREPARATION_STARTED));
                this.prepareNodes(nodes);
                this.initialized = true;
                this.eventSupport.fireEvent(new PrereqCheckerEvent(this, PrereqCheckerEvent.Type.NODE_PREPARATION_FINISHED));
            }
            catch (VerificationException e) {
                this.eventSupport.fireEvent(new PrereqCheckerEvent(this, PrereqCheckerEvent.Type.NODE_PREPARATION_FAILED));
                logger.log(Level.WARNING, "Failed while enabling tracing. Error: ", e);
                throw e;
            }
        }
    }

    protected abstract void prepareNodes(String ... var1) throws VerificationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify() throws Exception {
        CompositePrereqCheckerJob verificationJob;
        this.prepare(this.nodes);
        if (this.verificationTasks != null && this.verificationTasks.length > 0 && (verificationJob = this.getVerificationJob()) != null) {
            verificationJob.reset();
            verificationJob.calibrate();
            this.eventSupport.fireEvent(new PrereqCheckerEvent(this, PrereqCheckerEvent.Type.VERIFICATION_STARTED, verificationJob));
            try {
                JobHelper.executeJobs(verificationJob);
            }
            finally {
                this.eventSupport.fireEvent(new PrereqCheckerEvent(this, PrereqCheckerEvent.Type.VERIFICATION_COMPLETED, verificationJob));
            }
        }
    }

    public void fix() throws PrereqCheckerException {
        throw new PrereqCheckerException((ErrorCode)PrereqCheckerErrorCode.FIXUP_NOT_SUPPORTED, new Object[0]);
    }

    private CompositePrereqCheckerJob buildVerificationJob(VerificationTask ... verificationTasks) {
        this.verificationJob = new CompositePrereqCheckerJob();
        this.verificationJob.setId("root");
        this.verificationJob.setDescription("Checks");
        if (verificationTasks != null) {
            for (VerificationTask verificationTask : verificationTasks) {
                this.buildJobTree(this.verificationJob, verificationTask);
            }
        }
        return this.verificationJob;
    }

    private void buildJobTree(CompositePrereqCheckerJob parentJob, VerificationTask verificationTask) {
        block6: {
            if (verificationTask.hasSubtasks()) {
                try {
                    List subtasks = verificationTask.getSubtasks();
                    if (subtasks != null && subtasks.size() > 0) {
                        CompositePrereqCheckerJob job = new CompositePrereqCheckerJob(verificationTask);
                        parentJob.add(job);
                        for (VerificationTask subtask : subtasks) {
                            this.buildJobTree(job, subtask);
                        }
                        break block6;
                    }
                    parentJob.add(new PrereqCheckerJob(verificationTask));
                }
                catch (SubtasksUnavailableException e) {
                    parentJob.add(new PrereqCheckerJob(verificationTask));
                }
            } else {
                parentJob.add(new PrereqCheckerJob(verificationTask));
            }
        }
    }

    public void addPrereqCheckerListener(PrereqCheckerListener listener) {
        this.eventSupport.addEventListener(listener);
    }

    public void removePrereqCheckerListener(PrereqCheckerListener listener) {
        this.eventSupport.removeEventListener(listener);
    }
}

