/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.prereq;

import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationResultSet;
import oracle.cluster.verification.VerificationTask;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrereqCheckerJob
extends Job
implements Callable<VerificationResultSet> {
    public static final String PROPERTY_FIXABLE = "PrereqCheckerJob.fixable";
    private static Logger logger = Logger.getLogger(PrereqCheckerJob.class.getName());
    private VerificationTask verificationTask;
    private VerificationResultSet verificationResultSet;
    private boolean fixable;

    public PrereqCheckerJob(VerificationTask verificationTask) {
        super(verificationTask.getElementName(), verificationTask.getElementName(), 1.0f);
        this.verificationTask = verificationTask;
        logger.log(Level.INFO, "Creating PrereqChecker Job for leaf task " + verificationTask.getElementName());
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public VerificationResultSet getVerificationResultSet() {
        return this.verificationResultSet;
    }

    public void setVerificationResultSet(VerificationResultSet verificationResultSet) {
        this.verificationResultSet = verificationResultSet;
    }

    public VerificationTask getVerificationTask() {
        return this.verificationTask;
    }

    public boolean isFixable() {
        boolean fixable;
        block1: {
            String failedNode;
            List failedNodeList;
            fixable = false;
            if (this.verificationResultSet == null || (failedNodeList = this.verificationResultSet.getFailedNodes()) == null || failedNodeList.isEmpty()) break block1;
            Iterator i$ = failedNodeList.iterator();
            while (i$.hasNext() && !(fixable = this.isFixable(failedNode = (String)i$.next()))) {
            }
        }
        return fixable;
    }

    public void setFixable(boolean fixable) {
        if (this.fixable != fixable) {
            boolean oldValue = this.fixable;
            this.fixable = fixable;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_FIXABLE, oldValue, fixable);
        }
    }

    @Override
    public Callable<?> getWork() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerificationResultSet call() throws Exception {
        this.setStatus(Status.INPROGRESS);
        Status status = Status.FAILED;
        try {
            this.verificationResultSet = this.verificationTask.verify(true);
            if (this.verificationResultSet != null) {
                OverallStatus overallStatus = this.verificationResultSet.getOverallStatus();
                if (overallStatus != null) {
                    switch (overallStatus) {
                        case SUCCESSFUL: {
                            status = Status.SUCCEEDED;
                            break;
                        }
                        case OPERATION_FAILED: {
                            status = Status.FAILED;
                            break;
                        }
                        default: {
                            status = Status.FAILED;
                        }
                    }
                }
                this.logResults();
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, String.format("Unexpected error while performing check: %s", this.getDescription()), t);
        }
        finally {
            this.setStatus(status);
            Severity failureSeverity = null;
            if (status == Status.FAILED) {
                failureSeverity = Severity.FATAL;
                SeverityType severityType = this.verificationTask.getSeverity();
                if (severityType != null && severityType == SeverityType.IGNORABLE) {
                    failureSeverity = Severity.WARNING;
                }
            }
            this.setFailureSeverity(failureSeverity);
        }
        return this.verificationResultSet;
    }

    public Status getStatus(String node) {
        List successfulNodes;
        Status status = super.getStatus();
        if (this.verificationResultSet != null && (successfulNodes = this.verificationResultSet.getSuccessfulNodes()) != null && successfulNodes.contains(node)) {
            status = Status.SUCCEEDED;
        }
        return status;
    }

    public boolean isFixable(String node) {
        List failedNodes;
        boolean fixable = false;
        if (this.verificationResultSet != null && (failedNodes = this.verificationResultSet.getFailedNodes()) != null && failedNodes.contains(node)) {
            try {
                VerificationResult result = this.verificationResultSet.getNodeResult(node);
                if (result != null) {
                    fixable = result.isFixupAvailable();
                }
            }
            catch (NodeResultsUnavailableException e) {
                logger.log(Level.INFO, "Node result unavailable for node " + node);
            }
        }
        return fixable;
    }

    private void logResults() {
        List errors;
        logger.info("*********************************************");
        logger.info(this.verificationTask.getElementName() + ": " + this.verificationTask.getDescription());
        logger.info("Severity:" + this.verificationTask.getSeverity());
        logger.info("OverallStatus:" + this.verificationResultSet.getOverallStatus());
        try {
            List nodeResults = this.verificationResultSet.getNodeResults();
            if (nodeResults != null) {
                for (VerificationResult result : nodeResults) {
                    logger.info("-----------------------------------------------");
                    logger.info("Verification Result for Node:" + result.getNode());
                    logger.info("Expected Value:" + result.getExpectedValue());
                    logger.info("Actual Value:" + result.getActualValue());
                    List errors2 = result.getErrors();
                    if (errors2 != null) {
                        for (VerificationError error : errors2) {
                            logger.info("Error Message:" + error.getErrorMessage());
                            logger.info("Cause:" + error.getCause());
                            logger.info("Action:" + error.getAction());
                        }
                    }
                    logger.info("-----------------------------------------------");
                }
            }
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
        }
        if (this.verificationResultSet.getOverallStatus() != OverallStatus.SUCCESSFUL && (errors = this.verificationResultSet.getErrors()) != null) {
            for (VerificationError error : errors) {
                logger.info("Error Message:" + error.getErrorMessage());
                logger.info("Cause:" + error.getCause());
                logger.info("Action:" + error.getAction());
            }
        }
    }
}

